/***********************************************************************************
 File:			DurRam.h
 Module:		RAM DUR
 Purpose: 		
 Description:	defines the RAM of the PAC_DUR
************************************************************************************/
#ifndef PAC_DUR_RAM_H_
#define PAC_DUR_RAM_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "lmi.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define PAC_DUR_RAM_MCS_OUT_SIZE (HW_NUM_OF_VAPS + 1)
#define PAC_DUR_RAM_MCS_OUT_GENERAL_VAP_INDEX (HW_NUM_OF_VAPS)

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

typedef struct AutoReplyFrameAndSifsAirTime_t_
{
	union
	{
		uint32 word0;
		struct
		{
			uint32 ackOrCtsAirTime11B	:10;
			uint32 ackOrCtsAirTime11AG	:10;
			uint32 baAirTime11AG		:10;
			uint32 reserved0			:2;
		};
	};
	union
	{
		uint32 word1;
		struct
		{
			uint32 reserved1			:32;
		};
	};	
} AutoReplyFrameAndSifsAirTime_t;

typedef struct AutoReplyBaAndSifs11axAirTime_t_
{
	union
	{
		uint32 word0;
		struct
		{
			uint32 cba256BitAirTimeSifs11AxSu	: 10; //bits [0..9]
			uint32 mbaConstAitTimeSifs11AxSu	: 10; //bits [10..19]
			uint32 mbaPreTidAitTime11AxSu		: 10; //bits [20..29]
			uint32 reserved0					: 2;  //bits [30..31]
		};
	};
	union
	{
		uint32 word1;
		struct
		{
			uint32 reserved1			: 32;
		};
	};
}AutoReplyBaAndSifs11axAirTime_t;

typedef struct AutoReplyPower11Ag
{
	union
	{
		uint32 word0;
		struct
		{
			uint32 txPower11AGBw20  :8;
			uint32 txPower11AGBw40  :8;
			uint32 txPower11AGBw80  :8;
			uint32 txPower11AGBw160 :8;
		};
	};
} AutoReplyPower11Ag_t;

typedef struct AutoReplyPower11b
{
	union
	{
		uint32 word0;
		struct
		{
			uint32 txPower11bMcso0	:8;
			uint32 txPower11bMcso1	:8;
			uint32 txPower11bMcso2	:8;
			uint32 txPower11bMcso3	:8;
		};

	};
	union
	{
		uint32 word1;
		struct
		{
			uint32 txPower11bMcso4	:8;
			uint32 txPower11bMcso5	:8;
			uint32 txPower11bMcso6	:8;
			uint32 txPower11bMcso7	:8;
		};
	};
}AutoReplyPower11b_t;

#endif /* PAC_DUR_RAM_H_ */


