/***********************************************************************************
 File:			PacDur.h
 Module:		Hw drivers
 Purpose: 		Create a SW interface for all HW PAC modules 
 Description:	This file contains all the definitions and the structures of the PAC 
 				DUR	driver which is responsible to configure the PAC Duration HW 
 				module
************************************************************************************/
#ifndef PAC_DUR_H_
#define PAC_DUR_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Pac_Api.h"
#include "DurRam.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define PAC_DUR_NAV_SET_NO_UPDATE	0x0
#define PAC_DUR_NAV_SET_UPDATE		0x2
#define PAC_DUR_NAV_SET_RESET		0x3
#define PAC_DUR_NAV_SET_ENTRY_SHIFT	0x1
#define PAC_DUR_NAV_SET_ENTRY_MASK	0xF

/* There are 3 registers with 16 entries each (in the last register only the first 2 entries are valid). Each entry is 2 bits. the code 
   here calculates the location of each line in the RXD in the register : (line number % 16 ) * 2 is equal to the number of the 
   starting bit of the entry. */
   

/* Register 0 */
#define PAC_DUR_NAV_RESET_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER  ((RCD_NAV_RESET & PAC_DUR_NAV_SET_ENTRY_MASK) << PAC_DUR_NAV_SET_ENTRY_SHIFT)

/* Register 1 */
#define PAC_DUR_MULTI_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER      ((RCD_MULTI & PAC_DUR_NAV_SET_ENTRY_MASK) << PAC_DUR_NAV_SET_ENTRY_SHIFT)
#define PAC_DUR_NAV_LOAD_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER   ((RCD_NAV_LOAD & PAC_DUR_NAV_SET_ENTRY_MASK) << PAC_DUR_NAV_SET_ENTRY_SHIFT)

/* Register 2 */
/* empty */

/* Configuration of lines */
#define PAC_DUR_NAV_SET_RXD_LINES_0_TO_15_INIT_VALUE   (PAC_DUR_NAV_SET_RESET << PAC_DUR_NAV_RESET_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER)
#define PAC_DUR_NAV_SET_RXD_LINES_16_TO_31_INIT_VALUE  ((PAC_DUR_NAV_SET_UPDATE << PAC_DUR_MULTI_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER) | \
														(PAC_DUR_NAV_SET_UPDATE << PAC_DUR_NAV_LOAD_EVENT_LINE_LOCATION_IN_NAV_SET_REGISTER))
														
#define PAC_DUR_NAV_SET_RXD_LINES_32_TO_33_INIT_VALUE   0


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

/* Klocwork:
autoReplyPower11BValues has uint32 word0 and uint32 word1. (bitmapped to 8 number of 8bit variables)
txPower11BAddress = ((uint8*)&autoReplyPower11BValues.word0) + autoReplyRate;
Here the pointer is moved to program 1 of the 8 bitmapped variables, but klocwork sees this as memory overrun, but we are doing it intentionally.
By adding uint8 Power11bValues[LM_PHY_11A_MAX_RATES]; inside union with the AutoReplyPower11b_t, and using the pointer we are doing the same pointer manipulation in a controlled way.*/

typedef union AutoReplyPower11bu
{
	uint8 Power11bValues[LM_PHY_11A_MAX_RATES];
	AutoReplyPower11b_t autoReplyPower11BValues;
} AutoReplyPower11b_u;


#endif /* PAC_DUR_H_ */


