/***********************************************************************************
 File:			RxcRam.h
 Module:		Rxc
 Purpose: 		To create RXC driver which handles Rx packets after the filtering
 Description:	This file contains the definitions of the RAM of the RXC module which 
 				is responsible of handling Rx packets after the filtering
************************************************************************************/
#ifndef RXC_RAM_H_
#define RXC_RAM_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#if defined (ENET_INC_LMAC0)
#define RXC_RXF_MEM_BASE_ADDR_PER_BAND	B0_RXF_MEM_BASE_ADDR
#endif
#if defined (ENET_INC_LMAC1)
#define RXC_RXF_MEM_BASE_ADDR_PER_BAND	B1_RXF_MEM_BASE_ADDR
#endif




// Traffic indications (Not per band)
#define RXC_TRAFFIC_INDICATION_CLEAR_BY_ONE_BITMAP				(TRAFFIC_INDICATOR_BASE_ADDR)
#define NUM_STA_PER_LINE										(2) // Traffic Indication Bittmap (see rxc_rxd_rxf.doc section 2.2.1) 
#define TRAFFIC_IND_GET_ROW 									(2) 
#define TRAFFIC_IND_GET_COLUMN									(0x3) 
#define TRAFFIC_IND_MUL_8										(3) 
#define RXC_STA_ACTIVITY_BIT_LOCATION_MASK			 			(0x1F)
#define RXC_INDICATION_SET 										(0x1)

// Type/Subtype filter (Per band)
#define RXC_RXF_MPDU_TYPE_FILTER_RAM_START_OFFSET        		(256) 	//offset of type/subtype RAM from beginning of RXF RAM block according to VLSI spec.
#define RXC_RXF_MPDU_TYPE_FILTER_RAM_START             			(RXC_RXF_MEM_BASE_ADDR_PER_BAND + RXC_RXF_MPDU_TYPE_FILTER_RAM_START_OFFSET)
#define RXC_RXF_MPDU_TYPE_FILTER_NUM_WORDS_PER_VAP   			(2)
#define RXC_RXF_DATA_SUBTYPES_CONFIG							(0xEEEE)
#define RXC_RXF_MANAGEMENT_SUBTYPES_CONFIG						(0x82C0)
#define RXC_RXF_CONTROL_SUBTYPES_CONFIG							(0x90C6)  // This is a Control SUBTYPES filter (RXF) any UNICODE passing this bitmap filter will reach the RXH
#define RXC_RXF_RESERVED_SUBTYPES_CONFIG						(0xFFFF)

// STA Frame Class filter (Per band)
#define RXC_RXF_STA_FRAME_CLASS_RAM_START_OFFSET				(0) 	// STA frame class memory is the first in the RAM
#define RXC_RXF_STA_FRAME_CLASS_RAM_START						(RXC_RXF_MEM_BASE_ADDR_PER_BAND + RXC_RXF_STA_FRAME_CLASS_RAM_START_OFFSET)
#define RXC_RXF_STA_FRAME_CLASS_ENTRY_WIDTH 					(2)	   	// Every 2 bit represent the Sta frame class value
#define RXC_RXF_STA_FRAME_CLASS_ENTRY_MASK  					(0x3)  	// Mask of the sta frame class value 
#define RXC_RXF_STA_FRAME_CLASS_NUM_OF_ENTRIES_PER_WORD  		(16)   	// In each frame class registers there 16 entries 
#define RXC_RXF_STA_FRAME_CLASS_STA_IDX_TO_WORD_ADDR_SHIFT 		(4)    	// Shift value to calculate line addr from sta index.  Offset from beginning of RAM =  STA Index /16
#define RXC_RXF_STA_FRAME_CLASS_STA_IDX_TO_BIT_OFFSET_MASK		(0xF)	// Bits required to calculate the offset of the STA bits within a word	
#define RXC_RXF_STA_FRAME_CLASS_RAM_SIZE_IN_WORDS				(HW_NUM_OF_STATIONS / RXC_RXF_STA_FRAME_CLASS_NUM_OF_ENTRIES_PER_WORD)

// PHY Status filters (Per band)
#define RXC_RXF_PHY_STATUS_FILTER_STA_GROUP_INDEX_RAM_START_OFFSET	(64) 	// STA group index RAM is after STA frame Class RAM 
#define RXC_RXF_PHY_STATUS_FILTER_STA_GROUP_INDEX_RAM_START			(RXC_RXF_MEM_BASE_ADDR_PER_BAND + RXC_RXF_PHY_STATUS_FILTER_STA_GROUP_INDEX_RAM_START_OFFSET)
#define RXC_RXF_PHY_STATUS_FILTER_STA_IDX_TO_WORD_ADDR_SHIFT 		(3)		// Shift value to calculate line addr from sta index.  Offset from beginning of RAM =  STA Index /8
#define RXC_RXF_PHY_STATUS_FILTER_STA_IDX_TO_BIT_OFFSET_MASK		(0x7)	// Bits required to calculate the offset of the STA bits within a word	
#define RXC_RXF_PHY_STATUS_FILTER_ENTRY_WIDTH 						(4)		// Every 4 bit represent the Sta frame class value
#define RXC_RXF_PHY_STATUS_FILTER_ENTRY_MASK  						(0xF)  	// Mask of the group index value 
#define RXC_RXF_PHY_STATUS_FILTER_REFERENCE_RAM_START_OFFSET		(192) 	// PHY Status reference RAM is after STA frame Class RAM and Group filter RAM
#define RXC_RXF_PHY_STATUS_FILTER_REFERENCE_RAM_START				(RXC_RXF_MEM_BASE_ADDR_PER_BAND + RXC_RXF_PHY_STATUS_FILTER_REFERENCE_RAM_START_OFFSET)
#define RXC_RXF_PHY_STATUS_FILTER_MASK_RAM_START_OFFSET				(224)	// PHY Status Mask RAM is after the reference RAM which is of size 8 words (32 bytes)
#define RXC_RXF_PHY_STATUS_FILTER_MASK_RAM_START					(RXC_RXF_MEM_BASE_ADDR_PER_BAND + RXC_RXF_PHY_STATUS_FILTER_MASK_RAM_START_OFFSET)
#define RXC_PHY_STATUS_FILTER_NUM_OF_GROUPS		(8)


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#define RXC_TRAFFIC_INDICATION_STATION_ACTIVITY_BITMAP_SIZE_IN_WORDS (CONVERT_BIT_INDEX_TO_WORDS(HW_NUM_OF_STATIONS - 1) + 1)

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

typedef union 
{
	uint32 val;
	struct	
	{
		uint8 sta0Tid0:1; /* station index is 0-3 per row */
		uint8 sta0Tid1:1;
		uint8 sta0Tid2:1;
		uint8 sta0Tid3:1;
		uint8 sta0Tid4:1;
		uint8 sta0Tid5:1;
		uint8 sta0Tid6:1;
		uint8 sta0Tid7:1;
		uint8 sta1Tid0:1;
		uint8 sta1Tid1:1;
		uint8 sta1Tid2:1;
		uint8 sta1Tid3:1;
		uint8 sta1Tid4:1;
		uint8 sta1Tid5:1;
		uint8 sta1Tid6:1;
		uint8 sta1Tid7:1;		
		uint8 sta2Tid0:1;
		uint8 sta2Tid1:1;
		uint8 sta2Tid2:1;
		uint8 sta2Tid3:1;
		uint8 sta2Tid4:1;
		uint8 sta2Tid5:1;
		uint8 sta2Tid6:1;
		uint8 sta2Tid7:1;
		uint8 sta3Tid0:1;
		uint8 sta3Tid1:1;
		uint8 sta3Tid2:1;
		uint8 sta3Tid3:1;
		uint8 sta3Tid4:1;
		uint8 sta3Tid5:1;
		uint8 sta3Tid6:1;
		uint8 sta3Tid7:1;
	} bitfields;
} RxcStationBaAgreementActivityBitmap_t;

typedef struct RxcTrafficIndRam
{
	RxcStationBaAgreementActivityBitmap_t BaAgreementRecipientActivityBitmap[HW_NUM_OF_STATIONS >> NUM_STA_PER_LINE];	
	RxcStationBaAgreementActivityBitmap_t BaAgreementInitiatorActivityBitmap[HW_NUM_OF_STATIONS >> NUM_STA_PER_LINE];
#ifdef ENET_INC_ARCH_WAVE600D2
	RxcStationBaAgreementActivityBitmap_t BaAgreementRxPpActivityBitmap[HW_NUM_OF_STATIONS >> NUM_STA_PER_LINE];
#endif
	uint32 stationActivityBitmap[RXC_TRAFFIC_INDICATION_STATION_ACTIVITY_BITMAP_SIZE_IN_WORDS]; // there are 32 indication bits in a word. Bit per station
} RxcTrafficIndRam_t;


typedef union
{
	uint32 val;
	struct
	{
		uint32 subType0  :1;
		uint32 subType1  :1;
		uint32 subType2  :1;
		uint32 subType3  :1;
		uint32 subType4  :1;
		uint32 subType5  :1;
		uint32 subType6  :1;
		uint32 subType7  :1;
		uint32 subType8  :1;
		uint32 subType9  :1;
		uint32 subType10 :1;
		uint32 subType11 :1;
		uint32 subType12 :1;
		uint32 subType13 :1;
		uint32 subType14 :1;
		uint32 subType15 :1;
		uint32 reserved  :16;
	} subTypes;
}RxcSubtypesVapMpduFilter_u;


typedef struct RxfVapMpduTypesFilter
{
	RxcSubtypesVapMpduFilter_u RxcDataSubtypesMpduType;
	RxcSubtypesVapMpduFilter_u RxcManagementSubtypesMpduType;
	RxcSubtypesVapMpduFilter_u RxcControlSubtypesMpduType;
} RxfVapMpduTypesFilter_t;


typedef struct RxfMpduTypesFilterRam_
{
	RxfVapMpduTypesFilter_t VapMpduTypesFilter[HW_NUM_OF_VAPS];
} RxfMpduTypesFilterRam_t;

typedef enum
{
	RXC_RXF_MPDU_TYPE_DATA		 = 0,
	RXC_RXF_MPDU_TYPE_MANAGEMENT = 1,
	RXC_RXF_MPDU_TYPE_CONTROL 	 = 2,
	RXC_RXF_MPDU_TYPE_RESERVED 	 = 3,
	RXC_RXF_MPDU_TYPE_NUM 		 = 4
} RxcRxfMpduType_e;


typedef enum
{
	RXC_PHY_STATUS_FILTER_TYPE_FD_RSSI		= 0,
	RXC_PHY_STATUS_FILTER_TYPE_TD_RSSI		= 1,
	RXC_PHY_STATUS_FILTER_TYPE_RF_GAIN		= 2,
	RXC_PHY_STATUS_FILTER_TYPE_NOISE_EST	= 3,
} RxcPhyStatusFilterType_e;

typedef enum
{
	RXC_PHY_STATUS_FILTER_LESS_OR_EQUAL		= 0,
	RXC_PHY_STATUS_FILTER_GREATER_OR_EQUAL	= 1,
} RxcPhyStatusFilterOpration_e;




#endif // RXPP_API_H_


