/***************************************************************
 File:		HwDrivers_Api.h
 Module:	  	HwDrivers
 Purpose: 	Create common interface for accessing the PAC registers 
 Description:  This file is the API for acessing the PAC registers
***************************************************************/

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "HwDrivers_Api.h"
#include "OSAL_Interrupts.h"
#include "RegAccess_Api.h"
#include "HwMemoryMap.h"




/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define REG_RAB_SECURE_WRITE 0x0044
#define REG_PAC_SW_RESET 0x0048
#define PAC_SECURE_WRITE_FIRST_VALUE 0xaaaa
#define PAC_SECURE_WRITE_SECOND_VALUE 0x5555

#if defined (ENET_INC_ARCH_WAVE600)
#define RAB_BASE_ADDRESS	(B0_RAB_BASE_ADDR)
#else
#define RAB_BASE_ADDRESS	(RAB_BASE_ADDR)
#endif


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition					
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
void HwDrivers_SecureModuleReset(uint32 moduleMask)
{
	uint32 currentRegisterValue = 0;
	uint32 desirableRegisterValue = 0;
	TX_INTERRUPT_SAVE_AREA;

	
	OSAL_DISABLE_INTERRUPTS(&interrupt_save);
	
	currentRegisterValue = MT_RdReg(RAB_BASE_ADDRESS,REG_PAC_SW_RESET);
	desirableRegisterValue = currentRegisterValue & ~moduleMask;
	
	while(desirableRegisterValue != currentRegisterValue)
	{
		MT_WrReg(RAB_BASE_ADDRESS, REG_RAB_SECURE_WRITE, PAC_SECURE_WRITE_FIRST_VALUE);
		MT_WrReg(RAB_BASE_ADDRESS, REG_RAB_SECURE_WRITE, PAC_SECURE_WRITE_SECOND_VALUE);
		MT_WrReg(RAB_BASE_ADDRESS, REG_PAC_SW_RESET,desirableRegisterValue);
		currentRegisterValue = MT_RdReg(RAB_BASE_ADDRESS,REG_PAC_SW_RESET);
	}
	
	desirableRegisterValue |= moduleMask;
	while(desirableRegisterValue != currentRegisterValue)
	{
		MT_WrReg(RAB_BASE_ADDRESS, REG_RAB_SECURE_WRITE, PAC_SECURE_WRITE_FIRST_VALUE);
		MT_WrReg(RAB_BASE_ADDRESS, REG_RAB_SECURE_WRITE, PAC_SECURE_WRITE_SECOND_VALUE);
		MT_WrReg(RAB_BASE_ADDRESS, REG_PAC_SW_RESET,desirableRegisterValue);
		currentRegisterValue = MT_RdReg(RAB_BASE_ADDRESS,REG_PAC_SW_RESET);
	}
	
	OSAL_ENABLE_INTERRUPTS(interrupt_save);		  
}



