/***********************************************************************************
 File:		PacDelia.c
 Module:		Pac Driver
 Purpose:		
 Description:	FW driver for Rxc module In Pac
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "Pac_Api.h"
#include "RegAccess_Api.h"
#include "PacDelRegs.h"
#include "PacDel1Regs.h"
#include "PacDel2Regs.h"
#include "PacDel3Regs.h"
#include "PhyDriver_API.h"
#include "ShramDeliaDescriptors.h"
#include "loggerAPI.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_PAC
#define LOG_LOCAL_FID 4

/* Specific Registers Definitions*/
#define REG_REDUCED_FREQ_CCA_COMPENSATION_MASK     (0xffff0000)
#define REG_REDUCED_FREQ_CCA_COMPENSATION_SHIFT    (16)
#define REG_REDUCED_FREQ_IFS_COMPENSATION_MASK     (0xffff0000)
#define REG_REDUCED_FREQ_IFS_COMPENSATION_SHIFT    (16)

#define DEL_BASE_REG_TWO   (2)
#define DEL_BASE_REGS      (7)

#define PAC_DELIA_HW_DELAY	(10)

#define DEL_AUTO_FILL_DISABLE	(0)
#define DEL_AUTO_FILL_ENABLE	(1)
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/                       Data Type Definition                        
/----------------------------------------------------------------------------------*/

    
typedef struct ENET_DEL  /* DeLia */
{
    uint32  au32BaseRegisters[DEL_BASE_REGS];
    uint32  u32ReturnAddress;
    uint32  u32RecipePointer;
    uint32  u32DeliaStatue;
    uint32  u32IFScompensation;
    uint32  u32CCAcompensation;
    uint32  u32Control;
    uint32  u32IdxJmpAddr;
} ENET_DEL;





/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/


/**********************************************************************************

Pac_DeliaInit

Description:
------------
	Initialization routine for Pac Delia

**********************************************************************************/
#if defined (ENET_INC_LMAC)
#pragma ghs section text=".initialization" 
#endif
void Pac_DeliaInit(void)
{
    RegPacDelIfsCompensation_u regPacDeliaIfsCompensation;
    //RegPacDelCcaCompensation_u regPacDeliaCcaCompensation;
    RegPacDelDeliaControl_u regPacDelilaControl;
	RegPacDelAutoFillEnable_u regPacAutoFillEnale;
	RegPacDelDel2GenriscStartTxEnableInt_u regPacDelDel2GenriscStartTxEnableInt;
    uint32 ifsCompensationOfdm = 0;
	uint32 ifsCompensation11b = 0;
	//uint32 ccaCompensationOfdm = 0;
	//uint32 ccaCompensation11b = 0;
	RegPacDelAutoReplyMode_u autoReplyModeRegister;

    regPacDeliaIfsCompensation.val = 0;
    //regPacDeliaCcaCompensation.val = 0;
    regPacDelilaControl.val = 0;
	regPacAutoFillEnale.val = 0;
	autoReplyModeRegister.val = 0;
	
	regPacDelDel2GenriscStartTxEnableInt.val = 0;

	//disable interrupts from all delias but delia 0
	regPacDelDel2GenriscStartTxEnableInt.bitFields.del2GenriscStartTxEnableInt = 0x0;
	RegAccess_Write(REG_PAC_DEL1_DEL2GENRISC_START_TX_ENABLE_INT, regPacDelDel2GenriscStartTxEnableInt.val);
	RegAccess_Write(REG_PAC_DEL2_DEL2GENRISC_START_TX_ENABLE_INT, regPacDelDel2GenriscStartTxEnableInt.val);
	RegAccess_Write(REG_PAC_DEL3_DEL2GENRISC_START_TX_ENABLE_INT, regPacDelDel2GenriscStartTxEnableInt.val);
	
    /* Set Ifs Compensation values for ofdm & 11b (TBD on next Hw Version)*/
	ifsCompensationOfdm = Pac_GetHwDelays(PAC_DELAY_DELIA_IFS_OFDM);
	ifsCompensation11b = Pac_GetHwDelays(PAC_DELAY_DELIA_IFS_11B);
	regPacDeliaIfsCompensation.bitFields.ifsCompensationOfdm = System_ConvertNsToSystemClk(ifsCompensationOfdm) - PAC_DELIA_HW_DELAY; 
	regPacDeliaIfsCompensation.bitFields.ifsCompensation11B = System_ConvertNsToSystemClk(ifsCompensation11b) - PAC_DELIA_HW_DELAY; 
    RegAccess_Write(REG_PAC_DEL_IFS_COMPENSATION,regPacDeliaIfsCompensation.val);

	/* Set CCa  Compensation values for ofdm & 11b (TBD on next Hw Version)*/	
	//ccaCompensationOfdm = Pac_GetHwDelays(PAC_DELAY_DELIA_CCA_OFDM);
	//ccaCompensation11b  = Pac_GetHwDelays(PAC_DELAY_DELIA_CCA_11B);
	//regPacDeliaCcaCompensation.bitFields.ccaCompensationOfdm = System_ConvertNsToSystemClk(ccaCompensationOfdm) - PAC_DELIA_HW_DELAY; ;
	//regPacDeliaCcaCompensation.bitFields.ccaCompensation11B = System_ConvertNsToSystemClk(ccaCompensation11b) - PAC_DELIA_HW_DELAY; ;
 //   RegAccess_Write(REG_PAC_DEL_CCA_COMPENSATION,regPacDeliaCcaCompensation.val);

	regPacAutoFillEnale.bitFields.autoFillEnable = DEL_AUTO_FILL_ENABLE;
	RegAccess_Write(REG_PAC_DEL_AUTO_FILL_ENABLE,regPacAutoFillEnale.val);
	RegAccess_Write(REG_PAC_DEL1_AUTO_FILL_ENABLE,regPacAutoFillEnale.val);   
	RegAccess_Write(REG_PAC_DEL2_AUTO_FILL_ENABLE,regPacAutoFillEnale.val);   
	RegAccess_Write(REG_PAC_DEL3_AUTO_FILL_ENABLE,regPacAutoFillEnale.val);   
	
	autoReplyModeRegister.bitFields.autoPowerMode = TRUE;
	RegAccess_Write(REG_PAC_DEL_AUTO_REPLY_MODE,autoReplyModeRegister.val); 

	/* Set Delia To Manual Start -> Tx Phy Enable is generated by explicit command */
    RegAccess_Write(REG_PAC_DEL_DELIA_CONTROL,regPacDelilaControl.val);   

	RegAccess_Write(REG_PAC_DEL_TX_DATA_STRUCTURE_ADDR, (uint32)DeliaDescriptors[0]);

	RegAccess_Write(REG_PAC_DEL1_IFS_COMPENSATION,regPacDeliaIfsCompensation.val);
	RegAccess_Write(REG_PAC_DEL1_DELIA_CONTROL,regPacDelilaControl.val);   
	RegAccess_Write(REG_PAC_DEL1_TX_DATA_STRUCTURE_ADDR, (uint32)DeliaDescriptors[1]);
	RegAccess_Write(REG_PAC_DEL2_IFS_COMPENSATION,regPacDeliaIfsCompensation.val);
	RegAccess_Write(REG_PAC_DEL2_DELIA_CONTROL,regPacDelilaControl.val);   
	RegAccess_Write(REG_PAC_DEL2_TX_DATA_STRUCTURE_ADDR, (uint32)DeliaDescriptors[2]);
	RegAccess_Write(REG_PAC_DEL3_IFS_COMPENSATION,regPacDeliaIfsCompensation.val);
	RegAccess_Write(REG_PAC_DEL3_DELIA_CONTROL,regPacDelilaControl.val);   
	RegAccess_Write(REG_PAC_DEL3_TX_DATA_STRUCTURE_ADDR, (uint32)DeliaDescriptors[3]);
}
#if defined (ENET_INC_LMAC)
#pragma ghs section text=default
#endif

