
/***********************************************************************************
 File:		PacDeliniator.c
 Module:		Pac Deliniator
 Purpose:		
 Description:	FW driver for Deliniator module In Pac
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Pac_Api.h"
#include "loggerAPI.h"
#include "ErrorHandler_Api.h"
#include "RegAccess_Api.h"
#include "MacHtExtensionsRegs.h"
#include "InterruptManager_Api.h"
#include "HwEventsAndErrors_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_PAC
#define LOG_LOCAL_FID 6


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

Pac_DelineatorEnableFifoFullEvent

Description:
------------


**********************************************************************************/\
void Pac_DelineatorEnableFifoFullEvent(void)
{
	InterruptManager_ClearEdgedTriggeredInterrupt(EDGED_TRIGGERED_INT_DELINEATOR_FIFO_FULL);
	HwErrors_UnMaskEvent(HW_ERROR_DELINEATOR_FIFO_FULL);
}

/**********************************************************************************

Pac_DelineatorGetState

Description:
------------

**********************************************************************************/
uint8 Pac_DelineatorGetState(void)
{
	RegMacHtExtensionsDelDebug2_u delineatorDebug2Reg;
	uint8 delineatorState;

	RegAccess_Read(REG_MAC_HT_EXTENSIONS_DEL_DEBUG2 ,&delineatorDebug2Reg.val);
	delineatorState = delineatorDebug2Reg.bitFields.delMainStm;
	return delineatorState;
}

/**********************************************************************************

Pac_DelineatorAssertToReset

Description:
------------


**********************************************************************************/
void Pac_DelineatorAssertToReset(void)
{
	RegMacHtExtensionsSwResetsAssert_u swResetAssertReg;

	swResetAssertReg.val = 0;

	swResetAssertReg.bitFields.delineatorSwResetAssert = TRUE;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_ASSERT,swResetAssertReg.val);
}

/**********************************************************************************

Pac_DelineatorReleaseFromReset

Description:
------------


**********************************************************************************/
void Pac_DelineatorReleaseFromReset(void)
{
	RegMacHtExtensionsSwResetsRelease_u swResetReleaseReg;

	swResetReleaseReg.val = 0;

	swResetReleaseReg.bitFields.delineatorSwResetRel = TRUE;
	RegAccess_Write(REG_MAC_HT_EXTENSIONS_SW_RESETS_RELEASE,swResetReleaseReg.val);
}

/**********************************************************************************

Pac_DeliniatorInit

Description:
------------
	Initialize Deliniator HW
Input:
-----

Output:
-------
	None

Returns:
--------
	None
**********************************************************************************/
#if defined (ENET_INC_LMAC)
#pragma ghs section text=".initialization" 
#endif
void Pac_DeliniatorInit(void)
{
	// pause Rx
	RegMacHtExtensionsDelRxHaltRequest_u delRxHaltRequestReg;
	RegMacHtExtensionsDelRxInHalt_u delRxInHaltReg;
	uint32 initTsf;
	uint32 currTime;
	

	delRxHaltRequestReg.val = 0; 
	delRxHaltRequestReg.bitFields.delRxHaltRequest = 1;

	RegAccess_Write(REG_MAC_HT_EXTENSIONS_DEL_RX_HALT_REQUEST,delRxHaltRequestReg.val);

	initTsf = Pac_TimGetTsfLow();

	RegAccess_Read(REG_MAC_HT_EXTENSIONS_DEL_RX_IN_HALT,&delRxInHaltReg.val);

	while (delRxInHaltReg.bitFields.delRxInHalt != 1)
	{
		RegAccess_Read(REG_MAC_HT_EXTENSIONS_DEL_RX_IN_HALT,&delRxInHaltReg.val);
		currTime = Pac_TimGetTsfLow();

		ASSERT((currTime - initTsf) < 100)
	}	
}
#if defined (ENET_INC_LMAC)
#pragma ghs section text=default
#endif

