/***********************************************************************************
 File:		PacTxc.c
 Module:		Pac Driver
 Purpose:		
 Description:	FW driver for Rxc module In Pac
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "Pac_Api.h"
#include "PacTxcRegs.h"
#include "loggerAPI.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_PAC
#define LOG_LOCAL_FID 16

#define TXC_ALTERNATIVE_BACKOFF_LENGTH          (4) /* For each priority altenative backoff field is set in a single register-> 4 Bytes length*/
#define TXC_PTCS_TABLE_ADDRESS_ALIGNMENT_SHIFT  (8)
/* EDCF_COINCIDENT  0x618 Fields Description*/
#define REG_TXC_EDCF_COINCIDENT_MSK      (0x000000F0)
#define REG_TXC_EDCF_COINCIDENT_SHIFT    (4)
#define REG_TXC_EDCF_COINCIDENT_0_MASK   (0x1UL << REG_TXC_EDCF_COINCIDENT_SHIFT)
#define REG_TXC_EDCF_COINCIDENT_1_MASK   (0x2UL << REG_TXC_EDCF_COINCIDENT_SHIFT)
#define REG_TXC_EDCF_COINCIDENT_2_MASK   (0x4UL << REG_TXC_EDCF_COINCIDENT_SHIFT)
#define REG_TXC_EDCF_COINCIDENT_3_MASK   (0x8UL << REG_TXC_EDCF_COINCIDENT_SHIFT)
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/                           Data Type Definition                        
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
 
/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

Pac_TxcEnablePriority

Description:
------------

Input:
-----

Output:
-------
    None

Returns:
--------
    None
**********************************************************************************/
void Pac_TxcEnablePriority(uint32 priority)
{

}

/**********************************************************************************

Pac_TxcDisablePriority

Description:
------------

Input:
-----

Output:
-------
    None

Returns:
--------
    None
**********************************************************************************/
void  Pac_TxcDisablePriority(uint32 priority)
{

}

/**********************************************************************************

Pac_TxcDisableAllPriorities

Description:
------------
    Disable all priorities 
Input:
-----

Output:
-------
    None

Returns:
--------
    None
**********************************************************************************/
void  Pac_TxcDisableAllPriorities(void)
{

}

/**********************************************************************************

Pac_TxcGetCoincidentPtcs

Description:
------------

Input:
-----

Output:
-------
    None

Returns:
--------
    None
**********************************************************************************/
void  Pac_TxcGetCoincidentPtcs(uint32 *coincidentPtcs)
{

}

/**********************************************************************************

Pac_TxcSetAlternativeBackoff

Description:
------------

Input:
-----

Output:
-------
    None

Returns:
--------
    None
**********************************************************************************/
void  Pac_TxcSetAlternativeBackoff(uint32 priority,uint32 alternativeBackoff)
{

}

/**********************************************************************************

Pac_TxcInit

Description:
------------

Input:
-----

Output:
-------
    None

Returns:
--------
    None
**********************************************************************************/
#if defined (ENET_INC_LMAC)
#pragma ghs section text=".initialization" 
#endif
void Pac_TxcInit(void)
{

}
#if defined (ENET_INC_LMAC)
#pragma ghs section text=default
#endif

