/***********************************************************************************
 File:		PacRxc.c
 Module:		Pac Driver
 Purpose:		
 Description:	FW driver for Rxc module In Pac
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "Protocol_PhyAttributes.h"
#include "Pac_Api.h"
#include "loggerAPI.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_PAC
#define LOG_LOCAL_FID 1

#define SIFS_TIME_11A_NS		(1000*SIFS_TIME_11A)
#define SIFS_TIME_11B_NS		(1000*SIFS_TIME_11B)

/* Hw Delays: The times here are from the MAC-PHY I/F timing diagrams in Tx Handler Vlsi specifications*/

/* Phy Delay(including RF Delay) from Air "busy" end (due to interferer) till CCA primary signal rise*/
#define C1_NS 		(1000) 
/* Phy Delay(including RF Delay) from Air "busy"  end (due to Rx session) till CCA primary signal rise*/
#define C2_NS 		(4000) 
/* Phy Delay(including RF Delay) from Air "busy"  end (due to Rx session) till Rx Phy ready fall */
#define R1_11B_NS 	(7000) 
#define R1_OFDM_NS 	(13000) 
/* Phy Delay(including RF Delay) from tx enable rise till Air busy start */
#define T1_NS 		(2500) 
/* Phy Delay(including RF delay) from air "busy" end (due to Tx session) till Tx PHY ready fall*/
#define T2_11B_NS 	(2000)
#define T2_OFDM_NS 	(500)
/* Internal delay in MAC RXC - delay from Rx Phy ready fall till start TXC count or start Rx Nav count*/
#define M1_NS 		(ONE_EIGTH_US_IN_NS) 
/* The SIFS element that MAC txc count (NS)*/
#define M2_NS 		(SIFS_TIME_11A_NS - R1_OFDM_NS - T1_NS - ONE_EIGTH_US_IN_NS) /* (375) */ 
/* The SIFS element that MAC txc count (1/8 us resolution)*/
#define M2_ONE_EIGTH (M2_NS/ONE_EIGTH_US_IN_NS)

/* Internal delay in MAC RXC - delay from CCA primary rise till start Tx count  fall till start TXC count or start Rx Nav count*/
#define M3_11B_NS 	(SIFS_TIME_11B_NS - C1_NS - M2_NS - T1_NS)  /* (6125) */ 
#define M3_11N_NS 	(SIFS_TIME_11A_NS - C1_NS - M2_NS - T1_NS)  /* (12125) */
/* Internal delay in MAC Delia - delay from Tx phy ready fall when Phy mode is 11B till start TXC count*/
#define M4_NS  		(SIFS_TIME_11B_NS - T2_11B_NS - M2_NS - T1_NS) /* 5125 */
/* Internal delay in Mac- delay from Tx NAVexpired until start TXC count */
#define M5_11B_NS 	(SIFS_TIME_11B_NS - M2_NS - T1_NS)  /* (6125) */ 
#define M5_11N_NS 	(SIFS_TIME_11A_NS - M2_NS - T1_NS)  /* (12125) */
/* Internal delay in MAC Delia - delay from Tx phy ready fall when Phy mode is OFDM till start TXC count */
#define M6_NS  		(SIFS_TIME_11A_NS - T2_OFDM_NS - M2_NS - T1_NS) /* 12625 */
 


/*---------------------------------------------------------------------------------
/							Macros						
/----------------------------------------------------------------------------------*/
#define NS_TO_US(ns) ((ns)/1000) /* Convert value in nano seconds  to value in  micro seconds and round down*/
/*---------------------------------------------------------------------------------
/                       			Data Type Definition                        
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
static uint32 PacHwDelays[PAC_DELAY_TOTAL_NUM] = 
{
	M2_ONE_EIGTH,									/* PAC_DELAY_TXC_SIFS_ELEMENT */
	M6_NS,											/* PAC_DELAY_DELIA_IFS_OFDM*/
	M4_NS,											/* PAC_DELAY_DELIA_IFS_11B */
	M3_11N_NS,										/* PAC_DELAY_RXC_CCA */
	M1_NS,											/* PAC_DELAY_RXC_RX_READY */
	M5_11N_NS,										/* PAC_DELAY_TIM_TX_NAV_IFS */
	NS_TO_US(M6_NS+M2_NS),							/* PAC_DELAY_TX_SEQ_SIFS_COMP_POST_TX_OFDM*/
	NS_TO_US(M4_NS+M2_NS),							/* PAC_DELAY_TX_SEQ_SIFS_COMP_POST_TX_11B,*/
	NS_TO_US(SIFS_TIME_11A_NS - C2_NS - T1_NS),		/* PAC_DELAY_TX_SEQ_SIFS_COMP_POST_RX_OFDM*/
	NS_TO_US(SIFS_TIME_11B_NS - C2_NS - T1_NS),		/* PAC_DELAY_TX_SEQ_SIFS_COMP_POST_RX_11B*/
	NS_TO_US(M2_NS + 1),							/* PAC_DELAY_TX_SEQ_SIFS_COMP_POST_TIMEOUT*/
};

/*---------------------------------------------------------------------------------
/					Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/					Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/					Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

Pac_SetHwDelays

Description:
------------
	Configures The Hw delays table according to the hwMode (OFDM,11B)
Input:
-----
	hwMode - 

 **********************************************************************************/
void Pac_SetHwDelays(uint32 hwMode)
{	
	UNUSED_PARAM(hwMode);	
	/* TBD */
}

/**********************************************************************************

Pac_GetHwDelays

Description:
------------
	Returns the HW delay value 
Input:
-----
	hwDelayId -Required Hw Delay 

Returns:	
 -----
	Hw Delay Value
 **********************************************************************************/
uint32 Pac_GetHwDelays(PacHwDelays_e hwDelayId)
{	
	DEBUG_ASSERT(hwDelayId < PAC_DELAY_TOTAL_NUM);
	
	return PacHwDelays[hwDelayId];	
}

