/***********************************************************************************
 File:		PacClc.c
 Module:		Pac Driver
 Purpose:		
 Description:	FW driver for Rxc module In Pac
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "RegAccess_Api.h"
#include "Pac_Api.h"
#ifndef ENET_INC_ARCH_WAVE600B
#include "MacClcRegs.h"
#endif
#include "loggerAPI.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_PAC
#define LOG_LOCAL_FID 3


#define MAC_CLC_DYNAMIC_CLOCK_GATE_MU_SELECTOR_BIT	(19)



typedef struct ENET_CLC  /* CLock Control */
{
    uint32  u32Dynamic;                     /* dynamic - enable dynamic power management */
    uint32  u32Stop;                        /* stop - force inactive for each block */
    uint32  u32ExtendRegClk;                /* extend_regclk - extend reg clock fter idle */
    uint32  u32ExtendSmcClk;                /* extend_smcclk - extend SMC clock after idle */
    uint32  u32FollowRegClk;                /* follow_regclk - extend of clk after register access*/
} ENET_CLC;

/* dynamic - each bit enabled dynamic power management through clock gating of each block */
/* stop - same bit assignments */
/* follow_regclk - same bit assignments*/
#define CLC_CLK_GATE_REG_MSK    (0x1U << 0)
#define CLC_CLK_GATE_SMC_MSK    (0x1U << 1)
#define CLC_CLK_GATE_RAB_MSK    (0x1U << 2)
#define CLC_CLK_GATE_UPI_MSK    (0x1U << 3)
#define CLC_CLK_GATE_LPI_MSK    (0x1U << 4)
#define CLC_CLK_GATE_PHI_MSK    (0x1U << 5)
#define CLC_CLK_GATE_WEP_MSK    (0x1U << 6)
#define CLC_CLK_GATE_NTD_MSK    (0x1U << 7)
#define CLC_CLK_GATE_TXC_MSK    (0x1U << 8)
#define CLC_CLK_GATE_TIM_MSK    (0x1U << 9)
#define CLC_CLK_GATE_DEL_MSK    (0x1U << 10)
#define CLC_CLK_GATE_RXC_MSK    (0x1U << 11)
#define CLC_CLK_GATE_RTA_MSK    (0x1U << 12)
#define CLC_CLK_GATE_DUR_MSK    (0x1U << 13)
/* bits 14, 15 - unused */

/* extend_regclk - extend of clk after register access */
#define CLC_EXTEND_REGCLK_MSK   0x0000003F
#define CLC_EXTEND_REGCLK_SFT   0

/* extend_smcclk - extend of SMC clock to speed up access */
#define CLC_EXTEND_SMCCLK_MSK   0x0000003F
#define CLC_EXTEND_SMCCLK_SFT   0

/* Note: u32Stop, u32ExtendRegClk, u32ExtendSmcClk & u32FollowRegClk
   are usually left as their power-up defaults - i.e. not programmed
   by software */


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/                       Data Type Definition                        
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/

void Pac_ClcInit(void)
{
#ifndef ENET_INC_ARCH_WAVE600B
	RegMacClcDynamic_u regMacClcDynamic;

	regMacClcDynamic.val = 0;

	RegAccess_Read(REG_MAC_CLC_DYNAMIC, &regMacClcDynamic.val);

	//disable clock gating for mu selector
	regMacClcDynamic.bitFields.dynamic &= ~(1 << MAC_CLC_DYNAMIC_CLOCK_GATE_MU_SELECTOR_BIT);

	RegAccess_Write(REG_MAC_CLC_DYNAMIC,regMacClcDynamic.val);
#endif
}
