/***********************************************************************************
 File:		PacDelia.c
 Module:		Pac Driver
 Purpose:		
 Description:	FW driver for Rxc module In Pac
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "ErrorHandler_Api.h"
#include "stringLibApi.h"
#include "Pac_Api.h"
#include "RegAccess_Api.h"
#include "PacDelRegs.h"
#include "PhyDriver_API.h"
#include "ShramDeliaDescriptors.h"
#include "ShramNewDeliaRecipes.h"
#include "ShramPreAggregator.h"
#include "DeliaRecipes_Api.h"
#include "loggerAPI.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_PAC
#define LOG_LOCAL_FID 5

/* Specific Registers Definitions*/
#define REG_REDUCED_FREQ_CCA_COMPENSATION_MASK     (0xffff0000)
#define REG_REDUCED_FREQ_CCA_COMPENSATION_SHIFT    (16)
#define REG_REDUCED_FREQ_IFS_COMPENSATION_MASK     (0xffff0000)
#define REG_REDUCED_FREQ_IFS_COMPENSATION_SHIFT    (16)

#define DEL_BASE_REG_TWO   (2)
#define DEL_BASE_REGS      (7)

#define PAC_DELIA_HW_DELAY	(10)

#define DEL_AUTO_FILL_DISABLE	(0)
#define DEL_AUTO_FILL_ENABLE	(1)
/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/                       Data Type Definition                        
/----------------------------------------------------------------------------------*/

    
typedef struct ENET_DEL  /* DeLia */
{
    uint32  au32BaseRegisters[DEL_BASE_REGS];
    uint32  u32ReturnAddress;
    uint32  u32RecipePointer;
    uint32  u32DeliaStatue;
    uint32  u32IFScompensation;
    uint32  u32CCAcompensation;
    uint32  u32Control;
    uint32  u32IdxJmpAddr;
} ENET_DEL;





/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/




/**********************************************************************************

Pac_DeliaTxEndErrorDuringTx

Description:
------------

	The error occured since we got in Sender indication that Delia finished transmission while Sender didn't finish passing all MPDU descriptors to Delia.
	Delia status that was read by Sender after this indication was illegal.
	All legal cases are described in excel here (Aligned with Nissim and Yossi Hai amar): https://sharepoint.ger.ith.intel.com/sites/WAV600/Shared%20Documents/SW/Design/GenRiscs/Tx%20Sender%20Genrisc/Visio%27s%20and%20Excels/recovery%20status%20delia%20new%20requirements.xlsx

**********************************************************************************/
uint32 AAA_Auto_fill_count = 0;
#ifdef ENET_INC_ARCH_WAVE600B
uint32 AAA_PacDeliaRegDump[((REG_PAC_DEL_DESC_LIST_EMPTY_LOW - PAC_DEL_BASE_ADDRESS) >> 0x2) + 0x1]; //allocate word per DeliaReg
#else
uint32 AAA_PacDeliaRegDump[((REG_PAC_DEL_PAC_PHY_MONITOR_DATA_0 - PAC_DEL_BASE_ADDRESS) >> 0x2) + 0x1]; //allocate word per DeliaReg
#endif




void Pac_DeliaReadDebugInfoOnAssert(void)
{
	//copy all delia regs, skip holls
	memcpy32(&AAA_PacDeliaRegDump[(REG_PAC_DEL_BASE_0 - PAC_DEL_BASE_ADDRESS) >> 0x2], (uint32*)REG_PAC_DEL_BASE_0, CONVERT_BYTES_TO_WORDS(REG_PAC_DEL_TX_ADDR1_47TO32 - REG_PAC_DEL_BASE_0) + 0x1);

	
	memcpy32(&AAA_PacDeliaRegDump[(REG_PAC_DEL_CPU_DEL_WR_EVENTS - PAC_DEL_BASE_ADDRESS) >> 0x2], (uint32*)REG_PAC_DEL_CPU_DEL_WR_EVENTS, CONVERT_BYTES_TO_WORDS(REG_PAC_DEL_LAST_CPU_DEL_CNTR_EVENT - REG_PAC_DEL_CPU_DEL_WR_EVENTS) + 0x1);


	memcpy32(&AAA_PacDeliaRegDump[(REG_PAC_DEL_LAST_RD_ADDR_TRANSFER - PAC_DEL_BASE_ADDRESS) >> 0x2], (uint32*)REG_PAC_DEL_LAST_RD_ADDR_TRANSFER, CONVERT_BYTES_TO_WORDS(REG_PAC_DEL_LAST_NOP_WAIT_EVENT_VECTOR - REG_PAC_DEL_LAST_RD_ADDR_TRANSFER) + 0x1);


	memcpy32(&AAA_PacDeliaRegDump[(REG_PAC_DEL_DELIA_LOGGER_CONTROL - PAC_DEL_BASE_ADDRESS) >> 0x2], (uint32*)REG_PAC_DEL_DELIA_LOGGER_CONTROL, CONVERT_BYTES_TO_WORDS(REG_PAC_DEL_PHY_DATA_FIFO_WR_COUNT - REG_PAC_DEL_DELIA_LOGGER_CONTROL) + 0x1);


#ifdef ENET_INC_ARCH_WAVE600B 
	memcpy32(&AAA_PacDeliaRegDump[(REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT - PAC_DEL_BASE_ADDRESS) >> 0x2], (uint32*)REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT, CONVERT_BYTES_TO_WORDS(REG_PAC_DEL_DESC_LIST_EMPTY_LOW - REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT) + 0x1);
#else
	memcpy32(&AAA_PacDeliaRegDump[(REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT - PAC_DEL_BASE_ADDRESS) >> 0x2], (uint32*)REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT, CONVERT_BYTES_TO_WORDS(REG_PAC_DEL_PAC_PHY_MONITOR_DATA_0 - REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT) + 0x1);
#endif

}


void Pac_DeliaTxEndErrorDuringTx(uint32 deliaStatus)
{	
	UNUSED_PARAM(deliaStatus);
	// read number of AF for debug
	RegAccess_Read(REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT, &AAA_Auto_fill_count);
	ILOG0_D("Pac_DeliaTxEndErrorDuringTx, delia status = 0x%08x", deliaStatus);
	FATAL("Pac_DeliaTxEndDuringTx");
}



/**********************************************************************************

Pac_DeliaTxEndErrorAtEndOfTx

Description:
------------
	
	The error occured since we got in Sender indication that Delia finished transmission (as expected), 
	but	Delia status that was read by Sender after this indication was illegal.
	All legal cases are described in excel here (Aligned with Nissim and Yossi Hai amar): https://sharepoint.ger.ith.intel.com/sites/WAV600/Shared%20Documents/SW/Design/GenRiscs/Tx%20Sender%20Genrisc/Visio%27s%20and%20Excels/recovery%20status%20delia%20new%20requirements.xlsx

**********************************************************************************/
void Pac_DeliaTxEndErrorAtEndOfTx(uint32 deliaStatus)
{		
	UNUSED_PARAM(deliaStatus);
	// read number of AF for debug
	RegAccess_Read(REG_PAC_DEL_PHY_DATA_FIFO_AF_COUNT, &AAA_Auto_fill_count);
	ILOG0_D("Pac_DeliaTxEndErrorAtEndOfTx, delia status =  0x%08x", deliaStatus);
	FATAL("Pac_DeliaTxEndErrorAtEndOfTx");
}



/**********************************************************************************

Pac_DeliaInit

Description:
------------
	Initialization routine for Pac Delia

**********************************************************************************/
void Pac_DeliaInit(void)
{
    RegPacDelIfsCompensation_u regPacDeliaIfsCompensation;
    //RegPacDelCcaCompensation_u regPacDeliaCcaCompensation;
    RegPacDelDeliaControl_u regPacDeliaControl;
    uint32 ifsCompensationOfdm = 0;
	uint32 ifsCompensation11b = 0;
	uint32 descAf = 0xAABBAABB;
	uint32 dataAf = 0xCCFFCCFF;
	//uint32 ccaCompensationOfdm = 0;
	//uint32 ccaCompensation11b = 0;
	RegPacDelAutoReplyMode_u autoReplyModeRegister;

    regPacDeliaIfsCompensation.val = 0;
    //regPacDeliaCcaCompensation.val = 0;
    regPacDeliaControl.val = 0;
	autoReplyModeRegister.val = 0;

	RegAccess_Write(REG_PAC_DEL_DESC_AF_REG,descAf);
	RegAccess_Write(REG_PAC_DEL_DATA_AF_REG,dataAf);

    /* Set Ifs Compensation values for ofdm & 11b (TBD on next Hw Version)*/
	ifsCompensationOfdm = Pac_GetHwDelays(PAC_DELAY_DELIA_IFS_OFDM);
	ifsCompensation11b = Pac_GetHwDelays(PAC_DELAY_DELIA_IFS_11B);
	regPacDeliaIfsCompensation.bitFields.ifsCompensationOfdm = System_ConvertNsToSystemClk(ifsCompensationOfdm) - PAC_DELIA_HW_DELAY; //8070 cycles
	regPacDeliaIfsCompensation.bitFields.ifsCompensation11B = System_ConvertNsToSystemClk(ifsCompensation11b) - PAC_DELIA_HW_DELAY; //3270 cycles
    RegAccess_Write(REG_PAC_DEL_IFS_COMPENSATION,regPacDeliaIfsCompensation.val);

	/* Set CCa  Compensation values for ofdm & 11b (TBD on next Hw Version)*/	
	//ccaCompensationOfdm = Pac_GetHwDelays(PAC_DELAY_DELIA_CCA_OFDM);
	//ccaCompensation11b  = Pac_GetHwDelays(PAC_DELAY_DELIA_CCA_11B);
	//regPacDeliaCcaCompensation.bitFields.ccaCompensationOfdm = System_ConvertNsToSystemClk(ccaCompensationOfdm) - PAC_DELIA_HW_DELAY; ;
	//regPacDeliaCcaCompensation.bitFields.ccaCompensation11B = System_ConvertNsToSystemClk(ccaCompensation11b) - PAC_DELIA_HW_DELAY; ;
 //   RegAccess_Write(REG_PAC_DEL_CCA_COMPENSATION,regPacDeliaCcaCompensation.val);
	
	autoReplyModeRegister.bitFields.autoPowerMode = TRUE;
	RegAccess_Write(REG_PAC_DEL_AUTO_REPLY_MODE,autoReplyModeRegister.val); 

	/* Set Delia To Manual Start -> Tx Phy Enable is generated by explicit command */
    RegAccess_Write(REG_PAC_DEL_DELIA_CONTROL,regPacDeliaControl.val);   

#if defined(ENET_INC_LMAC0) 	
	RegAccess_Write(REG_PAC_DEL_TX_DATA_STRUCTURE_ADDR, (uint32)&(DeliaDataStructure));
	RegAccess_Write(REG_PAC_DEL_TCR_BASE_ADDR1, 		(uint32)&(TxPreAggregatorGeneratedTcrsDataStructure1));
	RegAccess_Write(REG_PAC_DEL_TCR_BASE_ADDR2, 		(uint32)&(TxPreAggregatorGeneratedTcrsDataStructure2));
	RegAccess_Write(REG_PAC_DEL_RCR_BASE_ADDR, 			(uint32)&(TxPreAggregatorGeneratedRcrsDataStructure));
	// Get the pointer to the recipes of this band	
	pDeliaRecipes = &DeliaRecipes;
	pDeliaAutoResponseTcrs = &DeliaAutoResponseTcrs;
#ifdef ENET_INC_ARCH_WAVE600B
	pMbfmTcrs = &MbfmTcrs;
#endif //ENET_INC_ARCH_WAVE600B
#elif defined (ENET_INC_LMAC1) 
	RegAccess_Write(REG_PAC_DEL_TX_DATA_STRUCTURE_ADDR, (uint32)&(DeliaDataStructure_B1));
	RegAccess_Write(REG_PAC_DEL_TCR_BASE_ADDR1, 		(uint32)&(TxPreAggregatorGeneratedTcrsDataStructure1_B1));
	RegAccess_Write(REG_PAC_DEL_TCR_BASE_ADDR2, 		(uint32)&(TxPreAggregatorGeneratedTcrsDataStructure2_B1));
	RegAccess_Write(REG_PAC_DEL_RCR_BASE_ADDR, 			(uint32)&(TxPreAggregatorGeneratedRcrsDataStructure_B1));
	// Get the pointer to the recipes of this band	
	pDeliaRecipes = &DeliaRecipes_B1;
	pDeliaAutoResponseTcrs = &DeliaAutoResponseTcrs_B1;
#ifdef ENET_INC_ARCH_WAVE600B
	pMbfmTcrs = &MbfmTcrs_B1;
#endif //ENET_INC_ARCH_WAVE600B
#endif

	memset32(&AAA_PacDeliaRegDump, 0xDEADDEAD, CONVERT_BYTES_TO_WORDS(sizeof(AAA_PacDeliaRegDump)));	
	
}
