
/***********************************************************************************
 File:		PacDeliniator.c
 Module:		Pac Deliniator
 Purpose:		
 Description:	FW driver for Deliniator module In Pac
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Pac_Api.h"
#include "loggerAPI.h"
#include "ErrorHandler_Api.h"
#include "RegAccess_Api.h"
#include "MacHtExtensionsRegs.h"
#include "InterruptManager_Api.h"
#include "HwEventsAndErrors_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_PAC
#define LOG_LOCAL_FID 7


/*---------------------------------------------------------------------------------
/						Public Functions Definitions									
/----------------------------------------------------------------------------------*/
/**********************************************************************************

Pac_DelineatorEnableFifoFullEvent

Description:
------------


**********************************************************************************/\
void Pac_DelineatorEnableFifoFullEvent(void)
{
	ASSERT(0); // In gen6 we don't have this edge interrupt.
}

/**********************************************************************************

Pac_DelineatorGetState

Description:
------------

**********************************************************************************/
uint8 Pac_DelineatorGetState(void)
{
	ASSERT(0); // There is no delinoator in gen6. 
	return 0;  // There is no delinoator in gen6. 
}

/**********************************************************************************

Pac_DelineatorAssertToReset

Description:
------------


**********************************************************************************/
void Pac_DelineatorAssertToReset(void)
{
	ASSERT(0); // There is no delinoator in gen6. 
}

/**********************************************************************************

Pac_DelineatorReleaseFromReset

Description:
------------


**********************************************************************************/
void Pac_DelineatorReleaseFromReset(void)
{
	ASSERT(0); // There is no delinoator in gen6. 
}

/**********************************************************************************

Pac_DeliniatorInit

Description:
------------
	Initialize Deliniator HW
Input:
-----

Output:
-------
	None

Returns:
--------
	None
**********************************************************************************/
void Pac_DeliniatorInit(void)
{
	//ASSERT(0); // There is no delinoator in gen6. 
}
