/***********************************************************************************
 File:		HwEventsAndErrors_Api.h
 Module:		Hw Events & Errors
 Purpose:		
 Description:	
************************************************************************************/
#ifndef HW_EVENTS_AND_ERROS_API_H_
#define HW_EVENTS_AND_ERROS_API_H_

/*---------------------------------------------------------------------------------
/								Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "InterruptManager_Api.h"
/*---------------------------------------------------------------------------------
/								Defines						
/----------------------------------------------------------------------------------*/
typedef enum
{
	HW_EVENT_DELIA_2_GENRISC_TX_START = 0,
	HW_EVENT_SEQUENCER_RA_FILLER,
	HW_EVENT_RX_COORDINATOR_FRAME_CLASS_VIOLATION,
	HW_EVENT_BA_ANALYZER_STATUS_FIFO,	
	HW_EVENT_PS_SETTING_FIFO_NOT_EMPTY,
	HW_EVENT_PHY,
	HW_EVENT_RXF_FIFO_NOT_EMPTY,
	HW_EVENT_TX_SELECTOR,
	HW_EVENT_TXH_NTD_SW_REQ,
	HW_EVENT_ALPHA_FILTERS_CALC_REQ_DONE_INDICATION,
	HW_EVENT_RX_SECURITY_COMPLETE,
	HW_EVENT_RX_AMSDU_PARSER_MSDU_DESC_NOT_EMPTY, //HW_EVENT_RX_CLASSIFIER_RXH_AVAILABLE_PENDING_RTD,
	HW_EVENT_RX_HALT_INDICATION,
	HW_EVENT_TX_DMA_MON_ACC_NON_EMPTY_IND,
	HW_EVENT_DMA_WRRAPER_CH1_DONE_ACC_NOT_EMPTY,
	HW_EVENT_TX_SECURITY_COMPLETE,
	HW_EVENT_MAC_PHY_GP_IF_INDICATION,
	HW_EVENT_BAND_REL_A_RESERVED_17,
	HW_EVENT_DELIA_2_GENRISC_TX_END,
	HW_EVENT_GENRISC_SENDER,	 
	HW_EVENT_PRE_AGGREGATOR,
	HW_EVENT_TSF_TIMER,
	HW_EVENT_GENRISC_RX_HANDLER,	 
	HW_EVENT_SEQUENCER,	 
	HW_EVENT_PAC_TICK_TIMER,
	HW_EVENT_TX_DONE_LISTS, 
	HW_EVENT_RX_DONE_LISTS, 
	HW_EVENT_Q_MANAGER_LOW_PRI_TX_READY,
	HW_EVENT_Q_MANAGER_LOW_PRI_RX_READY,	
	HW_EVENT_HIGH_PRI_TX_PD_READY,
	HW_EVENT_HIGH_PRI_RX_PD_READY,	
	HW_EVENT_Q_MANAGER_DESCRIPTOR_POOL,	
	HW_EVENT_BAND_REL_A_TOTAL_NUM,
	HW_EVENT_BAND_REL_A_MAX_NUM	= 0xFF 	
} HwEventIdBandRelA_e; // Hw Events Band Related A

typedef enum
{	
	HW_EVENT_BAND_REL_B_BSRC = 0,
	HW_EVENT_BAND_REL_B_BEAMFORMING_ERROR_FIFO_NOT_EMPTY,
	HW_EVENT_BAND_REL_B_PLAN_LOCKER_LMAC0,
	HW_EVENT_BAND_REL_B_PLAN_LOCKER_LMAC1,
	HW_EVENT_BAND_REL_B_PLAN_LOCKER_UMAC,
	HW_EVENT_BAND_REL_B_MU_LOCKER_LMAC0,
	HW_EVENT_BAND_REL_B_MU_LOCKER_LMAC1,
	HW_EVENT_BAND_REL_B_MU_LOCKER_UMAC,
#ifdef ENET_INC_ARCH_WAVE600B
	HW_EVENT_BAND_REL_B_RXC_RSSI_NOT_MY_STA_FIFO_NOT_EMPTY,
#else
    HW_EVENT_BAND_REL_B_RESERVED_8,
#endif
	HW_EVENT_BAND_REL_B_RESERVED_9,
	HW_EVENT_BAND_REL_B_RESERVED_10,
	HW_EVENT_BAND_REL_B_RESERVED_11,
	HW_EVENT_BAND_REL_B_RESERVED_12,
	HW_EVENT_BAND_REL_B_RESERVED_13,
	HW_EVENT_BAND_REL_B_RESERVED_14,
	HW_EVENT_BAND_REL_B_RESERVED_15,
	HW_EVENT_BAND_REL_B_RESERVED_16,
	HW_EVENT_BAND_REL_B_RESERVED_17,
	HW_EVENT_BAND_REL_B_RESERVED_18,
	HW_EVENT_BAND_REL_B_RESERVED_19,
	HW_EVENT_BAND_REL_B_RESERVED_20,
	HW_EVENT_BAND_REL_B_RESERVED_21,
	HW_EVENT_BAND_REL_B_RESERVED_22,
	HW_EVENT_BAND_REL_B_RESERVED_23,
	HW_EVENT_BAND_REL_B_RESERVED_24,
	HW_EVENT_BAND_REL_B_RESERVED_25,
	HW_EVENT_BAND_REL_B_RESERVED_26,
	HW_EVENT_BAND_REL_B_RESERVED_27,
	HW_EVENT_BAND_REL_B_RESERVED_28,
	HW_EVENT_BAND_REL_B_RESERVED_29,
	HW_EVENT_BAND_REL_B_RESERVED_30,
	HW_EVENT_BAND_REL_B_RESERVED_31,
	HW_EVENT_BAND_REL_B_TOTAL_NUM,
	HW_EVENT_BAND_REL_B_MAX_NUM	= 0xFF 	
} HwEventIdBandRelB_e; // Hw Events Band Related B


typedef enum
{
	HW_EVENT_RESERVED_0 = 0,
	HW_EVENT_RXPP_FRAGMENT_FIFO_NOT_EMPTY,
	HW_EVENT_PD_THRESHOLD_REACHED,
	HW_EVENT_RD_THRESHOLD_REACHED,
	HW_EVENT_EXTERNAL_IRQ,
    HW_EVENT_RAB_NPU_TO_UPI_IRQ,
	HW_EVENT_Q_MANAGER_DISABLE_LIST_NON_EMPTY_UMAC,
	HW_EVENT_Q_MANAGER_DISABLE_LIST_NON_EMPTY_LMAC0,
	HW_EVENT_Q_MANAGER_DISABLE_LIST_NON_EMPTY_LMAC1,
	HW_EVENT_AGER_SINGLE_CHECK_DONE,
	HW_EVENT_INT_SHRAM_ADDR,
	HW_EVENT_EXTERNAL_IRQ_GPIO_1,
	HW_EVENT_EXTERNAL_IRQ_GPIO_10,	
	HW_EVENT_UART_LMAC0,
	HW_EVENT_UART_LMAC1,
	HW_EVENT_UART_UMAC,
	HW_EVENT_PROTECTED_DB_LMAC0,
	HW_EVENT_PROTECTED_DB_LMAC1,
	HW_EVENT_PROTECTED_DB_UMAC,	
	HW_EVENT_EXTERNAL_IRQ_GPIO_11,
#ifdef ENET_INC_ARCH_WAVE600B
	HW_EVENT_APB_TIMEOUT,
#else
    HW_EVENT_RESERVED_20,
#endif
	HW_EVENT_PCIe_0,
	HW_EVENT_PCIe_1,
	HW_EVENT_HOST_IF_GENRISC,
	HW_EVENT_RESERVED_24,
	HW_EVENT_TX_DONE_LISTS_UMAC, 
	HW_EVENT_RX_DONE_LISTS_UMAC, 
	HW_EVENT_Q_MANAGER_LOW_PRI_TX_READY_UMAC,
	HW_EVENT_Q_MANAGER_LOW_PRI_RX_READY_UMAC,	
	HW_EVENT_HIGH_PRI_TX_PD_READY_UMAC,
	HW_EVENT_HIGH_PRI_RX_PD_READY_UMAC,	
	HW_EVENT_Q_MANAGER_DESCRIPTOR_POOL_UMAC, 	
	HW_EVENT_COMMON_TOTAL_NUM,
	HW_EVENT_COMMON_MAX_NUM	= 0xFF 	
} HwEventIdCommonA_e;


typedef enum
{
	HW_ERROR_RXC_ERROR	= 0,
	HW_ERROR_PAC_TX_ERROR,
	HW_ERROR_AUTO_RESPONSE_ERROR_FIFO_NOT_EMPTY,
	HW_ERROR_SEQUENCER_ERROR,
	HW_ERROR_TX_SECURITY_FAIL,
	HW_ERROR_DELIA_LIMIT_TIMER_EXPIRED,
	HW_ERROR_BSRC_ERROR,	
	HW_ERROR_DELIA_AUTO_FILL_END,
	HW_ERROR_TX_SELECTOR_ERROR,
	HW_ERROR_BA_ANALYZER_ERROR,
	HW_ERROR_RX_SECURITY_FAIL,
	HW_ERROR_Q_MANAGER_LM_ERROR,
	HW_ERROR_BF_REPORT_AUTO_REPLY_ABORT_DUE_TO_PHY_MODE_ERROR,
	HW_ERROR_OTF_TID_ERROR_FIFO_NOT_EMPTY,
	HW_ERROR_PS_SETTING_ERROR,
	HW_ERROR_BEAMFORMING_ERROR,
	HW_ERROR_ULPR_ERROR,
#ifdef ENET_INC_ARCH_WAVE600B
	HW_ERROR_TXPD_ACC_ERROR,
	HW_ERROR_TX_HC_ERROR,
	HW_ERROR_TF_GEN_ERROR,
	HW_ERROR_OTFA_TID_ERROR_FIFO_ERROR,
	HW_ERROR_AUTO_RESPONSE_ERROR,
#else
    HW_ERROR_RESERVED_17,
    HW_ERROR_RESERVED_18,
    HW_ERROR_RESERVED_19,
    HW_ERROR_RESERVED_20,
    HW_ERROR_RESERVED_21,
#endif
	HW_ERROR_RESERVED_22,
	HW_ERROR_RESERVED_23,
	HW_ERROR_RESERVED_24,
	HW_ERROR_RESERVED_25,
	HW_ERROR_RESERVED_26,
	HW_ERROR_RESERVED_27,
	HW_ERROR_RESERVED_28,
	HW_ERROR_RESERVED_29,
	HW_ERROR_RESERVED_30,
	HW_ERROR_RESERVED_31,
	HW_ERROR_TOTAL_NUM,
	HW_ERROR_MAX_NUM	= 0xFF 
} HwErrorId_e;


typedef enum
{
	
	HW_ERROR_ARM_DMA0_ABORT_ERROR = 0, // HW_ERROR_ARM_DMA0_ABORT_ERROR???
	HW_ERROR_ARM_DMA1_ABORT_ERROR, 	   // HW_ERROR_ARM_DMA1_ABORT_ERROR???
	HW_ERROR_Q_MANAGER_UM_ERROR,
#ifdef ENET_INC_ARCH_WAVE600B
	HW_ERROR_HOST_IF_ACC_ERROR,
	HW_ERROR_RXPP_SHRAM_FIFO_ERROR,
#else
    HW_ERROR_COMMON_RESERVED_3,
    HW_ERROR_COMMON_RESERVED_4,
#endif
	HW_ERROR_COMMON_RESERVED_5,
	HW_ERROR_COMMON_RESERVED_6,
	HW_ERROR_COMMON_RESERVED_7,
	HW_ERROR_COMMON_RESERVED_8,
	HW_ERROR_COMMON_RESERVED_9,
	HW_ERROR_COMMON_RESERVED_10,
	HW_ERROR_COMMON_RESERVED_11,
	HW_ERROR_COMMON_RESERVED_12,
	HW_ERROR_COMMON_RESERVED_13,
	HW_ERROR_COMMON_RESERVED_14,
	HW_ERROR_COMMON_RESERVED_15,
	HW_ERROR_COMMON_RESERVED_16,
	HW_ERROR_COMMON_RESERVED_17,
	HW_ERROR_COMMON_RESERVED_18,
	HW_ERROR_COMMON_RESERVED_19,
	HW_ERROR_COMMON_RESERVED_20,
	HW_ERROR_COMMON_RESERVED_21,
	HW_ERROR_COMMON_RESERVED_22,
	HW_ERROR_COMMON_RESERVED_23,
	HW_ERROR_COMMON_RESERVED_24,
	HW_ERROR_COMMON_RESERVED_25,
	HW_ERROR_COMMON_RESERVED_26,
	HW_ERROR_COMMON_RESERVED_27,
	HW_ERROR_COMMON_RESERVED_28,
	HW_ERROR_COMMON_RESERVED_29,
	HW_ERROR_COMMON_RESERVED_30,
	HW_ERROR_COMMON_RESERVED_31,
	HW_ERROR_COMMON_TOTAL_NUM,
	HW_ERROR_COMMON_MAX_NUM	= 0xFF 
} HwErrorIdCommon_e;


/*---------------------------------------------------------------------------------
/								Macros						
/----------------------------------------------------------------------------------*/
	

/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Function Declaration									
/----------------------------------------------------------------------------------*/
void HwErrors_MaskEvent0(HwErrorId_e hwError);
void HwErrors_MaskEvent1(HwErrorId_e hwError);
void HwErrors_MaskEvent2(HwErrorId_e hwError);
void HwErrors_UnMaskEvent0(HwErrorId_e hwError);
void HwErrors_UnMaskEvent1(HwErrorId_e hwError);
void HwErrors_UnMaskEvent2(HwErrorIdCommon_e hwError);
ISR_VOID isr_HwErrors_Band0(void);
ISR_VOID isr_HwErrors_Band1(void);
ISR_VOID isr_HwErrors_Common(void);
ISR_VOID isr_HwEvents_A_Band0(void);
ISR_VOID isr_HwEvents_A_Band1(void);
ISR_VOID isr_HwEvents_B_Band0(void);
ISR_VOID isr_HwEvents_B_Band1(void);
ISR_VOID isr_HwEvents_Common_A(void);

void HwErrors_Init(void);


void HwEvents_MaskEvent_A_Band0(HwEventIdBandRelA_e hwEvent);
void HwEvents_MaskEvent_B_Band0(HwEventIdBandRelB_e hwEvent);
void HwEvents_MaskEvent_A_Band1(HwEventIdBandRelA_e hwEvent);
void HwEvents_MaskEvent_B_Band1(HwEventIdBandRelB_e hwEvent);
void HwEvents_UnMaskEvent_A_Band0(HwEventIdBandRelA_e hwEvent);
void HwEvents_UnMaskEvent_B_Band0(HwEventIdBandRelB_e hwEvent);
void HwEvents_UnMaskEvent_A_Band1(HwEventIdBandRelA_e hwEvent);
void HwEvents_UnMaskEvent_B_Band1(HwEventIdBandRelB_e hwEvent);
void HwEvents_MaskEvent_Common_A(HwEventIdCommonA_e hwEvent);
void HwEvents_UnMaskEvent_Common_A(HwEventIdCommonA_e hwEvent);

ISR_VOID isr_HwEvents(void);
void HwEvents_Init(void);



#endif /* HW_EVENTS_AND_ERROS_API_H_ */
