/***********************************************************************************
 File:		HwEventsAndErrors_Api.h
 Module:		Hw Events & Errors
 Purpose:		
 Description:	
************************************************************************************/
#ifndef HW_EVENTS_AND_ERROS_API_H_
#define HW_EVENTS_AND_ERROS_API_H_

/*---------------------------------------------------------------------------------
/								Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "InterruptManager_Api.h"
/*---------------------------------------------------------------------------------
/								Defines						
/----------------------------------------------------------------------------------*/
typedef enum
{
	HW_EVENT_RXPP_FRAGMENT_FIFO_NOT_EMPTY = 0,
	HW_EVENT_RX_CLASSIFIER_FRAME_CLASS_VIOLATION,
	HW_EVENT_RX_CLASSIFIER_REKEY,
	HW_EVENT_PS_SETTING_FIFO_NOT_EMPTY,
	HW_EVENT_PD_THRESHOLD_REACHED,
	HW_EVENT_RD_THRESHOLD_REACHED,
	HW_EVENT_PHY,
	HW_EVENT_EXTERNAL_IRQ,
	HW_EVENT_RAB_NPU_TO_UPI_IRQ,
	HW_EVENT_UART,
	HW_EVENT_RXF_FIFO_NOT_EMPTY,
	HW_EVENT_Q_MANAGER_LOW_PRI_TX_READY,
	HW_EVENT_Q_MANAGER_LOW_PRI_RX_READY,
	HW_EVENT_Q_MANAGER_DESCRIPTOR_POOL,
#if defined (CPU_MIPS)
	HW_EVENT_MIPS_INTERNAL_IRQ,
#endif
#if defined (CPU_ARC)
	HW_EVENT_RESERVED_9,
#endif
	HW_EVENT_TX_SELECTOR,
	HW_EVENT_TXH_NTD_SW_REQ,
	HW_EVENT_ALPHA_FILTERS_CALC_REQ_DONE_INDICATION,
	HW_EVENT_RX_SECURITY_COMPLETE,
	HW_EVENT_RX_SECURITY_DESC_DONE_ACC_NOT_EMPTY,
	HW_EVENT_RX_SECURITY_DESC_MON_ADDR_CMP_RESULT,
	HW_EVENT_RX_CLASSIFIER_RXH_AVAILABLE_PENDING_RTD,
	HW_EVENT_AGER_SINGLE_CHECK_DONE,
	HW_EVENT_RX_HALT_INDICATION,
	HW_EVENT_TX_DMA_MON_ACC_NON_EMPTY_IND,
	HW_EVENT_DMA_WRRAPER_CH1_DONE_ACC_NOT_EMPTY,
	HW_EVENT_TX_SECURITY_COMPLETE,
	HW_EVENT_MAC_PHY_GP_IF_INDICATION,
	HW_EVENT_MU_LOCKER_DONE_INDICATION,
	HW_EVENT_RESERVED_6,
	HW_EVENT_RESERVED_7,
	HW_EVENT_RESERVED_8,
	HW_EVENT_TOTAL_NUM,
	HW_EVENT_MAX_NUM	= 0xFF 	
} HwEventId_e;


typedef enum
{
	HW_ERROR_RXC_RX_BUFFER_OVERFLOW				= 0,
	HW_ERROR_PAC_TX,
	HW_ERROR_BLOCK_ACK,
	HW_ERROR_NPU_ARB_BUS,
	HW_ERROR_SEQUENCER_ERROR,
	HW_ERROR_TX_SECURITY_FAIL,
	HW_ERROR_DELIA_LIMIT_TIMER_EXPIRED,
	HW_ERROR_DELIA_AUTO_FILL_COUNTER_LIMIT,
	HW_ERROR_DELIA_AUTO_FILL_END,
	HW_ERROR_RX_EOF_ERROR,
	HW_ERROR_RX_AGGR_ERROR,
	HW_ERROR_Q_MANAGER_UM_ERROR,
	HW_ERROR_Q_MANAGER_LM_ERROR,
	HW_ERROR_ARM_DMA_ABORT,
	HW_ERROR_TX_SELECTOR,
	HW_ERROR_BA_ANALYZER,
	HW_ERROR_WLAN_MAC_XBAR_DMA,
	HW_ERROR_RX_SECURITY_FAIL,
	HW_ERROR_RX_CLASSIFIER,
	HW_ERROR_RXC_RX_FIFO_OVERFLOW,
	HW_ERROR_BF_REPORT_AUTO_REPLY_ABORT,
	HW_ERROR_DELINEATOR_FIFO_FULL,
	HW_ERROR_TOTAL_NUM,
	HW_ERROR_MAX_NUM	= 0xFF 
} HwErrorId_e;


/*---------------------------------------------------------------------------------
/								Macros						
/----------------------------------------------------------------------------------*/
	
#define	 MASK_HW_ERROR_RX()				HwErrors_MaskEvent(HW_ERROR_RX_EOF_ERROR);
#define	 MASK_HW_ERROR_PAC_RX()			HwErrors_MaskEvent(HW_ERROR_RX_AGGR_ERROR);
#define	 UN_MASK_HW_ERROR_RX()			HwErrors_UnMaskEvent(HW_ERROR_RX_EOF_ERROR);
#define	 UN_MASK_HW_ERROR_PAC_RX()		HwErrors_UnMaskEvent(HW_ERROR_RX_AGGR_ERROR);

/*---------------------------------------------------------------------------------
/					Data Type Definition												
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Public Function Declaration									
/----------------------------------------------------------------------------------*/
void HwErrors_MaskEvent(HwErrorId_e hwError);
void HwErrors_UnMaskEvent(HwErrorId_e hwError);
ISR_VOID isr_HwErrors(void);
void HwErrors_Init(void);


void HwEvents_MaskEvent(HwEventId_e hwEvent);
void HwEvents_UnMaskEvent(HwEventId_e hwEvent);
ISR_VOID isr_HwEvents(void);
void HwEvents_Init(void);



#endif /* HW_EVENTS_AND_ERROS_API_H_ */
