/***********************************************************************************
File:				HwCounters.h
Module:			Hw Counters
Purpose:
Description:		
************************************************************************************/
#ifndef _HW_COUNTERS_H_
#define _HW_COUNTERS_H_

/*---------------------------------------------------------------------------------
/						Includes													 
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h" 
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "ieee80211.h"


/*---------------------------------------------------------------------------------
/						Defines													 
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/
#define INC_BAA_HW_COUNTERS_MANAGEMENT_FRAME_SENT			(BaaCounters->fwMngmntframesSent++)
#define INC_BAA_HW_COUNTERS_MANAGEMENT_FRAME_CONFIRMED		(BaaCounters->fwMngmntFramesConfirmed++)
#define INC_BAA_HW_COUNTERS_MANAGEMENT_FRAME_RECIEVED		(BaaCounters->fwMngmntframesRecieved++)
#define INC_BAA_HW_COUNTERS_CONTROL_FRAME_SENT				(BaaCounters->fwctrlFramesSent++)
#define INC_BAA_HW_COUNTERS_CONTROL_FRAME_RECIEVED			(BaaCounters->fwctrlFramesRecieved++)
#define INC_BAA_HW_COUNTERS_MULTICAST_REPLAYED_PACKET		(BaaCounters->fwMulticastReplayedPackets++)
#define INC_BAA_HW_COUNTERS_PAIRWISE_MIC_FAILURE_PACKET		(BaaCounters->fwPairWiseMicFailurePackets++)
#define INC_BAA_HW_COUNTERS_GROUP_MIC_FAILURE_PACKET		(BaaCounters->fwMngmntFramesConfirmed++)
#define INC_BAA_HW_COUNTERS_BEACON_PROBE_RESPONSE_PHY_TYPE	(BaaCounters->beaconProbeResponsePhyType++)
#define INC_BAA_HW_COUNTERS_RX_BASIC_REPORT					(BaaCounters->rxBasicReport++)

	
/*---------------------------------------------------------------------------------
/						Data Type Definition													 
/----------------------------------------------------------------------------------*/
#include "Statistics_Descriptors.h"

/*
typedef struct HostIfCounters
{
	uint16 qosTxSta[HW_NUM_OF_STATIONS][ACCESS_CATEGORY_NUM];
	uint16 qosTxVap[HW_NUM_OF_VAPS][ACCESS_CATEGORY_NUM];
	uint32 txInUnicastHd[HW_NUM_OF_VAPS];		
	uint32 txInMulticastHd[HW_NUM_OF_VAPS]; 
	uint32 txInBroadcastHd[HW_NUM_OF_VAPS]; 
	uint32 txInUnicastNumOfBytes[HW_NUM_OF_VAPS];	
	uint32 txInMulticastNumOfBytes[HW_NUM_OF_VAPS]; 
	uint32 txInBroadcastNumOfBytes[HW_NUM_OF_VAPS]; 	
	uint32 rxOutUnicatHd[HW_NUM_OF_VAPS];	
	uint32 rxOutMulticastHd[HW_NUM_OF_VAPS];	
	uint32 rxOutBroadcastHd[HW_NUM_OF_VAPS];	
	uint32 rxOutUnicastNumOfBytes[HW_NUM_OF_VAPS];	
	uint32 rxOutMulticastNumOfBytes[HW_NUM_OF_VAPS];	
	uint32 rxOutBroadcastNumOfBytes[HW_NUM_OF_VAPS];	
	uint32 rxOutStaNumOfBytes[HW_NUM_OF_STATIONS];		
	uint32 agerCount[HW_NUM_OF_VAPS];	
}HostIfCounters_t; 
	
// Rx Counters
typedef struct RxCounters
{
	uint16 qosRxSta[HW_NUM_OF_STATIONS];
	uint32 rdCount[HW_NUM_OF_STATIONS];
	uint32 rddelayed[HW_NUM_OF_STATIONS];
	uint32 swUpdateDrop[HW_NUM_OF_STATIONS];
	uint32 rdDuplicateDrop[HW_NUM_OF_STATIONS];
	uint32 missingSn[HW_NUM_OF_STATIONS];	
	uint32 mpduUnicastOrMngmnt[HW_NUM_OF_VAPS];
	uint32 mpduRetryCount[HW_NUM_OF_VAPS];
	uint32 amsdu[HW_NUM_OF_VAPS];
	uint32 dropMpdu[HW_NUM_OF_VAPS];
	uint32 mpduTypeNotSupported[HW_NUM_OF_VAPS];
	uint32 replayData[HW_NUM_OF_VAPS];
	uint32 replayMngmnt[HW_NUM_OF_VAPS];
	uint32 tkipCount[HW_NUM_OF_VAPS];
	uint32 securityFailure[HW_NUM_OF_VAPS];
	uint32 amsduBytes[HW_NUM_OF_VAPS];
	uint32 ampdu[HW_NUM_OF_VAPS];
	uint32 mpduInAmpdu[HW_NUM_OF_VAPS];
	uint32 octetsInAmpdu[HW_NUM_OF_VAPS];
	uint32 rxClassifierDrop[HW_NUM_OF_VAPS];
	uint32 rxClassifierSecurityMismatch[HW_NUM_OF_VAPS];
	uint32 barMpduCount;
	uint32 crcErrorCount;
	uint32 delCrcError;
} RxCounters_t;


// BAA Counters
typedef struct BaaCounters
{
	uint32 rertyCount;
	uint32 multipleRetryCount;
	uint32 rtsSuccessCount[HW_NUM_OF_VAPS];
	uint32 qosTransmittedFrames[HW_NUM_OF_VAPS];
	uint32 transmittedAmsdu[HW_NUM_OF_VAPS];
	uint32 transmittedOctetsInAmsdu[HW_NUM_OF_VAPS];
	uint32 transmittedAmpdu[HW_NUM_OF_VAPS];
	uint32 transmittedMpduInAmpdu[HW_NUM_OF_VAPS];
	uint32 transmittedOctetsInAmpdu[HW_NUM_OF_VAPS];
	uint32 beamformingFrames[HW_NUM_OF_VAPS];
	uint32 transmitStreamRprtMSDUFailed[HW_NUM_OF_VAPS];
	uint32 rtsFailure[HW_NUM_OF_VAPS];
	uint32 ackFailure[HW_NUM_OF_VAPS];
	uint32 failedAmsdu[HW_NUM_OF_VAPS];
	uint32 retryAmsdu[HW_NUM_OF_VAPS];
	uint32 multipleRetryAmsdu[HW_NUM_OF_VAPS];
	uint32 amsduAckFailure[HW_NUM_OF_VAPS];
	uint32 implicitBarFailure[HW_NUM_OF_VAPS];
	uint32 explicitBarFailure[HW_NUM_OF_VAPS];
	uint32 mpduFirstRetransmission[HW_NUM_OF_STATIONS];
	uint32 mpduTransmitted[HW_NUM_OF_STATIONS];
	uint32 mpduByteTransmitted[HW_NUM_OF_STATIONS];
	uint32 transmitStreamRprtMultipleRetryCount[HW_NUM_OF_VAPS];
	uint32 transmitBw20[HW_NUM_OF_VAPS];
	uint32 transmitBw40[HW_NUM_OF_VAPS];
	uint32 transmitBw80[HW_NUM_OF_VAPS];
	uint32 rxGroupFrame[HW_NUM_OF_VAPS];
	uint32 txSenderError[HW_NUM_OF_VAPS];
	uint32 fwMngmntframesSent;
	uint32 fwMngmntFramesConfirmed;
	uint32 fwMngmntframesRecieved;
	uint32 fwctrlFramesSent;
	uint32 fwctrlFramesRecieved;
	uint32 fwMulticastReplayedPackets;
	uint32 fwPairWiseMicFailurePackets;
	uint32 groupMicFailurePackets;
	uint32 beaconProbeResponsePhyType;
	uint32 rxBasicReport;
	uint32 txFrameErrorCount;
} BaaCounters_t;
*/



#endif //_HW_COUNTERS_H_


