/***********************************************************************************
 File:			
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_GLOBAL_DEFINITION_H_
#define HW_GLOBAL_DEFINITION_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "DescriptorsDefinitions.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define HW_NUM_OF_VAPS					(NUM_OF_VAPS)	/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
#define HW_NUM_OF_MU_GROUPS				(64)
#define HW_NUM_OF_STATIONS				(NUM_OF_STAS)	/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
#define NUM_OF_RX_ANT 4

#define NEXT_PD_NULL (0xFFFFFF)
#define NEXT_RD_NULL (0xFFFFFF)


#define NUM_OF_BW (4)									/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */

#define LOGGER_HW_DEFAULT_PRIORITY (0x2)

/* Max MU Groups */
#define TX_MU_GROUPS	16

typedef enum {
	HW_TX_Q_TYPE_STA_TID		= TXQ_GROUP_ID_UNICAST,
	HW_TX_Q_TYPE_VAP_TID		= TXQ_GROUP_ID_MC,
	HW_TX_Q_TYPE_GLOBAL			= TXQ_GROUP_ID_GLOBAL,
	HW_TX_Q_TYPE_GPLP			= TXQ_GROUP_ID_GPLP,
	HW_TX_Q_TYPE_GPHP			= TXQ_GROUP_ID_GPHP,
	HW_TX_Q_TYPE_BEACON			= TXQ_GROUP_ID_BEACON,
	HW_TX_NUM_OF_QUEUE_TYPES,
	HW_TX_Q_TYPE_DISABLED		= 0x1E,
	HW_TX_Q_TYPE_AGED			= 0x1F,
	HW_TX_Q_MAX_NUM_OF_QUEUE_TYPES = MAX_UINT8,
}TxQueueType_e; 

typedef enum {
	HW_AC_BE     = 0x0,
	HW_AC_BK     = 0x1,
	HW_AC_VI     = 0x2,
	HW_AC_VO     = 0x3,
	HW_AC_GPLP   = 0x5,
	HW_AC_GPHP   = 0x6,
	HW_AC_BEACON = 0x7,
	HW_AC_NUM_OF_PRIORITIES,
	HW_AC_MAX_NUM_OF_ACS,
}HwExtendedAcs_e; 


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/


#endif   /* HW_GLOBAL_DEFINITION_H_ */
