#ifndef  _PACKET_DESCRIPTOR_H_
#define  _PACKET_DESCRIPTOR_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Std.h"
#include "Hd_Descriptors.h"
#ifdef HOST_IF_COUNTERS_WORKAROUND
#include "PumaHd_Descriptors.h"
#endif
#include "TxPd_Descriptors.h"
#ifdef ENET_INC_ARCH_WAVE600B
#include "FlmHd_Descriptors.h"
#include "FlmReducedHd_Descriptors.h"
#include "LgmReducedHd_Descriptors.h"
#endif

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define PCK_DSCPTR_TID_LINE_NUM			(1)
#define PCK_DSCPTR_TID_OFFSET			(32)
#define PCK_DSCPTR_MC_LINE_NUM			(0)
#define PCK_DSCPTR_LENGTH_LINE_NUM		(0)
#define PCK_DSCPTR_LENGTH_BIT_OFFSET	(0)

#define PCK_DSCPTR_MC_BIT_OFFSET		(15)
#define PCK_DSCPTR_GROUP_IDX_LINE_NUM	(1)
#define PCK_DSCPTR_GROUP_IDX_BIT_OFFSET	(4)
#define PCK_DSCPTR_OWN_LINE_NUM			(3)
#define PCK_DSCPTR_OWN_BIT_OFFSET		(31)


#define TX_OUT_HOST_DESCRIPTOR_SIZE	(4) /* Only payload address is passed to GSWIP on tx out*/
#define RX_IN_HOST_DESCRIPTOR_SIZE	(0) /* There is HD passed on Rx In When working on fast path*/



typedef struct _MulticastSubIfId_t
{ 
	uint8 Index    :7;
	uint8 Reserved :1;
}MulticastSubIfId_t;

typedef struct _UnicastSubIfId_t
{ 
	uint8 StaId;
}UnicastSubIfId_t;



typedef union _DestSubIfId_u
{
	MulticastSubIfId_t MulticastIf;
	UnicastSubIfId_t UnicastIf;
}DestSubIfId_u;




typedef struct reliableMcastPacketDescriptor
{
	TxPd_t pd;
    uint32 parentPd;
} reliableMcastPacketDescriptor_t;


typedef enum {
	UNICAST = 0,
	MULTICAST 
}Mcf_e; 


typedef enum
{
	PD_STATUS_ACK_RECEIVED = 0,
	PD_STATUS_DISCARDED_BY_AGER = 1, /* Do not change this value - HW value */	
	PD_STATUS_BLOCK_ACK_RECEIVED = 2,
	PD_STATUS_NACK = 3,
	PD_STATUS_NUM_OF_TYPES,
	PD_STATUS_MAX_NUM_OF_TYPES = 0xFF,	
} PdStatus_e;


typedef struct PacketDescriptorPool
{
	TxPd_t* volatile pHead;
	uint16 numOfDescInPool;
	uint16 maxDescInPool;
}PacketDescriptorPool_t;


typedef struct PacketDescriptorQueue
{
	TxPd_t* volatile pHead;
	TxPd_t* volatile pTail;
}PacketDescriptorQueue_t;


typedef enum {
	PD_CONTROL_20_MHZ = 0,
	PD_CONTROL_40_MHZ = 1,
	PD_CONTROL_80_MHZ = 2,
	PD_CONTROL_MAX_NUM_OF_BW = 0xFF,
}PdControlBwType_e; 

#define GET_NEXT_PD(pDesc) (PacketDescriptorsPtr + ((pDesc)->nextPdPointer))
#define SET_NEXT_PD(pDesc) (((uint32 *)(pDesc)) - PacketDescriptorsPtr)
#define NULL_PD (PacketDescriptorsPtr + (NEXT_PD_NULL))
#define CONVERT_OFFSET_TO_PD(offset) (PacketDescriptorsPtr + (offset))
#define CONVERT_PD_TO_OFFSET(packetDescriptor) (((uint32 *)(packetDescriptor)) - PacketDescriptorsPtr)


#endif //_PACKET_DESCRIPTOR_H_


