/***********************************************************************************
 File:			RxDescriptor.h
 Module:		Rx Descriptor 
 Purpose: 		
 Description:   This File contains the defintions of the Rx descriptor
************************************************************************************/
#ifndef RX_DESCRIPTOR_H_
#define RX_DESCRIPTOR_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

#include "Rd_Descriptors.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define RD_TX_QID_LINE_NUM				(1)
#define RD_TX_QID_OFFSET				(0) /* offset in 64 bit word */


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
#define GET_NEXT_RD(rxDescriptor) 			(PacketDescriptorsPtr + (rxDescriptor->nextRd))//TBD  CHECK what is the base address for RDs
#define SET_NEXT_RD(rxDescriptor) 			(((uint32*)rxDescriptor) - PacketDescriptorsPtr)//TBD  CHECK what is the base address for RDs
#define NULL_RD 							(PacketDescriptorsPtr + (NEXT_RD_NULL))//TBD  CHECK what is the base address for RDs
#define CONVERT_OFFSET_TO_RD(offset) 		(PacketDescriptorsPtr + offset)//TBD  CHECK what is the base address for RDs
#define CONVERT_RD_TO_OFFSET(rxDescriptor) (((uint32 *)(rxDescriptor)) - PacketDescriptorsPtr)

#define CONVERT_DRAM_POINTER_TO_BYTE_ADDRESS(dramPointer)	(dramPointer << 4)	//Dram pointer in gen6 is 16 bytes address. shift by 4 make it byte address.
#define CONVERT_BYTE_ADDRESS_TO_DRAM_POINTER(address)		(address >> 4)		// convery byte address to 16 bytes address (address mist be 16 bytes aligned, otherwise we truncate it)
#define CONVERT_RD_OFFSET_TO_HD_OFFSET(offset)				(offset&0x7)		// copy to the HD the first 3 bits from RD offset since in gen 6 the offset in RD is 4 bits and in the hd its 3 bits
#define GET_BIT4_IN_RD_OFFSET(offset)						(offset&0x8)			// get from the RD offset the last bit in order to place it the pointer To Dram at the HD





typedef struct rxDescriptorQueue
{
	Rd_t *volatile pHead;
	Rd_t *volatile pTail;
}rxDescriptorQueue_t;


#endif /* RX_DESCRIPTOR_H_ */

