/***********************************************************************************
File:				StaDb.h
Module:				StaDb
Purpose:
Description:		This File was auto generated using Descriptor Excel Parser
************************************************************************************/
#ifndef _STA_DB_H_
#define _STA_DB_H_

/*---------------------------------------------------------------------------------
/						Includes													 
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h" 
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "SharedDbTypes.h"

#include "StaDb_Descriptors.h"
#include "Tcr_Descriptors.h"

/*---------------------------------------------------------------------------------
/						Defines													 
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition													 
/----------------------------------------------------------------------------------*/
#ifdef ENET_INC_ARCH_WAVE600
/*
"00" - Policy is Low to High: TX Selector Algorithm shall select additional TIDs from Primary AC to any AC that has a higher priority with respect to the primary AC
"01" - Policy is High to Low: TX Selector Algorithm shall select additional TIDs from Primary AC to any AC that has a lower priority with respect to the primary AC
"10" - Policy is ALL: TX Selector Algorithm shall select additional TIDs Starting from highest priority AC to the lowest priority AC
*/
typedef enum
{
	MULTI_TID_SELECT_LOW_TO_HIGH = 0,
	MULTI_TID_SELECT_HIGH_TO_LOW = 1,
	MULTI_TID_SELECT_ALL = 2,
	MULTI_TID_SELECT_DEFAULT = MULTI_TID_SELECT_LOW_TO_HIGH
} MultiTidSelectPolicy_e;

// Multi-TID RR Weights, used by OTFA to build aggregation selecting each TID packets according its own weight
// where 1 is the highst priority and 8 (which is equal to 0) lowest priority
typedef enum
{
	MULTI_TID_RR_WEIGHT_8 = 0,
	MULTI_TID_RR_WEIGHT_1 = 1,
	MULTI_TID_RR_WEIGHT_2 = 2,
	MULTI_TID_RR_WEIGHT_3 = 3,
	MULTI_TID_RR_WEIGHT_4 = 4,
	MULTI_TID_RR_WEIGHT_5 = 5,
	MULTI_TID_RR_WEIGHT_6 = 6,
	MULTI_TID_RR_WEIGHT_7 = 7,
} MultiTidRrWeight_e;

typedef enum
{
	MULTI_TID_MNG_AGGREGATION_OFF = 0,
	MULTI_TID_MNG_AGGREGATION_ON = 1
} MultiTidMngAgg_e;

#define MULTI_TID_SET_MNG_BIT_8 			(0x100)
#define MULTI_TID_CLEAR_MNG_BIT_8 			(0xFF)

typedef enum
{
	MULTI_TID_ACK_ENABLED_UNSUPPORTED = 0,
	MULTI_TID_ACK_ENABLED_SUPPORTED	  = 1
} MultiTidAckEn_e;

#define MULTI_TID_BAR_AGGREGATION_DEFAULT 	(0)

#define MULTI_TID_CLEAR_ALL_TIDS		 	(0)

#endif //ENET_INC_ARCH_WAVE600

#endif //_STA_DB_H_
