/***********************************************************************************
 File:			
 Module:		
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_GLOBAL_DEFINITION_H_
#define HW_GLOBAL_DEFINITION_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define HW_NUM_OF_VAPS					(16)	/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
#define HW_NUM_OF_MU_GROUPS				(128)
#define HW_NUM_OF_STATIONS				(128)	/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
#define RX_NUM_OF_SECURITY_DESCRIPTORS  (64)
#define NUM_OF_RX_ANT 4

#define NEXT_PD_NULL (0xFFFF)
#define NEXT_RD_NULL (0xFFFF)


#define NUM_OF_BW (3)							/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */
#define NUM_OF_ACS (4)
#define NUM_OF_TIDS (8)							/* Warning: if you modify this value please also modify it at Statistics_Descriptors.h */


#define DRAM_ADDRESS_TO_BYTES (2)

/* TX QID filed definitions*/
#define INDEX_TID_MASK			 (0x7)
#define INDEX_STA_ID_OFFSET		 (0x3)

#define LOGGER_HW_DEFAULT_PRIORITY (0x2)

/* Max MU Groups */
#define TX_MU_GROUPS	8


typedef enum {
	HW_TX_Q_TYPE_NONE			= 0x0,
	HW_TX_Q_TYPE_STA_TID		= 0x0,
	HW_TX_Q_TYPE_VAP_TID		= 0x2,
	HW_TX_Q_TYPE_GLOBAL			= 0x4,
	HW_TX_Q_TYPE_GPLP,
	HW_TX_Q_TYPE_GPHP,
	HW_TX_Q_TYPE_BEACON,
	HW_TX_NUM_OF_QUEUE_TYPES,
	HW_TX_Q_TYPE_DISABLED		= 0x1E,
	HW_TX_Q_TYPE_AGED			= 0x1F,
	HW_TX_Q_MAX_NUM_OF_QUEUE_TYPES = MAX_UINT8,
}TxQueueType_e; 

typedef enum {
	HW_AC_BE     = 0x0,
	HW_AC_BK     = 0x1,
	HW_AC_VI     = 0x2,
	HW_AC_VO     = 0x3,
	HW_AC_GPLP   = 0x5,
	HW_AC_GPHP   = 0x6,
	HW_AC_BEACON = 0x7,
	HW_AC_NUM_OF_PRIORITIES,
	HW_AC_MAX_NUM_OF_ACS,
}HwExtendedAcs_e; 

/* Descriptors  Constants */
typedef enum 
{
	TX_POSTPONE_MODE_NOT_SUPPORTED	= 0,
	TX_POSTPONE_MODE_CTS_2_SELF		= 1,
	TX_POSTPONE_MODE_RTS_CTS		= 2,
	TX_POSTPONE_MODE_NOT_NDP_ACK	= 3,
} TxPostponeMode_e;

typedef enum 
{
	RTS_CTS_TX_METHOD_NO_RTS_CTS				= 0,
	RTS_CTS_TX_METHOD_RTS_CTS_BASED_THRESHOLD	= 1,
	RTS_CTS_TX_METHOD_FORCE_RTS_CTS			= 3,
} RtsCtsTxMethod_e;

typedef enum 
{
	CTS_TO_SELF_TX_METHOD_NO_CTS2SELF 			= 0,
	CTS_TO_SELF_TX_METHOD_CTS2SELF_BASED_THRESHOLD	= 1,
	CTS_TO_SELF_TX_METHOD_FORCE_CTS2SELF			= 3,
} Cts2SelfTxMethod_e;

typedef enum
{
	HW_PHY_MODE_11_AG = 0,
	HW_PHY_MODE_11_B  = 1,
	HW_PHY_MODE_11_N  = 2,
	HW_PHY_MODE_11_AC = 3,
} HwPhyMode_e;


typedef enum
{
	HW_SPECTRUM_MODE_20_MHZ	= 0,
	HW_SPECTRUM_MODE_40_MHZ	= 1,
	HW_SPECTRUM_MODE_80_MHZ	= 2,
} HwSpectrumMode_e;

typedef enum 
{
	HW_BF_MODE_BYPASS			= 0,
	HW_BF_MODE_BEAMFORMING		= 1,
	HW_BF_MODE_CALIBRATION		= 2,
	HW_BF_MODE_FLAT_BEAMFORMING	= 3,
} HwBeamformingMode_e;

typedef enum
{
	PPDU_TX_MODE_AMSDU_AMPDU_DISABLED = 0,
	PPDU_TX_MODE_AMSDU_ONLY_DISABLED  = 1,
	PPDU_TX_MODE_AMSDU_AMPDU_ENABLED  = 2,
} HwPpduTxMode_e;

// Req 2: adding enum to make the code more readable 
typedef enum
{
	VAP_MODE_AP  = 0,	// 0
	VAP_MODE_STA = 1,	// 1
	NUM_OF_VAP_MODES
} HwVapMode_e; 

/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/


#endif   /* HW_GLOBAL_DEFINITION_H_ */
