#ifndef  _PACKET_DESCRIPTOR_H_
#define  _PACKET_DESCRIPTOR_H_

/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "Std.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/

#define PCK_DSCPTR_TID_LINE_NUM			(1)
#define PCK_DSCPTR_TID_OFFSET			(32)
#define PCK_DSCPTR_MC_LINE_NUM			(0)
#define PCK_DSCPTR_MC_BIT_OFFSET		(25)
#define PCK_DSCPTR_GROUP_IDX_LINE_NUM	(0)
#define PCK_DSCPTR_GROUP_IDX_BIT_OFFSET	(0)
#define PCK_DSCPTR_OWN_LINE_NUM			(3)
#define PCK_DSCPTR_OWN_BIT_OFFSET		(31)


#define TX_IN_HOST_DESCRIPTOR_SIZE	(16)
#define TX_OUT_HOST_DESCRIPTOR_SIZE	(4) /* Only payload address is passed to GSWIP on tx out*/
#define RX_IN_HOST_DESCRIPTOR_SIZE	(0) /* There is HD passed on Rx In When working on fast path*/
#define RX_OUT_HOST_DESCRIPTOR_SIZE	(16)

#define DESCRIPTOR_SIZE_PUMA (16) /* For PUMA Direct Connect HD size is 4DW */	

#define TX_IN_HOST_DESCRIPTOR_SIZE_PUMA		DESCRIPTOR_SIZE_PUMA 
#define TX_OUT_HOST_DESCRIPTOR_SIZE_PUMA	DESCRIPTOR_SIZE_PUMA
#define RX_IN_HOST_DESCRIPTOR_SIZE_PUMA		DESCRIPTOR_SIZE_PUMA
#define RX_OUT_HOST_DESCRIPTOR_SIZE_PUMA	DESCRIPTOR_SIZE_PUMA


typedef struct _MulticastSubIfId_t
{ 
	uint8 Index    :7;
	uint8 Reserved :1;
}MulticastSubIfId_t;

typedef struct _UnicastSubIfId_t
{ 
	uint8 StaId;
}UnicastSubIfId_t;



typedef union _DestSubIfId_u
{
	MulticastSubIfId_t MulticastIf;
	UnicastSubIfId_t UnicastIf;
}DestSubIfId_u;




typedef struct _HdCommon_t
{
	uint32 staId	  :8; 
	uint32 vapId      :4;  //vap ID
	uint32 powerManagement  :1;  // 0-QoS NDP Power save indication off, 1-Qos NDP Power save indication on 	
	uint32 unknownSidInd  	:1;
	uint32 multicastIndication		  :1;  // 1- multicast 0-unicast
	uint32 etype      :2;
	uint32 action  	  :7; 
    uint32 type       :2;
    uint32 subtype    :4;
    uint32 status     :1;
	uint32 Reserved3  :1;


	uint32 class      :4;
	uint32 Reserved4  :4;
	uint32 Ep         :4;
	uint32 Reserved5  :4;
	uint32 Color	  :2;
	uint32 Mpe1		  :1;
	uint32 Mpe2       :1;
	uint32 Enc        :1;
	uint32 Dec        :1;
    uint32 Dpi        :1;
    uint32 Toe        :1;
	uint32 Reserved6  :8;

	uint32 pointerToDramWordOffset;

	uint32 length     :16;
	uint32 QID		  :4;
	uint32 Reserved7  :3;
	uint32 pointerToDramByteOffset :3;
#ifndef CBM_FRAGMENTATION_WORKAROUND
	uint32 Reserved8  :2;
#else	
	uint32 Reserved8  :1;
	uint32 FragReady  :1; //used to indicate when hd was entirely copied to ring (same logic as own)
#endif //CBM_FRAGMENTATION_WORKAROUND
	uint32 eop		  :1;
	uint32 sop		  :1;
	uint32 C          :1;
	uint32 Own		  :1;

    uint32 bdIndex;
} HdCommon_t;

typedef HdCommon_t Hd_t;



typedef struct _TxPdCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 aMsduTailPointer : 16; //bits [0..15]
			uint32                  : 16;
		}; //Valid in A-MSDU header PD
		struct
		{
			uint32 aMsduDataLength : 14; //bits [0..13]
			uint32                 : 18;
		}; //Valid in the A-MSDU tail PD
		struct
		{
			uint32           : 14;
			uint32 powerManagement  :1;  // 0-QoS NDP Power save indication off, 1-Qos NDP Power save indication on 	
			uint32 Reserved1  :1;
			uint32           : 16;
		}; //Valid in the A-MSDU tail PD
		struct
		{
			uint32 mgmtPacketType : 16; //bits [0..15]
			uint32                : 16;
		}; //Valid in MGMT PD
		struct
		{
			uint32 mgmtActionValue : 5;  //bits [0..4]
			uint32                 : 27;
		}; //Valid in MGMT PD
		struct
		{
			uint32                : 5;
			uint32 mgmtActionCode : 7;  //bits [5..11]
			uint32                : 20;
		}; //Valid in MGMT PD
		struct
		{
			uint32             : 12;
			uint32 mgmtSubtype : 4;  //bits [12..15]
			uint32             : 16;
		}; //Valid in MGMT PD
		struct
		{
			uint32 beaconProberesIndex : 8;  //bits [0..7]
			uint32                     : 24;
		}; //Valid in Beacon & Probe Response PDs
		struct
		{
			uint32                          : 8;
			uint32 beaconProberesPdListType : 2;  //bits [8..9]
			uint32                          : 22;
		}; //Valid in Beacon & Probe Response PDs
		struct
		{
			uint32           : 10;
			uint32 reserved1 : 2;  //bits [10..11]
			uint32           : 20;
		}; //Valid in Beacon & Probe Response PDs
		struct
		{
			uint32                       : 12;
			uint32 beaconProberesSubtype : 4;  //bits [12..15], values from BeaconProberesSubtype_e
			uint32                       : 16;
		}; //Valid in Beacon & Probe Response PDs
		struct
		{
			uint32 ctrlBw : 2;  //bits [0..1], values from Bw_e
			uint32        : 30;
		}; //Valid in CTRL_UNENC PD
		struct
		{
			uint32           : 2;
			uint32 reserved2 : 10; //bits [2..11]
			uint32           : 20;
		}; //Valid in CTRL_UNENC PD
		struct
		{
			uint32             : 12;
			uint32 ctrlSubtype : 4;  //bits [12..15], values from CtrlSubtype_e
			uint32             : 16;
		}; //Valid in CTRL_UNENC PD
		struct
		{
			uint32 trainingDuration : 16; //bits [0..15]
			uint32                  : 16;
		}; //For training BF Polls and CTS2Self filler
		struct
		{
			uint32                  : 16;
			uint32 isCts2SelfTxDone : 1;
			uint32                  : 15;
		}; //Valid for Control Trigger Frame PD
		struct
		{
			uint32        : 17;
			uint32 isSuTf : 1;
			uint32        : 14;
		}; //Valid for Control Trigger Frame PD
		struct
		{
			uint32           : 18;
			uint32 reserved3 : 7;
			uint32           : 7;
		};
		struct
		{
			uint32           : 16;
			uint32 pdCounter : 8;
			uint32           : 8;
		}; //Valid in A-MSDU header, Beacon & Probe Response PDs
		struct
		{
			uint32               : 16;
			uint32 rtsRetryCount : 8;  //bits [16..23]
			uint32               : 8;
		}; //Valid in Data and MGMT when no TS is open
		struct
		{
			uint32           	: 24;
			uint32 unnkownSid 	: 1;
			uint32           	: 7;
		};
		struct
		{
			uint32           : 25;
			uint32 mcUnicast : 1;  //bit [25], values from McUnicast_e
			uint32           : 6;
		};
		struct
		{
			uint32        : 26;
			uint32 pdType : 4;  //bits [26..29], values from PdType_e
			uint32        : 2;
		};
		struct
		{
			uint32                          : 30;
			uint32 retransmissionIndication : 1;  //bit [30]
			uint32                          : 1;
		};
		struct
		{
			uint32                       : 31;
			uint32 aggregationIndication : 1;  //bit [31]
		}; //Set in the A-MSDU header PD
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 nextPdPointer : 16;
			uint32               : 16;
		}; //word address, NULL == 0xFFFF
		struct
		{
			uint32            : 16;
			uint32 dataLength : 14;
			uint32            : 2;
		};
		struct
		{
			uint32         : 30;
			uint32 ethType : 2; //values from TxPdCommon_EthType_e
		}; //valid in DATA
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 packetPointer : 32; //bits [0..31]
		}; //Valid in DATA and MGMT, BAR, Beacon & Probe Response and training
		struct
		{
			uint32 packetPointerByteOffset : 2;  //bits [0..1]
			uint32                         : 30;
		}; //Valid in DATA and MGMT, BAR, Beacon & Probe Response and training
		struct
		{
			uint32                      : 2;
			uint32 packetPointerInWords : 30; //bits [2..31]
		}; //Valid in DATA and MGMT, BAR, Beacon & Probe Response and training
		struct
		{
			uint32 cts2SelfDuration : 16; //bits [0..15]
			uint32                  : 16;
		}; //Valid in CTRL_UNENC PD
		struct
		{
			uint32           : 16;
			uint32 reserved5 : 16;
		}; //Valid in CTRL_UNENC PD
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 txQId : 18; //bits [0..17]
			uint32       : 14;
		};
		struct
		{
			uint32 txQTid : 3;  //bits [0..2]
			uint32        : 29;
		};
		struct
		{
			uint32          : 3;
			uint32 txQStaId : 8;  //bits [3..10]
			uint32          : 21;
		};
		struct
		{
			uint32          : 11;
			uint32 txQVapId : 4;  //bits [11..14]
			uint32          : 17;
		};
		struct
		{
			uint32          : 15;
			uint32 txQGroupId : 3;  //bits [15..17], values from TxqGroupId_e
			uint32          : 14;
		};
		struct
		{
			uint32          : 18;
			uint32 ttlCount : 7;  //bits [18..24]
			uint32          : 7;
		};
		struct
		{
			uint32          : 25;
			uint32 pdSource : 3;  //bits [25..27]
			uint32          : 4;
		};
		struct
		{
			uint32        : 28;
			uint32 status : 4;  //bits [28..31]
		};
		struct
		{
			uint32            : 28;
			uint32 statusAger : 1;  //bit [28]
			uint32            : 3;
		};
		struct
		{
			uint32                 : 29;
			uint32 statusReserved0 : 3;  //bits [29..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 sn : 12; //bits [0..11]
			uint32    : 20;
		}; //Not in BAR / CTRL
		struct
		{
			uint32 numOfTrainingStas : 4;  //bits [0..3]
			uint32                   : 28;
		}; //Number of training STAs minus 1; Valid only in Training
		struct
		{
			uint32                   : 4;
			uint32 trainingReserved0 : 8;  //bits [4..11]
			uint32                   : 20;
		}; //Valid only in Training
		struct
		{
			uint32            : 12;
			uint32 retryCount : 4;  //bits [12..15]
			uint32            : 16;
		};
		struct
		{
			uint32      : 16;
			uint32 pn01 : 16; //bits [16..31]
		}; //Not in BAR / CTRL
		struct
		{
			uint32 triggerFrameDuration : 16;
			uint32                      : 16;
		}; //Valid for Control Trigger Frame PD
		struct
		{
			uint32                      : 16;
			uint32 triggerFrameReserved : 16;
		}; //Valid for Control Trigger Frame PD
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 pn25 : 32; //bits [0..31]
		}; //Not in BAR / CTRL
		struct
		{
			uint32 trainingPerStaStructPointer : 32; //bits [0..31]
		}; //Valid only in Training; Shoukd be word aligned address
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 bdIndex : 16;
			uint32         : 16;
		}; //Only No-GSWIP mode
		struct
		{
			uint32           : 16;
			uint32 reserved6 : 16;
		}; //Only No-GSWIP mode
	};
} TxPdCommon_t;

typedef TxPdCommon_t TxPd_t;



typedef struct reliableMcastPacketDescriptor
{ 
	TxPd_t pd;
    uint32 parentPd;
} reliableMcastPacketDescriptor_t;



typedef enum {
	UNICAST = 0,
	MULTICAST 
}Mcf_e; 


typedef enum {
	MGMT_FRAME_SUBTYPE_ASSOCIATION_REQ= 0, //0
	MGMT_FRAME_SUBTYPE_ASSOCIATION_RES,// 1
	MGMT_FRAME_SUBTYPE_REASSOCIATION_REQ,// 2
	MGMT_FRAME_SUBTYPE_REASSOCIATION_RES,// 3
	MGMT_FRAME_SUBTYPE_PROBE_REQ,// 4
	MGMT_FRAME_SUBTYPE_PROBE_RES,// 5
	MGMT_FRAME_SUBTYPE_TIMING_ADVERTISEMENT, //6
	MGMT_FRAME_SUBTYPE_RESERVED1,// 6
	MGMT_FRAME_SUBTYPE_BEACON,// 8
	MGMT_FRAME_SUBTYPE_ATIM,// 9
	MGMT_FRAME_SUBTYPE_DISASSOCIATION, // 10
	MGMT_FRAME_SUBTYPE_AUTHENTICATION, // 11
	MGMT_FRAME_SUBTYPE_DEAUTHENTICATION, // 12
	MGMT_FRAME_SUBTYPE_ACTION, //13
	MGMT_FRAME_SUBTYPE_ACTION_NO_ACK, //14
    MGMT_FRAME_SUBTYPE_RESERVED2, //15
    MGMT_FRAME_SUBTYPE_LAST,
	MAX_SUB_TYPE = MAX_UINT8

}SubType_e; 
typedef enum
{
	PD_STATUS_ACK_RECEIVED = 0,
	PD_STATUS_DISCARDED_BY_AGER = 1, /* Do not change this value - HW value */	
	PD_STATUS_BLOCK_ACK_RECEIVED = 2,
	PD_STATUS_NACK = 3,
	PD_STATUS_NUM_OF_TYPES,
	PD_STATUS_MAX_NUM_OF_TYPES = 0xFF,	
} PdStatus_e;


typedef struct PacketDescriptorPool
{
	TxPd_t* volatile pHead;
	uint16 numOfDescInPool;
	uint16 maxDescInPool;
}PacketDescriptorPool_t;


typedef struct PacketDescriptorQueue
{
	TxPd_t* volatile pHead;
	TxPd_t* volatile pTail;
}PacketDescriptorQueue_t;


typedef enum {
	PD_TYPE_DATA = 0,
	PD_TYPE_DATA_RESERVED,
	PD_TYPE_NDP,
	PD_TYPE_ADDBA_REQ,
	PD_TYPE_BAR,
	PD_TYPE_CH_SWITCH_ANN,
	PD_TYPE_MANAGEMENT_UNENC_RESERVED,
	PD_TYPE_MANAGEMENT_ENC_RESERVED,
	PD_TYPE_MU_TRAINING,
	PD_TYPE_MANAGEMENT_UNENC,
	PD_TYPE_MANAGEMENT_UNENC_FRAG,
	PD_TYPE_MANAGEMENT_ENC,
	PD_TYPE_CONTROL_UNENC,
	PD_TYPE_PROBE_RES,
	PD_TYPE_MANAGEMENT_ENC_BIP,
	PD_TYPE_BEACON,
	PD_TYPE_LAST,
	MAX_NUM_PDTYPE = MAX_UINT8
}PdType_e; 


typedef enum {
	PD_BEACON_PROBE_RESP_SUBTYPE_NORMAL = 0,
	PD_BEACON_PROBE_RESP_SUBTYPE_TIM,
	PD_BEACON_PROBE_RESP_SUBTYPE_CSA,
	PD_BEACON_PROBE_RESP_NUM_OF_SUBTYPES,
	PD_BEACON_PROBE_RESP_MAX_NUM_OF_SUBTYPES = 0xFF,
}PdBeaconProbeRespSubType_e; 


typedef enum {
	PD_CONTROL_SUBTYPE_CTS = 0,
	PD_CONTROL_SUBTYPE_TRIGGER_FRAME = 1,
	PD_CONTROL_MAX_NUM_OF_SUBTYPES = 0xFF,
}PdControlSubType_e; 

typedef enum {
	PD_CONTROL_20_MHZ = 0,
	PD_CONTROL_40_MHZ = 1,
	PD_CONTROL_80_MHZ = 2,
	PD_CONTROL_MAX_NUM_OF_BW = 0xFF,
}PdControlBwType_e; 

#define GET_NEXT_PD(pDesc) (PacketDescriptorsPtr + ((pDesc)->nextPdPointer))
#define SET_NEXT_PD(pDesc) (((uint32 *)(pDesc)) - PacketDescriptorsPtr)
#define NULL_PD (PacketDescriptorsPtr + (NEXT_PD_NULL))
#define CONVERT_OFFSET_TO_PD(offset) (PacketDescriptorsPtr + (offset))
#define CONVERT_PD_TO_OFFSET(packetDescriptor) (((uint32 *)(packetDescriptor)) - PacketDescriptorsPtr)


#endif //_PACKET_DESCRIPTOR_H_



