/***********************************************************************************
File:				Rtd.h
Module:				Rtd
Purpose:
Description:		
************************************************************************************/
#ifndef _RTD_H_
#define _RTD_H_

/*---------------------------------------------------------------------------------
/						Includes													 
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h" 
#include "System_GlobalDefinitions.h"
#include "SharedDbTypes.h"

/*---------------------------------------------------------------------------------
/						Defines													 
/----------------------------------------------------------------------------------*/

#define RTD_SECTION_MPDU_SIZE_IN_WORDS	0x7


#define NUMBER_OF_RTDS		(64)

/*---------------------------------------------------------------------------------
/						Data Type Definition													 
/----------------------------------------------------------------------------------*/

typedef struct Rtd_
{
	/* word 0 */
	uint32	lengthCalcNegativeDrop	 				:1;
	uint32	misDataProtFrameDbDrop		 			:1;			
	uint32	filterFrameClassAddr2ValidDrop		 	:1;		
	uint32	filterFrameClassAddr2InvalidDrop		:1;	
	uint32	filterVapStaMismatchDrop				:1;	
	uint32	filterRxqIdDrop							:1;	
	uint32	rdTypeTypeSubtypeDrop					:1;	
	uint32	rxClassifierInfoReserved1				:1;			
	uint32	protFrameNoDbSecValidInd				:1;			
	uint32	rxClassifierInfoReserved2				:2;		
	uint32	securityTailLength						:5; // Not needed			
	uint32	frameSubtype							:4;			
	uint32	frameType								:2;			
	uint32	powerMgmt								:1;
	uint32	moreData								:1;			
	uint32	category								:8;
	/* word 1 */
	uint32	rxhPostDmaAction						:3; //	(Regular = 0 / Drop = 1) RxH use only - Must be zeroed by Rx Classifier
	uint32	eop										:1;			
	uint32	sop										:1;			
	uint32	rxqTid									:3;			
	uint32	rxqStaId								:7;			
	uint32	rxqReserved0							:1;			
	uint32	rxqVapId								:4;			
	uint32	rxqGroupId								:3; //	(STA - 0 / VAP - 2 / GLOBAL - 4 / TEMP - 7)	
	uint32 	broadcast        						:1;
	uint32 	multicast        						:1;	
	uint32	ttlCount								:7;	// Copy of TSF_low [24:18]
	/* word 2 */
	uint32	payloadLength							:14;			
	uint32	toDs									:1;			
	uint32	fromDs									:1;			
	uint32	rxCbPointer								:16;
	/* word 3 */
	uint32	headRd									:16;
	uint32	tailRd									:16;	
	/* word 4 */
	uint32	fragNumber								:4;			
	uint32	sn										:12;			
	uint32	moreFrag								:1;			
	uint32	protected								:1;			
	uint32	retx									:1;			
	uint32	securityWepType							:1;			
	uint32	aggregation								:1;	// is AMSDU or not		
	uint32	txopPsNotAllowed						:1;			
	uint32	reserved2								:4;			
	uint32	headerLength							:6;			
	/* word 5 */
	uint32	rdType									:4;
	uint32	phyMode									:2; //	(AG = 0 / B = 1 / N = 2 / AC = 3)
	uint32	eosp									:1;			
	uint32	reserved3								:5;
	uint32	statusRxClassifierError					:1;			
	uint32	statusRxhError							:1;			
	uint32	statusSecurityError						:1;		
	uint32	statusRxppError							:1;		
	uint32	pn01									:16;		
	/* word 6 */
	uint32	pn25									:32;			
} Rtd_t;

typedef struct RtdQueue_
{
	Rtd_t* volatile 	pHead;
	Rtd_t* volatile 	pTail;
	uint16				numOfRtdsInQueue;
} RtdQueue_t;





#endif //_RTD_H_


