/***********************************************************************************
 File:			RxDescriptor.h
 Module:		Rx Descriptor 
 Purpose: 		
 Description:   This File contains the defintions of the Rx descriptor
************************************************************************************/
#ifndef RX_DESCRIPTOR_H_
#define RX_DESCRIPTOR_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define RD_TKIP_ICV_FAILURE_STATUS_BIT	(0)
#define RD_TKIP_MIC_FAILURE_STATUS_BIT	(1)
#define RD_TKIP_MIC_FAILURE				(0x1 << RD_TKIP_MIC_FAILURE_STATUS_BIT)
#define RD_TKIP_ICV_FAILURE				(0x1 << RD_TKIP_ICV_FAILURE_STATUS_BIT)


#define RD_TX_QID_LINE_NUM				(0)
#define RD_TX_QID_OFFSET				(37) /* offset in 64 bit word */


typedef enum {
	RD_SOURCE_TO_HOST_MEMORY	= 0,
	RD_SOURCE_TO_LOCAL_MEMORY	= 1,
	RD_SOURCE_HW_LOGGER			= 2,
	RD_SOURCE_FORWARD			= 3,
	RD_SOURCE_MANAGEMENT		= 4,
	RD_NUM_OF_SOURCE,
	RD_MAX_NUM_OF_SOURCE		= 0xFF,	
}RxDescriptorSource_e;



typedef enum {
	ETH_TYPE_TYPE_ETH_II      	= 0,
	ETH_TYPE_IPX_LLC_SNAP		= 2,
	ETH_TYPE_EAPOL           	= 3,
	RD_NUM_OF_ETHERNET_TYPE,
	RD_MAX_NUM_OF_ETHERNET_TYPE	= 0xFF,	
}RxDescriptorEthernetType_e;

typedef enum
{
	RD_TYPE_UNICAST_QOS_DATA               	= 0,
	RD_TYPE_NDP                            	= 1,
	RD_TYPE_MULTICAST_DATA                 	= 2,
	RD_TYPE_UNICAST_NON_QOS_DATA           	= 3,
	RD_TYPE_CONTROL                       	= 4,
	RD_TYPE_NOT_SUPPORTED                  	= 5,
	RD_TYPE_UNICAST_MGMT_TYPE_1      		= 6,
	RD_TYPE_UNICAST_MGMT_TYPE_2      		= 7,
	RD_TYPE_MULTICAST_MGMT           		= 8,
	RD_TYPE_DROP                           	= 9,
	RD_TYPE_NON_ASSOCIATED_MGMT_TYPE_1     	= 10,
	RD_TYPE_LOGGER                     	  	= 11,
	RD_TYPE_NON_ASSOCIATED_MGMT_TYPE_2 		= 12,
	RD_TYPE_MAGIC_PACKET                   	= 13,
	RD_TYPE_SNIFFER		                  	= 14 ,
	RD_TYPE_RSSI	                     	= 15,
	RD_TYPE_LAST,
	RD_MAX_NUM_OF_TYPES                    	= 0xFF,	
} RxDescriptorType_e;

typedef enum
{
	RXH_ERROR_MSDU_LENGTH_UNDER_MINIMUM				= 0,
	RXH_ERROR_MSDU_LENGTH_OVER_MAXIMUM				= 1,
	RXH_ERROR_MSDU_LENGTH_OVER_REMAINING_PAYLOAD	= 2,
	RXH_ERROR_MSDU_HEADER_CONVERSION_FAILED			= 3,
	RXH_ERROR_MPDU_LENGTH_UNDER_MINIMUM				= 4,
	RXH_ERROR_MPDU_LENGTH_OVER_MAXIMUM				= 5,
	RXH_ERROR_MPDU_HEADER_CONVERSION_FAILED			= 6
} RxhErrorCause_e;

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------
#define GET_NEXT_RD(rxDescriptor) 			(PacketDescriptorsPtr + (rxDescriptor->nextRd))//TBD  CHECK what is the base address for RDs
#define SET_NEXT_RD(rxDescriptor) 			(((uint32*)rxDescriptor) - PacketDescriptorsPtr)//TBD  CHECK what is the base address for RDs
#define NULL_RD 							(PacketDescriptorsPtr + (NEXT_RD_NULL))//TBD  CHECK what is the base address for RDs
#define CONVERT_OFFSET_TO_RD(offset) 		(PacketDescriptorsPtr + offset)//TBD  CHECK what is the base address for RDs
#define CONVERT_RD_TO_OFFSET(rxDescriptor) (((uint32 *)(rxDescriptor)) - PacketDescriptorsPtr)

#define CONVERT_DRAM_POINTER_TO_BYTE_ADDRESS(dramPointer)	(dramPointer)	// dram pointer is already byte address in gen5b	
#define CONVERT_BYTE_ADDRESS_TO_DRAM_POINTER(address)		(address)		// dram pointer is already byte address in gen5b	
#define CONVERT_RD_OFFSET_TO_HD_OFFSET(offset)				(offset)		// the offset in gen5b is 3 bits as in the HD
#define GET_BIT4_IN_RD_OFFSET(offset)						(0)				// there is no 4 bit in the offset in gen5b 



//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct _RdCommon_t
{
	/* word 0 */
	uint32 dataLength      :14;
	uint32 ethType         :2;
	uint32 frameSubtype    :4;
	uint32 frameType       :2;
	uint32 powerManagement :1;
	uint32 moreData        :1;
	uint32 category        :8;
   	/* word 1 */
	uint32 dramByteOffset   :3;
	uint32 eop              :1;
	uint32 sop              :1;
	uint32 rxQueueTid       :3;
	uint32 rxQueueStaId :8;
	uint32 rxQueueVapId     :4;
	uint32 rxQueueGroupId   :3;
	uint32 broadcast        :1;
	uint32 multicast        :1;
	uint32 ttlCount         :7;
	/* word 2 */
	uint32 dramPointer;
	/* word 3 */
	uint32 nextRd:16;					 
	uint32 tailRd:16;					/* Valid in 1st RD Only and when Aggregation field is set */	  
	/* word 4 */
	uint32 fragNumber       :4;
	uint32 sequenceNumber   :12;
	uint32 moreFrag         :1;
	uint32 protected        :1;
	uint32 reTx             :1;
	uint32 securityWepType  :1;
	uint32 amsduAgg      	:1;
	uint32 txopPsNotAllowed :1;
	uint32 securityStatus   :7;
	uint32 rdSource         :3;
	/* word 5 */
	uint32 rdType                  :4;
	uint32 phyMode                 :2;
	uint32 eosp                    :1;
	uint32 rxhErrorCause           :3;
    uint32 keyId	               :2; 
	uint32 statusRxClassifierError :1;
	uint32 statusRxhError          :1;
	uint32 statusSecurityError     :1;
	uint32 statusRxppError         :1;
	uint32 pn0_1:16;					/* Valid in 1st RD Only */
	/* Rd Word 6 */	
	uint32 pn2_5:32;					/* Valid in 1st RD Only */
	/* word 7 */
	uint32 rdCount                 :10;
	uint32 reserved3               :6;
	uint32 bdIndex                 :16;
} RdCommon_t;
	
typedef RdCommon_t Rd_t;

typedef struct rxDescriptorQueue
{
	Rd_t *volatile pHead;
	Rd_t *volatile pTail;
}rxDescriptorQueue_t;


#endif /* RX_DESCRIPTOR_H_ */

