/***********************************************************************************
 File:			RxMpduStructure.h
 Module:		Rx MPDU structure 
 Purpose: 		
 Description:   This File contains the defintions of the Rx MPDU structure
************************************************************************************/
#ifndef RX_MPDU_STRUCTURE_H_
#define RX_MPDU_STRUCTURE_H_
//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"
#include "RxHandler_InitApi.h"
#include "mhi_ieee_address.h"
//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------
#define RX_MPDU_PHY_METRICS_INVALID_STA_INDEX 0x1FF


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct _RX_MPDU_PHY_METRICS
{
/* two words are reserved for Genrisc */
   uint32 geriscSpare1 ;
   uint32 geriscSpare2 ; //used only for GEN4/GEN5B length of aggrageted packet in RSSI mode

/* Phy metrics 0 first word */   
   uint32 length:16;
   uint32 subFrameNum:6;
   uint32 aggregateNum:2;
   uint32 aggregate:1;
   uint32 lastOfAggregate:1;
   uint32 multicastInd:1;
   uint32 broadcastInd:1;
   uint32 reserved1:4;
   
/* Phy metrics 0 second word */
   uint32 stationIndex:9;
   uint32 bssIndex:5;
   uint32 phyMode:2;
   uint32 rate:6;
   uint32 CBW:2;
   uint32 SCP:1;
   uint32 LDPC:1;
   uint32 STBC:1;
   uint32 sounding:1;
   uint32 smoothing:1;
   uint32 scrambleInit:3;

/* Phy metrics 1-two words */
   uint32 noise;
   uint32 RFGain;
   
/* Phy metrics 2-two words */
   uint32 RSSI;
	
   uint32 groupId :6;
   uint32 partialAid :9;
   uint32 txopPsNotAllowed :1;
   uint32 phyRate :15;
   uint32 ndp :1;

} RX_MPDU_PHY_METRICS;


typedef struct udpPacketHdr
{
	//0-2
	IEEE_ADDR macAddrDest; 
	IEEE_ADDR macAddrSrc; 
	
 	// 3
	uint32 type          :16;
	uint32 version       :4;
	uint32 ihl           :4;
	uint32 typeOfService :8;

	// 4
	uint32 totalLength	 :16;
	uint32 Id            :16;
	
	 //5
	uint32 flags         :3;
	uint32 fragOffset    :13;	
	uint32 ttl            :8;
	uint32 protocol       :8;

	 //6
	uint32 headerCheckSum :16;
	uint32 srcIpLsb       :16;

	
	// 7
	uint32 srcIpMsb       :16;
	uint32 dstIpLsb       :16;

	//8
	uint32 dstIpMsb		 :16;
	uint32 srcUdpPort    :16;
	//9
	uint32 dstUdp        :16;		
	uint32 udpLength     :16;

	//10
	uint32 udpChecksum   :16;
	uint32 padding      :16;
} udpPacketHdr_t;


typedef struct RxMpdu
{    
	uint32 tsf;
	uint32 reservedArea[FRAME_PREFIX_RESERVED_LENGTH_IN_WORDS];
	RX_MPDU_PHY_METRICS rxPhyMetrics;
	uint32 frame[];
} RxMpdu_t;


typedef struct RxSnifferMpdu
{    
	uint32 tsf;
	uint32 reservedArea[FRAME_PREFIX_SNIFFER_RESERVED_LENGTH_IN_WORDS];
	RX_MPDU_PHY_METRICS rxPhyMetrics;
	uint32 frame[];
} RxSnifferMpdu_t;


#endif /* RX_MPDU_STRUCTURE_H_ */

