/***********************************************************************************
File:				StaDb.h
Module:				StaDb
Purpose:
Description:		This File was auto generated using Descriptor Excel Parser
************************************************************************************/
#ifndef _STA_DB_H_
#define _STA_DB_H_
/*---------------------------------------------------------------------------------
/						Includes													 
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h" 
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "SharedDbTypes.h"
#include "Tcr_Descriptors.h"

/*---------------------------------------------------------------------------------
/						Defines													 
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Data Type Definition													 
/----------------------------------------------------------------------------------*/


typedef struct _StaDbCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 maxMpduLengthLimit	  : 14; //bits [0..13]
			uint32 bfReportResponseFormat : 2;	//bits [14..15], values from BfReportRxIndication_e
			uint32 qosEnableCapability	  : 1;	//bit [16]
			uint32 negotiatedWds		  : 1;	//bit [17]
			uint32 dataBwLimit			  : 2;	//bits [18..19]
			uint32 _80211BwLimit		  : 2;	//bits [20..21]
			uint32 dynamicBwEnable		  : 1;	//bit [22]
			uint32 staticBwEnable		  : 1;	//bit [23]
			uint32 maxMsduAtAmsduCount	  : 8;	//bits [24..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 aMpduLimit			: 6;  //bits [0..5]
			uint32 reserved0			: 4;  //bits [6..9]
			uint32 staPhyCapabilities	: 2;  //bits [10..11], values from PhyModeOld_e
			uint32 noAggInPs			: 1;  //bit [12]
			uint32 psForceOneNss		: 1;  //bit [13]
			uint32 sppAmsduCapable		: 1;  //bit [14]
			uint32 maxSpLength			: 7;  //bits [15..21]
			uint32 txPostpone			: 2;  //bits [22..23], values from FillerType_e
			uint32 wdsClientType		: 1;  //bit [24]
			uint32 currentPacketDensity : 3;  //bits [25..27]
			uint32 rtsCtsTxMethod		: 2;  //bits [28..29], values from RtsCtsTxMethod_e
			uint32 ctsToSelfTxMethod	: 2;  //bits [30..31], values from CtsToSelfTxMethod_e
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 maxPsduLengthLimit	  : 20; //bits [0..19]
			uint32 dataEncryptionType	  : 3;	//bits [20..22], values from SecurityType_e
			uint32 _80211EncryptionType   : 3;	//bits [23..25], values from SecurityType_e
			uint32 dataEncryptionEnable   : 1;	//bit [26]
			uint32 _80211EncryptionEnable : 1;	//bit [27]
			uint32 dataKeyId			  : 2;	//bits [28..29]
			uint32 _80211KeyId			  : 2;	//bits [30..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 bfRxHwFwMode 						: 1;  //bit [0]
			uint32 bfRxMode 							: 3;  //bits [1..3]
			uint32 bfMinimalGrouping					: 2;  //bits [4..5]
			uint32 maxNssNdp							: 2;  //bits [6..7] Maximum number of Spatial Streams STA can estimate (Determine the Nss of transmitted NDP).  */
			uint32 maxNssTx 							: 2;  //bits [8..9] Tx Maximum number of Spatial Streams supported by STA (should be sampled during NDPA and passed to PHY. Used by effective SNR module. Also used for nonstandard implicit rule).
			uint32 bfMfbUpdating						: 1;  //bit [10]
			uint32 bfAgingRegisterIndex 				: 2;  //bits [11..12]
			uint32 nonStandardImplicitBfRulesTableIndex : 2;  //bits [13..14]
			uint32 bfImplicitFiller 					: 1;  //bit [15]
			uint32 bfDbValid							: 1;  //bit [16]
			uint32 bfAgingStatus						: 1;  //bit [17]
			uint32 bfHwReserved 						: 4;  //bits [19..22]
			uint32 mcsFeedback							: 7;  //bits [24..30]
			uint32 mfbValid 							: 1;  //bit [31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 tcr020MhzData : 24; //bits [0..23]
			uint32				 : 8;
		};
		struct
		{
			uint32 tcr020MhzPhyModeData : 2;  //bits [0..1], values from PhyModeOld_e
			uint32						: 30;
		};
		struct
		{
			uint32				   : 2;
			uint32 tcr020MhzBwData : 2;  //bits [2..3], values from Bw_20Mhz_e
			uint32				   : 28;
		};
		struct
		{
			uint32						: 4;
			uint32 tcr020MhzRfPowerData : 6;  //bits [4..9]
			uint32						: 22;
		};
		struct
		{
			uint32					   : 10;
			uint32 tcr020MhzBfModeData : 2;  //bits [10..11], values from BfMode_e
			uint32					   : 20;
		};
		struct
		{
			uint32								 : 12;
			uint32 tcr020MhzAntennaSelectionData : 8;  //bits [12..19]
			uint32								 : 12;
		};
		struct
		{
			uint32						 : 20;
			uint32 tcr020MhzGenrisc0Data : 4;  //bits [20..23]
			uint32						 : 8;
		};
		struct
		{
			uint32					   : 24;
			uint32 _20MhzWpRfPowerData : 6;  //bits [24..29]
			uint32					   : 2;
		}; //Valid only in Data
		struct
		{
			uint32					   : 30;
			uint32 _20MhzWpPhyModeData : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in Data
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 tcr320MhzData : 24; //bits [0..23]
			uint32				 : 8;
		};
		struct
		{
			uint32 tcr320MhzAggregateData : 1;	//bit [0]
			uint32						  : 31;
		};
		struct
		{
			uint32							: 1;
			uint32 tcr320MhzNotSoundingData : 1;  //bit [1]
			uint32							: 30;
		};
		struct
		{
			uint32							: 2;
			uint32 tcr320MhzBfSmoothingData : 1;  //bit [2]
			uint32							: 29;
		};
		struct
		{
			uint32						  : 3;
			uint32 tcr320MhzDynamicBwData : 1;	//bit [3]
			uint32						  : 28;
		};
		struct
		{
			uint32						  : 4;
			uint32 tcr320MhzReserved0Data : 4;	//bits [4..7]
			uint32						  : 24;
		};
		struct
		{
			uint32					 : 8;
			uint32 tcr320MhzRateData : 6;  //bits [8..13]
			uint32					 : 18;
		};
		struct
		{
			uint32						  : 14;
			uint32 tcr320MhzReserved1Data : 2;	//bits [14..15]
			uint32						  : 16;
		};
		struct
		{
			uint32					: 16;
			uint32 tcr320MhzScpData : 1;  //bit [16]
			uint32					: 15;
		};
		struct
		{
			uint32				   : 17;
			uint32 ant0WpReserved0 : 4;  //bits [17..20]
			uint32				   : 11;
		};
		struct
		{
			uint32					   : 21;
			uint32 ant0WpAnt0Selection : 2;  //bits [21..22]
			uint32					   : 9;
		};
		struct
		{
			uint32				   : 23;
			uint32 ant0WpReserved1 : 1;  //bit [23]
			uint32				   : 8;
		};
		struct
		{
			uint32					: 24;
			uint32 _20MhzWpRateData : 7;  //bits [24..30]
			uint32					: 1;
		}; //Valid only in Data
		struct
		{
			uint32				   : 31;
			uint32 _20MhzWpScpData : 1;  //bit [31]
		}; //Valid only in Data
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 tcr040MhzData : 24; //bits [0..23]
			uint32				 : 8;
		};
		struct
		{
			uint32 tcr040MhzPhyModeData : 2;  //bits [0..1], values from PhyModeOld_e
			uint32						: 30;
		};
		struct
		{
			uint32				   : 2;
			uint32 tcr040MhzBwData : 2;  //bits [2..3], values from Bw_40Mhz_e
			uint32				   : 28;
		};
		struct
		{
			uint32						: 4;
			uint32 tcr040MhzRfPowerData : 6;  //bits [4..9]
			uint32						: 22;
		};
		struct
		{
			uint32					   : 10;
			uint32 tcr040MhzBfModeData : 2;  //bits [10..11], values from BfMode_e
			uint32					   : 20;
		};
		struct
		{
			uint32								 : 12;
			uint32 tcr040MhzAntennaSelectionData : 8;  //bits [12..19]
			uint32								 : 12;
		};
		struct
		{
			uint32						 : 20;
			uint32 tcr040MhzGenrisc0Data : 4;  //bits [20..23]
			uint32						 : 8;
		};
		struct
		{
			uint32					   : 24;
			uint32 _40MhzWpRfPowerData : 6;  //bits [24..29]
			uint32					   : 2;
		}; //Valid only in Data
		struct
		{
			uint32					   : 30;
			uint32 _40MhzWpPhyModeData : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in Data
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 tcr340MhzData : 24; //bits [0..23]
			uint32				 : 8;
		};
		struct
		{
			uint32 tcr340MhzAggregateData : 1;	//bit [0]
			uint32						  : 31;
		};
		struct
		{
			uint32							: 1;
			uint32 tcr340MhzNotSoundingData : 1;  //bit [1]
			uint32							: 30;
		};
		struct
		{
			uint32							: 2;
			uint32 tcr340MhzBfSmoothingData : 1;  //bit [2]
			uint32							: 29;
		};
		struct
		{
			uint32						  : 3;
			uint32 tcr340MhzDynamicBwData : 1;	//bit [3]
			uint32						  : 28;
		}; //"0" means unlimited
		struct
		{
			uint32						  : 4;
			uint32 tcr340MhzReserved0Data : 4;	//bits [4..7]
			uint32						  : 24;
		};
		struct
		{
			uint32					 : 8;
			uint32 tcr340MhzRateData : 6;  //bits [8..13]
			uint32					 : 18;
		}; //"0" means 64
		struct
		{
			uint32						  : 14;
			uint32 tcr340MhzReserved1Data : 2;	//bits [14..15]
			uint32						  : 16;
		};
		struct
		{
			uint32					: 16;
			uint32 tcr340MhzScpData : 1;  //bit [16]
			uint32					: 15;
		};
		struct
		{
			uint32				 : 17;
			uint32 ant1WpAnt1Cdd : 4;  //bits [17..20]
			uint32				 : 11;
		};
		struct
		{
			uint32					   : 21;
			uint32 ant1WpAnt1Selection : 2;  //bits [21..22]
			uint32					   : 9;
		};
		struct
		{
			uint32				   : 23;
			uint32 ant1WpReserved0 : 1;  //bit [23]
			uint32				   : 8;
		};
		struct
		{
			uint32					: 24;
			uint32 _40MhzWpRateData : 7;  //bits [24..30]
			uint32					: 1;
		}; //Valid only in Data
		struct
		{
			uint32				   : 31;
			uint32 _40MhzWpScpData : 1;  //bit [31]
		}; //Valid only in Data
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 tcr080MhzData : 24; //bits [0..23]
			uint32				 : 8;
		};
		struct
		{
			uint32 tcr080MhzPhyModeData : 2;  //bits [0..1], values from PhyModeOld_e
			uint32						: 30;
		};
		struct
		{
			uint32				   : 2;
			uint32 tcr080MhzBwData : 2;  //bits [2..3], values from Bw_80Mhz_e
			uint32				   : 28;
		};
		struct
		{
			uint32						: 4;
			uint32 tcr080MhzRfPowerData : 6;  //bits [4..9]
			uint32						: 22;
		};
		struct
		{
			uint32					   : 10;
			uint32 tcr080MhzBfModeData : 2;  //bits [10..11], values from BfMode_e
			uint32					   : 20;
		};
		struct
		{
			uint32								 : 12;
			uint32 tcr080MhzAntennaSelectionData : 8;  //bits [12..19]
			uint32								 : 12;
		};
		struct
		{
			uint32						 : 20;
			uint32 tcr080MhzGenrisc0Data : 4;  //bits [20..23]
			uint32						 : 8;
		};
		struct
		{
			uint32					   : 24;
			uint32 _80MhzWpRfPowerData : 6;  //bits [24..29]
			uint32					   : 2;
		}; //Valid only in Data
		struct
		{
			uint32					   : 30;
			uint32 _80MhzWpPhyModeData : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in Data
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 tcr380MhzData : 24; //bits [0..23]
			uint32				 : 8;
		};
		struct
		{
			uint32 tcr380MhzAggregateData : 1;	//bit [0]
			uint32						  : 31;
		};
		struct
		{
			uint32							: 1;
			uint32 tcr380MhzNotSoundingData : 1;  //bit [1]
			uint32							: 30;
		};
		struct
		{
			uint32							: 2;
			uint32 tcr380MhzBfSmoothingData : 1;  //bit [2]
			uint32							: 29;
		};
		struct
		{
			uint32						  : 3;
			uint32 tcr380MhzDynamicBwData : 1;	//bit [3]
			uint32						  : 28;
		};
		struct
		{
			uint32						  : 4;
			uint32 tcr380MhzReserved0Data : 4;	//bits [4..7]
			uint32						  : 24;
		};
		struct
		{
			uint32					 : 8;
			uint32 tcr380MhzRateData : 6;  //bits [8..13]
			uint32					 : 18;
		};
		struct
		{
			uint32						  : 14;
			uint32 tcr380MhzReserved1Data : 2;	//bits [14..15]
			uint32						  : 16;
		};
		struct
		{
			uint32					: 16;
			uint32 tcr380MhzScpData : 1;  //bit [16]
			uint32					: 15;
		};
		struct
		{
			uint32				 : 17;
			uint32 ant2WpAnt2Cdd : 4;  //bits [17..20]
			uint32				 : 11;
		};
		struct
		{
			uint32					   : 21;
			uint32 ant2WpAnt2Selection : 2;  //bits [21..22]
			uint32					   : 9;
		};
		struct
		{
			uint32				   : 23;
			uint32 ant2WpReserved0 : 1;  //bit [23]
			uint32				   : 8;
		};
		struct
		{
			uint32					: 24;
			uint32 _80MhzWpRateData : 7;  //bits [24..30]
			uint32					: 1;
		}; //Valid only in Data
		struct
		{
			uint32				   : 31;
			uint32 _80MhzWpScpData : 1;  //bit [31]
		}; //Valid only in Data
	};
	union //word10
	{
		uint32 word10;
		struct
		{
			uint32 tcr1Data : 24; //bits [0..23]
			uint32			: 8;
		};
		struct
		{
			uint32 ldpcData : 1;  //bit [0]
			uint32			: 31;
		};
		struct
		{
			uint32			: 1;
			uint32 stbcData : 2;  //bits [1..2]
			uint32			: 29;
		};
		struct
		{
			uint32				  : 3;
			uint32 partialAidData : 9;	//bits [3..11]
			uint32				  : 20;
		};
		struct
		{
			uint32						: 12;
			uint32 txopPsNotAllowedData : 1;  //bit [12]
			uint32						: 19;
		};
		struct
		{
			uint32			   : 13;
			uint32 groupIdData : 6;  //bits [13..18]
			uint32			   : 13;
		};
		struct
		{
			uint32					 : 19;
			uint32 tcr1DataReserved0 : 2;  //bits [19..20]
			uint32					 : 11;
		};
		struct
		{
			uint32						   : 21;
			uint32 tcr1NdpTrainingModeData : 1;  //bit [21]
			uint32						   : 10;
		};
		struct
		{
			uint32					  : 22;
			uint32 tcr1MuTrainingData : 1;	//bit [22]
			uint32					  : 9;
		};
		struct
		{
			uint32					: 23;
			uint32 tcr1MuPhyNdpData : 1;  //bit [23]
			uint32					: 8;
		};
		struct
		{
			uint32								  : 24;
			uint32 baaWeightedSuccessMduReference : 8;	//bits [24..31]
		};
	};
	union //word11
	{
		uint32 word11;
		struct
		{
			uint32 tcr2 : 24; //bits [0..23]
			uint32		: 8;
		};
		struct
		{
			uint32 cddAnt1 : 4;  //bits [0..3]
			uint32		   : 28;
		};
		struct
		{
			uint32		   : 4;
			uint32 cddAnt2 : 4;  //bits [4..7]
			uint32		   : 24;
		};
		struct
		{
			uint32		   : 8;
			uint32 cddAnt3 : 4;  //bits [8..11]
			uint32		   : 20;
		};
		struct
		{
			uint32				: 12;
			uint32 tcr2BwChange : 1;  //bit [12]
			uint32				: 19;
		};
		struct
		{
			uint32				 : 13;
			uint32 tcr2Ant0Boost : 2;  //bits [13..14]
			uint32				 : 17;
		};
		struct
		{
			uint32				 : 15;
			uint32 tcr2Ant1Boost : 2;  //bits [15..16]
			uint32				 : 15;
		};
		struct
		{
			uint32				 : 17;
			uint32 tcr2Ant2Boost : 2;  //bits [17..18]
			uint32				 : 13;
		};
		struct
		{
			uint32				 : 19;
			uint32 tcr2Ant3Boost : 2;  //bits [19..20]
			uint32				 : 11;
		};
		struct
		{
			uint32			: 21;
			uint32 genrisc1 : 3;  //bits [21..23]
			uint32			: 8;
		};
		struct
		{
			uint32							   : 24;
			uint32 baaWeightedFailMduReference : 8;  //bits [24..31]
		};
	};
	union //word12
	{
		uint32 word12;
		struct
		{
			uint32 tcr180211 : 24; //bits [0..23]
			uint32			 : 8;
		};
		struct
		{
			uint32 ldpc80211 : 1;  //bit [0]
			uint32			 : 31;
		};
		struct
		{
			uint32			 : 1;
			uint32 stbc80211 : 2;  //bits [1..2]
			uint32			 : 29;
		};
		struct
		{
			uint32				   : 3;
			uint32 partialAid80211 : 9;  //bits [3..11]
			uint32				   : 20;
		};
		struct
		{
			uint32						 : 12;
			uint32 txopPsNotAllowed80211 : 1;  //bit [12]
			uint32						 : 19;
		};
		struct
		{
			uint32				: 13;
			uint32 groupId80211 : 6;  //bits [13..18]
			uint32				: 13;
		};
		struct
		{
			uint32					  : 19;
			uint32 tcr180211Reserved0 : 2;	//bits [19..20]
			uint32					  : 11;
		};
		struct
		{
			uint32							: 21;
			uint32 tcr1NdpTrainingMode80211 : 1;  //bit [21]
			uint32							: 10;
		};
		struct
		{
			uint32					   : 22;
			uint32 tcr1MuTraining80211 : 1;  //bit [22]
			uint32					   : 9;
		};
		struct
		{
			uint32					 : 23;
			uint32 tcr1MuPhyNdp80211 : 1;  //bit [23]
			uint32					 : 8;
		};
		struct
		{
			uint32							: 24;
			uint32 altRateReasonFastProbing : 1;  //bit [24]
			uint32							: 7;
		};
		struct
		{
			uint32							: 25;
			uint32 altRateReasonSlowProbing : 1;  //bit [25]
			uint32							: 6;
		};
		struct
		{
			uint32								   : 26;
			uint32 altRateReasonBfReportFastUpdate : 1;  //bit [26]
			uint32								   : 5;
		};
		struct
		{
			uint32							  : 27;
			uint32 probingIndicationReserved0 : 5;	//bits [27..31]
		};
	};
	union //word13
	{
		uint32 word13;
		struct
		{
			uint32 tcr020Mhz80211 : 24; //bits [0..23]
			uint32				  : 8;
		};
		struct
		{
			uint32 tcr020MhzPhyMode80211 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32						 : 30;
		};
		struct
		{
			uint32					: 2;
			uint32 tcr020MhzBw80211 : 2;  //bits [2..3], values from Bw_20Mhz_e
			uint32					: 28;
		};
		struct
		{
			uint32						 : 4;
			uint32 tcr020MhzRfPower80211 : 6;  //bits [4..9]
			uint32						 : 22;
		};
		struct
		{
			uint32						: 10;
			uint32 tcr020MhzBfMode80211 : 2;  //bits [10..11], values from BfMode_e
			uint32						: 20;
		};
		struct
		{
			uint32								  : 12;
			uint32 tcr020MhzAntennaSelection80211 : 8;	//bits [12..19]
			uint32								  : 12;
		};
		struct
		{
			uint32						  : 20;
			uint32 tcr020MhzGenrisc080211 : 4;	//bits [20..23]
			uint32						  : 8;
		};
		struct
		{
			uint32						: 24;
			uint32 _20MhzWpRfPower80211 : 6;  //bits [24..29]
			uint32						: 2;
		}; //Valid only in 802.11
		struct
		{
			uint32						: 30;
			uint32 _20MhzWpPhyMode80211 : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in 802.11
	};
	union //word14
	{
		uint32 word14;
		struct
		{
			uint32 tcr320Mhz80211 : 24; //bits [0..23]
			uint32				  : 8;
		};
		struct
		{
			uint32 tcr320MhzAggregate80211 : 1;  //bit [0]
			uint32						   : 31;
		};
		struct
		{
			uint32							 : 1;
			uint32 tcr320MhzNotSounding80211 : 1;  //bit [1]
			uint32							 : 30;
		};
		struct
		{
			uint32							 : 2;
			uint32 tcr320MhzBfSmoothing80211 : 1;  //bit [2]
			uint32							 : 29;
		};
		struct
		{
			uint32						   : 3;
			uint32 tcr320MhzDynamicBw80211 : 1;  //bit [3]
			uint32						   : 28;
		};
		struct
		{
			uint32						   : 4;
			uint32 tcr320MhzReserved080211 : 4;  //bits [4..7]
			uint32						   : 24;
		};
		struct
		{
			uint32					  : 8;
			uint32 tcr320MhzRate80211 : 6;	//bits [8..13]
			uint32					  : 18;
		};
		struct
		{
			uint32						   : 14;
			uint32 tcr320MhzReserved180211 : 2;  //bits [14..15]
			uint32						   : 16;
		};
		struct
		{
			uint32					 : 16;
			uint32 tcr320MhzScp80211 : 1;  //bit [16]
			uint32					 : 15;
		};
		struct
		{
			uint32				 : 17;
			uint32 ant3WpAnt3Cdd : 4;  //bits [17..20]
			uint32				 : 11;
		};
		struct
		{
			uint32					   : 21;
			uint32 ant3WpAnt3Selection : 2;  //bits [21..22]
			uint32					   : 9;
		};
		struct
		{
			uint32				   : 23;
			uint32 ant3WpReserved0 : 1;  //bit [23]
			uint32				   : 8;
		};
		struct
		{
			uint32					 : 24;
			uint32 _20MhzWpRate80211 : 7;  //bits [24..30]
			uint32					 : 1;
		}; //Valid only in 802.11
		struct
		{
			uint32					: 31;
			uint32 _20MhzWpScp80211 : 1;  //bit [31]
		}; //Valid only in 802.11
	};
	union //word15
	{
		uint32 word15;
		struct
		{
			uint32 tcr040Mhz80211 : 24; //bits [0..23]
			uint32				  : 8;
		};
		struct
		{
			uint32 tcr040MhzPhyMode80211 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32						 : 30;
		};
		struct
		{
			uint32					: 2;
			uint32 tcr040MhzBw80211 : 2;  //bits [2..3], values from Bw_40Mhz_e
			uint32					: 28;
		};
		struct
		{
			uint32						 : 4;
			uint32 tcr040MhzRfPower80211 : 6;  //bits [4..9]
			uint32						 : 22;
		};
		struct
		{
			uint32						: 10;
			uint32 tcr040MhzBfMode80211 : 2;  //bits [10..11], values from BfMode_e
			uint32						: 20;
		};
		struct
		{
			uint32								  : 12;
			uint32 tcr040MhzAntennaSelection80211 : 8;	//bits [12..19]
			uint32								  : 12;
		};
		struct
		{
			uint32						  : 20;
			uint32 tcr040MhzGenrisc080211 : 4;	//bits [20..23]
			uint32						  : 8;
		};
		struct
		{
			uint32						: 24;
			uint32 _40MhzWpRfPower80211 : 6;  //bits [24..29]
			uint32						: 2;
		}; //Valid only in 802.11
		struct
		{
			uint32						: 30;
			uint32 _40MhzWpPhyMode80211 : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in 802.11
	};
	union //word16
	{
		uint32 word16;
		struct
		{
			uint32 tcr340Mhz80211 : 24; //bits [0..23]
			uint32				  : 8;
		};
		struct
		{
			uint32 tcr340MhzAggregate80211 : 1;  //bit [0]
			uint32						   : 31;
		};
		struct
		{
			uint32							 : 1;
			uint32 tcr340MhzNotSounding80211 : 1;  //bit [1]
			uint32							 : 30;
		};
		struct
		{
			uint32							 : 2;
			uint32 tcr340MhzBfSmoothing80211 : 1;  //bit [2]
			uint32							 : 29;
		};
		struct
		{
			uint32						   : 3;
			uint32 tcr340MhzDynamicBw80211 : 1;  //bit [3]
			uint32						   : 28;
		};
		struct
		{
			uint32						   : 4;
			uint32 tcr340MhzReserved080211 : 4;  //bits [4..7]
			uint32						   : 24;
		};
		struct
		{
			uint32					  : 8;
			uint32 tcr340MhzRate80211 : 6;	//bits [8..13]
			uint32					  : 18;
		};
		struct
		{
			uint32						   : 14;
			uint32 tcr340MhzReserved180211 : 2;  //bits [14..15]
			uint32						   : 16;
		};
		struct
		{
			uint32					 : 16;
			uint32 tcr340MhzScp80211 : 1;  //bit [16]
			uint32					 : 15;
		};
		struct
		{
			uint32						   : 17;
			uint32 tcr340MhzReserved280211 : 7;  //bits [17..23]
			uint32						   : 8;
		};
		struct
		{
			uint32					 : 24;
			uint32 _40MhzWpRate80211 : 7;  //bits [24..30]
			uint32					 : 1;
		}; //Valid only in 802.11
		struct
		{
			uint32					: 31;
			uint32 _40MhzWpScp80211 : 1;  //bit [31]
		}; //Valid only in 802.11
	};
	union //word17
	{
		uint32 word17;
		struct
		{
			uint32 tcr080Mhz80211 : 24; //bits [0..23]
			uint32				  : 8;
		};
		struct
		{
			uint32 tcr080MhzPhyMode80211 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32						 : 30;
		};
		struct
		{
			uint32					: 2;
			uint32 tcr080MhzBw80211 : 2;  //bits [2..3], values from Bw_80Mhz_e
			uint32					: 28;
		};
		struct
		{
			uint32						 : 4;
			uint32 tcr080MhzRfPower80211 : 6;  //bits [4..9]
			uint32						 : 22;
		};
		struct
		{
			uint32						: 10;
			uint32 tcr080MhzBfMode80211 : 2;  //bits [10..11], values from BfMode_e
			uint32						: 20;
		};
		struct
		{
			uint32								  : 12;
			uint32 tcr080MhzAntennaSelection80211 : 8;	//bits [12..19]
			uint32								  : 12;
		};
		struct
		{
			uint32						  : 20;
			uint32 tcr080MhzGenrisc080211 : 4;	//bits [20..23]
			uint32						  : 8;
		};
		struct
		{
			uint32						: 24;
			uint32 _80MhzWpRfPower80211 : 6;  //bits [24..29]
			uint32						: 2;
		}; //Valid only in 802.11
		struct
		{
			uint32						: 30;
			uint32 _80MhzWpPhyMode80211 : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in 802.11
	};
	union //word18
	{
		uint32 word18;
		struct
		{
			uint32 tcr380Mhz80211 : 24; //bits [0..23]
			uint32				  : 8;
		};
		struct
		{
			uint32 tcr380MhzAggregate80211 : 1;  //bit [0]
			uint32						   : 31;
		};
		struct
		{
			uint32							 : 1;
			uint32 tcr380MhzNotSounding80211 : 1;  //bit [1]
			uint32							 : 30;
		};
		struct
		{
			uint32							 : 2;
			uint32 tcr380MhzBfSmoothing80211 : 1;  //bit [2]
			uint32							 : 29;
		};
		struct
		{
			uint32						   : 3;
			uint32 tcr380MhzDynamicBw80211 : 1;  //bit [3]
			uint32						   : 28;
		};
		struct
		{
			uint32						   : 4;
			uint32 tcr380MhzReserved080211 : 4;  //bits [4..7]
			uint32						   : 24;
		};
		struct
		{
			uint32					  : 8;
			uint32 tcr380MhzRate80211 : 6;	//bits [8..13]
			uint32					  : 18;
		};
		struct
		{
			uint32						   : 14;
			uint32 tcr380MhzReserved180211 : 2;  //bits [14..15]
			uint32						   : 16;
		};
		struct
		{
			uint32					 : 16;
			uint32 tcr380MhzScp80211 : 1;  //bit [16]
			uint32					 : 15;
		};
		struct
		{
			uint32						   : 17;
			uint32 tcr380MhzReserved280211 : 7;  //bits [17..23]
			uint32						   : 8;
		};
		struct
		{
			uint32					 : 24;
			uint32 _80MhzWpRate80211 : 7;  //bits [24..30]
			uint32					 : 1;
		}; //Valid only in 802.11
		struct
		{
			uint32					: 31;
			uint32 _80MhzWpScp80211 : 1;  //bit [31]
		}; //Valid only in 802.11
	};
	union //word19
	{
		uint32 word19;
		struct
		{
			uint32 currSpLengthLimit 		: 8;  //bits [0..7]
			uint32 maxSupportedNss 			: 2;  //bits [8..9]	  /* used by training manager */
			uint32 maxNssNdpStaCapability 	: 2;  //bits [10..11] /* max NSS NDP as declared by the STA.  Used for roleback to station's capability during COC procedure */
			uint32 reserved12 				: 4;  //bits [12..15]	
			uint32 pn01 			 		: 16; //bits [16..31]
		};
	};
	union //word20
	{
		uint32 word20;
		struct
		{
			uint32 pn25 : 32; //bits [0..31]
		};
	};
	union //word21
	{
		uint32 word21;
		struct
		{
			uint32 keyIndex0		 : 11; //bits [0..10]
			uint32 reserved3		 : 5;  //bits [11..15]
			uint32 keyIndex1		 : 11; //bits [16..26]
			uint32 reserved4		 : 5;  //bits [27..31]
		};
	};
	union //word22
	{
		uint32 word22;
		struct
		{
			uint32 keyIndex2		 : 11; //bits [0..11]
			uint32 reserved5		 : 5;  //bits [12..14]
			uint32 keyIndex3		 : 11; //bits [15..26]
			uint32 reserved6		 : 5;  //bits [27..31]
		};
	};
} StaDbCommon_t;

typedef struct _StaDbTid_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 currentSequenceNumber : 12; //bits [0..11]
			uint32 reservedTid00		 : 4;  //bits [12..15]
			uint32 lowSequenceNumber	 : 12; //bits [16..27]
			uint32 reservedTid01		 : 4;  //bits [28..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 baEnable 					: 1;  //bit [0]
			uint32 ppduTxMode					: 2;  //bits [1..2], values from PpduTxMode_e
			uint32 maxPsduTransmissionTimeLimit : 13; //bits [3..15]
			uint32 currentBaWindowLimit 		: 6;  //bits [16..21]
			uint32 txopMultipleDataEn			: 1;  //bit [22]
			uint32 reservedTid10				: 9;  //bits [23..31]
		};
	};
} StaDbTid_t;

typedef struct _StaDbRa_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 macAddress03 : 32; //bits [0..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 macAddress45 : 16; //bits [0..15]
			uint32 reservedRa0	: 16; //bits [16..31]
		};
	};
} StaDbRa_t;

typedef struct _StaDbRaExtensionWpParams_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 reserved7		  : 1;	//bit [0]
			uint32 wpStbc			  : 2;	//bits [1..2]
			uint32 wpDataBwLimit	  : 2;	//bits [3..4]
			uint32 reserved8		  : 11; //bits [5..15]
			uint32 wpBfMode20Mhz	  : 2;	//bits [16..17]
			uint32 wpBfSmoothing20Mhz : 1;	//bit [18]
			uint32 reserved9		  : 1;	//bit [19]
			uint32 wpBfMode40Mhz	  : 2;	//bits [20..21]
			uint32 wpBfSmoothing40Mhz : 1;	//bit [22]
			uint32 reserved10		  : 1;	//bit [23]
			uint32 wpBfMode80Mhz	  : 2;	//bits [24..25]
			uint32 wpBfSmoothing80Mhz : 1;	//bit [26]
			uint32 reserved11		  : 5;	//bits [27..31]
		};
	};
} StaDbRaExtensionWpParams_t;

typedef struct _StaDb_t
{
	StaDbCommon_t			   common;
	StaDbTid_t				   tid[NUM_OF_TIDS];
	StaDbRa_t				   ra;
	StaDbRaExtensionWpParams_t raExtensionWpParams;
} StaDb_t;


#endif //_STA_DB_H_
