/***********************************************************************************
File:				VapDb.h
Module:				VapDb
Purpose:
Description:		This File was auto generated using Descriptor Excel Parser
************************************************************************************/
#ifndef _VAP_DB_H_
#define _VAP_DB_H_
/*---------------------------------------------------------------------------------
/						Includes													 
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h" 
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "SharedDbTypes.h"
#include "Tcr_Descriptors.h" 

/*---------------------------------------------------------------------------------
/						Defines													 
/----------------------------------------------------------------------------------*/



/*---------------------------------------------------------------------------------
/						Data Type Definition													 
/----------------------------------------------------------------------------------*/


typedef struct VapDbRfPowerTemplate
{
	uint32 powerTemplate1		:6; /*[5:0]    */
	uint32 powerTemplate2		:6; /*[11:6]  */
	uint32 reserved1			:4; /*[15:12] */
	uint32 powerTemplate3		:6; /*[21:16] */
	uint32 powerTemplate4		:6; /*[27:22] */
	uint32 reserved2			:4; /*[31:28] */
} VapDbRfPowerTemplate_t;

typedef struct _VapDbCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 maxMpduLengthLimit     : 14; //bits [0..13]
			uint32 bfReportResponseFormat : 2;  //bits [14..15], values from BfReportRxIndication_e
			uint32 qosEnableCapability    : 1;  //bit [16]
			uint32 negotiatedWds          : 1;  //bit [17]
			uint32 dataBwLimit            : 2;  //bits [18..19]
			uint32 _80211BwLimit          : 2;  //bits [20..21]
			uint32 dynamicBwEnable        : 1;  //bit [22]
			uint32 staticBwEnable         : 1;  //bit [23]
			uint32 maxMsduAtAmsduCount    : 8;  //bits [24..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 aMpduLimit                 : 6;  //bits [0..5]
			uint32 reserved0                  : 6;  //bits [6..11]
			uint32 noAggInPs                  : 1;  //bit [12]
			uint32 psForceOneNss              : 1;  //bit [13]
			uint32 sppAmsduCapable            : 1;  //bit [14]
			uint32 maxSpLength                : 7;  //bits [15..21]
			uint32 txPostpone                 : 2;  //bits [22..23], values from FillerType_e
			uint32 vapMode                    : 1;  //bit [24], values from VapMode_e
			uint32 currentPacketDensity       : 3;  //bits [25..27]
			uint32 rtsCtsTxMethod             : 2;  //bits [28..29], values from RtsCtsTxMethod_e
			uint32 ctsToSelfTxMethod          : 2;  //bits [30..31], values from CtsToSelfTxMethod_e
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 maxPsduLengthLimit     : 20; //bits [0..19]
			uint32 dataEncryptionType     : 3;  //bits [20..22], values from SecurityType_e
			uint32 managementEncryptionType   : 3;  //bits [23..25], values from SecurityType_e
			uint32 dataEncryptionEnable   : 1;  //bit [26]
			uint32 managementEncryptionEnable : 1;  //bit [27]
			uint32 dataKeyId              : 2;  //bits [28..29]
			uint32 _80211KeyId            : 2;  //bits [30..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 bfRxHwFwMode                         : 1;  //bit [0]
			uint32 bfRxMode                             : 3;  //bits [1..3]
			uint32 bfMinimalGrouping                    : 2;  //bits [4..5]
			uint32 maxNssNdp                            : 2;  //bits [6..7]
			uint32 maxNssTx                             : 2;  //bits [8..9]
			uint32 bfMfbUpdating                        : 1;  //bit [10]
			uint32 bfAgingRegisterIndex                 : 2;  //bits [11..12]
			uint32 nonStandardImplicitBfRulesTableIndex : 2;  //bits [13..14]
			uint32 bfImplicitFiller                     : 1;  //bit [15]
			uint32 bfDbValid                            : 1;  //bit [16]
			uint32 bfAgingStatus                        : 1;  //bit [17]
			uint32 bfReportType                         : 1;  //bit [18]
			uint32 bfHwReserved                         : 4;  //bits [19..22]
			uint32 mfbVariant                           : 1;  //bit [23], values from MfbVariant_e
			uint32 mcsFeedback                          : 7;  //bits [24..30]
			uint32 mfbValid                             : 1;  //bit [31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 tcr020MhzData : 24; //bits [0..23]
			uint32               : 8;
		};
		struct
		{
			uint32 tcr020MhzPhyModeData : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                      : 30;
		};
		struct
		{
			uint32                 : 2;
			uint32 tcr020MhzBwData : 2;  //bits [2..3], values from Bw_20Mhz_e
			uint32                 : 28;
		};
		struct
		{
			uint32                      : 4;
			uint32 tcr020MhzRfPowerData : 6;  //bits [4..9]
			uint32                      : 22;
		};
		struct
		{
			uint32                     : 10;
			uint32 tcr020MhzBfModeData : 2;  //bits [10..11], values from BfMode_e
			uint32                     : 20;
		};
		struct
		{
			uint32                               : 12;
			uint32 tcr020MhzAntennaSelectionData : 8;  //bits [12..19]
			uint32                               : 12;
		};
		struct
		{
			uint32                       : 20;
			uint32 tcr020MhzGenrisc0Data : 4;  //bits [20..23]
			uint32                       : 8;
		};
		struct
		{
			uint32                     : 24;
			uint32 _20MhzWpRfPowerData : 6;  //bits [24..29]
			uint32                     : 2;
		}; //Valid only in Data
		struct
		{
			uint32                     : 30;
			uint32 _20MhzWpPhyModeData : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in Data
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 tcr320MhzData : 24; //bits [0..23]
			uint32               : 8;
		};
		struct
		{
			uint32 tcr320MhzAggregateData : 1;  //bit [0]
			uint32                        : 31;
		};
		struct
		{
			uint32                          : 1;
			uint32 tcr320MhzNotSoundingData : 1;  //bit [1]
			uint32                          : 30;
		};
		struct
		{
			uint32                          : 2;
			uint32 tcr320MhzBfSmoothingData : 1;  //bit [2]
			uint32                          : 29;
		};
		struct
		{
			uint32                        : 3;
			uint32 tcr320MhzDynamicBwData : 1;  //bit [3]
			uint32                        : 28;
		};
		struct
		{
			uint32                        : 4;
			uint32 tcr320MhzReserved0Data : 4;  //bits [4..7]
			uint32                        : 24;
		};
		struct
		{
			uint32                   : 8;
			uint32 tcr320MhzRateData : 6;  //bits [8..13]
			uint32                   : 18;
		};
		struct
		{
			uint32                        : 14;
			uint32 tcr320MhzReserved1Data : 2;  //bits [14..15]
			uint32                        : 16;
		};
		struct
		{
			uint32                  : 16;
			uint32 tcr320MhzScpData : 1;  //bit [16]
			uint32                  : 15;
		};
		struct
		{
			uint32                        : 17;
			uint32 tcr320MhzReserved2Data : 7;  //bits [17..23]
			uint32                        : 8;
		};
		struct
		{
			uint32                  : 24;
			uint32 _20MhzWpRateData : 7;  //bits [24..30]
			uint32                  : 1;
		}; //Valid only in Data
		struct
		{
			uint32                 : 31;
			uint32 _20MhzWpScpData : 1;  //bit [31]
		}; //Valid only in Data
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 tcr040MhzData : 24; //bits [0..23]
			uint32               : 8;
		};
		struct
		{
			uint32 tcr040MhzPhyModeData : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                      : 30;
		};
		struct
		{
			uint32                 : 2;
			uint32 tcr040MhzBwData : 2;  //bits [2..3], values from Bw_40Mhz_e
			uint32                 : 28;
		};
		struct
		{
			uint32                      : 4;
			uint32 tcr040MhzRfPowerData : 6;  //bits [4..9]
			uint32                      : 22;
		};
		struct
		{
			uint32                     : 10;
			uint32 tcr040MhzBfModeData : 2;  //bits [10..11], values from BfMode_e
			uint32                     : 20;
		};
		struct
		{
			uint32                               : 12;
			uint32 tcr040MhzAntennaSelectionData : 8;  //bits [12..19]
			uint32                               : 12;
		};
		struct
		{
			uint32                       : 20;
			uint32 tcr040MhzGenrisc0Data : 4;  //bits [20..23]
			uint32                       : 8;
		};
		struct
		{
			uint32                     : 24;
			uint32 _40MhzWpRfPowerData : 6;  //bits [24..29]
			uint32                     : 2;
		}; //Valid only in Data
		struct
		{
			uint32                     : 30;
			uint32 _40MhzWpPhyModeData : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in Data
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 tcr340MhzData : 24; //bits [0..23]
			uint32               : 8;
		};
		struct
		{
			uint32 tcr340MhzAggregateData : 1;  //bit [0]
			uint32                        : 31;
		};
		struct
		{
			uint32                          : 1;
			uint32 tcr340MhzNotSoundingData : 1;  //bit [1]
			uint32                          : 30;
		};
		struct
		{
			uint32                          : 2;
			uint32 tcr340MhzBfSmoothingData : 1;  //bit [2]
			uint32                          : 29;
		};
		struct
		{
			uint32                        : 3;
			uint32 tcr340MhzDynamicBwData : 1;  //bit [3]
			uint32                        : 28;
		}; //"0" means unlimited
		struct
		{
			uint32                        : 4;
			uint32 tcr340MhzReserved0Data : 4;  //bits [4..7]
			uint32                        : 24;
		};
		struct
		{
			uint32                   : 8;
			uint32 tcr340MhzRateData : 6;  //bits [8..13]
			uint32                   : 18;
		}; //"0" means 64
		struct
		{
			uint32                        : 14;
			uint32 tcr340MhzReserved1Data : 2;  //bits [14..15]
			uint32                        : 16;
		};
		struct
		{
			uint32                  : 16;
			uint32 tcr340MhzScpData : 1;  //bit [16]
			uint32                  : 15;
		};
		struct
		{
			uint32                        : 17;
			uint32 tcr340MhzReserved2Data : 7;  //bits [17..23]
			uint32                        : 8;
		};
		struct
		{
			uint32                  : 24;
			uint32 _40MhzWpRateData : 7;  //bits [24..30]
			uint32                  : 1;
		}; //Valid only in Data
		struct
		{
			uint32                 : 31;
			uint32 _40MhzWpScpData : 1;  //bit [31]
		}; //Valid only in Data
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 tcr080MhzData : 24; //bits [0..23]
			uint32               : 8;
		};
		struct
		{
			uint32 tcr080MhzPhyModeData : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                      : 30;
		};
		struct
		{
			uint32                 : 2;
			uint32 tcr080MhzBwData : 2;  //bits [2..3], values from Bw_80Mhz_e
			uint32                 : 28;
		};
		struct
		{
			uint32                      : 4;
			uint32 tcr080MhzRfPowerData : 6;  //bits [4..9]
			uint32                      : 22;
		};
		struct
		{
			uint32                     : 10;
			uint32 tcr080MhzBfModeData : 2;  //bits [10..11], values from BfMode_e
			uint32                     : 20;
		};
		struct
		{
			uint32                               : 12;
			uint32 tcr080MhzAntennaSelectionData : 8;  //bits [12..19]
			uint32                               : 12;
		};
		struct
		{
			uint32                       : 20;
			uint32 tcr080MhzGenrisc0Data : 4;  //bits [20..23]
			uint32                       : 8;
		};
		struct
		{
			uint32                     : 24;
			uint32 _80MhzWpRfPowerData : 6;  //bits [24..29]
			uint32                     : 2;
		}; //Valid only in Data
		struct
		{
			uint32                     : 30;
			uint32 _80MhzWpPhyModeData : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in Data
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 tcr380MhzData : 24; //bits [0..23]
			uint32               : 8;
		};
		struct
		{
			uint32 tcr380MhzAggregateData : 1;  //bit [0]
			uint32                        : 31;
		};
		struct
		{
			uint32                          : 1;
			uint32 tcr380MhzNotSoundingData : 1;  //bit [1]
			uint32                          : 30;
		};
		struct
		{
			uint32                          : 2;
			uint32 tcr380MhzBfSmoothingData : 1;  //bit [2]
			uint32                          : 29;
		};
		struct
		{
			uint32                        : 3;
			uint32 tcr380MhzDynamicBwData : 1;  //bit [3]
			uint32                        : 28;
		};
		struct
		{
			uint32                        : 4;
			uint32 tcr380MhzReserved0Data : 4;  //bits [4..7]
			uint32                        : 24;
		};
		struct
		{
			uint32                   : 8;
			uint32 tcr380MhzRateData : 6;  //bits [8..13]
			uint32                   : 18;
		};
		struct
		{
			uint32                        : 14;
			uint32 tcr380MhzReserved1Data : 2;  //bits [14..15]
			uint32                        : 16;
		};
		struct
		{
			uint32                  : 16;
			uint32 tcr380MhzScpData : 1;  //bit [16]
			uint32                  : 15;
		};
		struct
		{
			uint32                        : 17;
			uint32 tcr380MhzReserved2Data : 7;  //bits [17..23]
			uint32                        : 8;
		};
		struct
		{
			uint32                  : 24;
			uint32 _80MhzWpRateData : 7;  //bits [24..30]
			uint32                  : 1;
		}; //Valid only in Data
		struct
		{
			uint32                 : 31;
			uint32 _80MhzWpScpData : 1;  //bit [31]
		}; //Valid only in Data
	};
	union //word10
	{
		uint32 word10;
		struct
		{
			uint32 tcr1Data : 24; //bits [0..23]
			uint32          : 8;
		};
		struct
		{
			uint32 ldpcData : 1;  //bit [0]
			uint32          : 31;
		};
		struct
		{
			uint32          : 1;
			uint32 stbcData : 2;  //bits [1..2]
			uint32          : 29;
		};
		struct
		{
			uint32                : 3;
			uint32 partialAidData : 9;  //bits [3..11]
			uint32                : 20;
		};
		struct
		{
			uint32                      : 12;
			uint32 txopPsNotAllowedData : 1;  //bit [12]
			uint32                      : 19;
		};
		struct
		{
			uint32             : 13;
			uint32 groupIdData : 6;  //bits [13..18]
			uint32             : 13;
		};
		struct
		{
			uint32                   : 19;
			uint32 tcr1DataReserved0 : 2;  //bits [19..20]
			uint32                   : 11;
		};
		struct
		{
			uint32                         : 21;
			uint32 tcr1NdpTrainingModeData : 1;  //bit [21]
			uint32                         : 10;
		};
		struct
		{
			uint32                    : 22;
			uint32 tcr1MuTrainingData : 1;  //bit [22]
			uint32                    : 9;
		};
		struct
		{
			uint32                  : 23;
			uint32 tcr1MuPhyNdpData : 1;  //bit [23]
			uint32                  : 8;
		};
		struct
		{
			uint32                                : 24;
			uint32 baaWeightedSuccessMduReference : 8;  //bits [24..31]
		};
	};
	union //word11
	{
		uint32 word11;
		struct
		{
			uint32 tcr2 : 24; //bits [0..23]
			uint32      : 8;
		};
		struct
		{
			uint32 cddAnt1 : 4;  //bits [0..3]
			uint32         : 28;
		};
		struct
		{
			uint32         : 4;
			uint32 cddAnt2 : 4;  //bits [4..7]
			uint32         : 24;
		};
		struct
		{
			uint32         : 8;
			uint32 cddAnt3 : 4;  //bits [8..11]
			uint32         : 20;
		};
		struct
		{
			uint32              : 12;
			uint32 tcr2BwChange : 1;  //bit [12]
			uint32              : 19;
		};
		struct
		{
			uint32               : 13;
			uint32 tcr2Ant0Boost : 2;  //bits [13..14]
			uint32               : 17;
		};
		struct
		{
			uint32               : 15;
			uint32 tcr2Ant1Boost : 2;  //bits [15..16]
			uint32               : 15;
		};
		struct
		{
			uint32               : 17;
			uint32 tcr2Ant2Boost : 2;  //bits [17..18]
			uint32               : 13;
		};
		struct
		{
			uint32               : 19;
			uint32 tcr2Ant3Boost : 2;  //bits [19..20]
			uint32               : 11;
		};
		struct
		{
			uint32          : 21;
			uint32 genrisc1 : 3;  //bits [21..23]
			uint32          : 8;
		};
		struct
		{
			uint32                             : 24;
			uint32 baaWeightedFailMduReference : 8;  //bits [24..31]
		};
	};
	union //word12
	{
		uint32 word12;
		struct
		{
			uint32 tcr180211 : 24; //bits [0..23]
			uint32           : 8;
		};
		struct
		{
			uint32 ldpc80211 : 1;  //bit [0]
			uint32           : 31;
		};
		struct
		{
			uint32           : 1;
			uint32 stbc80211 : 2;  //bits [1..2]
			uint32           : 29;
		};
		struct
		{
			uint32                 : 3;
			uint32 partialAid80211 : 9;  //bits [3..11]
			uint32                 : 20;
		};
		struct
		{
			uint32                       : 12;
			uint32 txopPsNotAllowed80211 : 1;  //bit [12]
			uint32                       : 19;
		};
		struct
		{
			uint32              : 13;
			uint32 groupId80211 : 6;  //bits [13..18]
			uint32              : 13;
		};
		struct
		{
			uint32                    : 19;
			uint32 tcr180211Reserved0 : 2;  //bits [19..20]
			uint32                    : 11;
		};
		struct
		{
			uint32                          : 21;
			uint32 tcr1NdpTrainingMode80211 : 1;  //bit [21]
			uint32                          : 10;
		};
		struct
		{
			uint32                     : 22;
			uint32 tcr1MuTraining80211 : 1;  //bit [22]
			uint32                     : 9;
		};
		struct
		{
			uint32                   : 23;
			uint32 tcr1MuPhyNdp80211 : 1;  //bit [23]
			uint32                   : 8;
		};
		struct
		{
			uint32                          : 24;
			uint32 altRateReasonFastProbing : 1;  //bit [24]
			uint32                          : 7;
		};
		struct
		{
			uint32                          : 25;
			uint32 altRateReasonSlowProbing : 1;  //bit [25]
			uint32                          : 6;
		};
		struct
		{
			uint32                                 : 26;
			uint32 altRateReasonBfReportFastUpdate : 1;  //bit [26]
			uint32                                 : 5;
		};
		struct
		{
			uint32                            : 27;
			uint32 probingIndicationReserved0 : 5;  //bits [27..31]
		};
	};
	union //word13
	{
		uint32 word13;
		struct
		{
			uint32 tcr020Mhz80211 : 24; //bits [0..23]
			uint32                : 8;
		};
		struct
		{
			uint32 tcr020MhzPhyMode80211 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                       : 30;
		};
		struct
		{
			uint32                  : 2;
			uint32 tcr020MhzBw80211 : 2;  //bits [2..3], values from Bw_20Mhz_e
			uint32                  : 28;
		};
		struct
		{
			uint32                       : 4;
			uint32 tcr020MhzRfPower80211 : 6;  //bits [4..9]
			uint32                       : 22;
		};
		struct
		{
			uint32                      : 10;
			uint32 tcr020MhzBfMode80211 : 2;  //bits [10..11], values from BfMode_e
			uint32                      : 20;
		};
		struct
		{
			uint32                                : 12;
			uint32 tcr020MhzAntennaSelection80211 : 8;  //bits [12..19]
			uint32                                : 12;
		};
		struct
		{
			uint32                        : 20;
			uint32 tcr020MhzGenrisc080211 : 4;  //bits [20..23]
			uint32                        : 8;
		};
		struct
		{
			uint32                      : 24;
			uint32 _20MhzWpRfPower80211 : 6;  //bits [24..29]
			uint32                      : 2;
		}; //Valid only in 802.11
		struct
		{
			uint32                      : 30;
			uint32 _20MhzWpPhyMode80211 : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in 802.11
	};
	union //word14
	{
		uint32 word14;
		struct
		{
			uint32 tcr320Mhz80211 : 24; //bits [0..23]
			uint32                : 8;
		};
		struct
		{
			uint32 tcr320MhzAggregate80211 : 1;  //bit [0]
			uint32                         : 31;
		};
		struct
		{
			uint32                           : 1;
			uint32 tcr320MhzNotSounding80211 : 1;  //bit [1]
			uint32                           : 30;
		};
		struct
		{
			uint32                           : 2;
			uint32 tcr320MhzBfSmoothing80211 : 1;  //bit [2]
			uint32                           : 29;
		};
		struct
		{
			uint32                         : 3;
			uint32 tcr320MhzDynamicBw80211 : 1;  //bit [3]
			uint32                         : 28;
		};
		struct
		{
			uint32                         : 4;
			uint32 tcr320MhzReserved080211 : 4;  //bits [4..7]
			uint32                         : 24;
		};
		struct
		{
			uint32                    : 8;
			uint32 tcr320MhzRate80211 : 6;  //bits [8..13]
			uint32                    : 18;
		};
		struct
		{
			uint32                         : 14;
			uint32 tcr320MhzReserved180211 : 2;  //bits [14..15]
			uint32                         : 16;
		};
		struct
		{
			uint32                   : 16;
			uint32 tcr320MhzScp80211 : 1;  //bit [16]
			uint32                   : 15;
		};
		struct
		{
			uint32                         : 17;
			uint32 tcr320MhzReserved280211 : 7;  //bits [17..23]
			uint32                         : 8;
		};
		struct
		{
			uint32                   : 24;
			uint32 _20MhzWpRate80211 : 7;  //bits [24..30]
			uint32                   : 1;
		}; //Valid only in 802.11
		struct
		{
			uint32                  : 31;
			uint32 _20MhzWpScp80211 : 1;  //bit [31]
		}; //Valid only in 802.11
	};
	union //word15
	{
		uint32 word15;
		struct
		{
			uint32 tcr040Mhz80211 : 24; //bits [0..23]
			uint32                : 8;
		};
		struct
		{
			uint32 tcr040MhzPhyMode80211 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                       : 30;
		};
		struct
		{
			uint32                  : 2;
			uint32 tcr040MhzBw80211 : 2;  //bits [2..3], values from Bw_40Mhz_e
			uint32                  : 28;
		};
		struct
		{
			uint32                       : 4;
			uint32 tcr040MhzRfPower80211 : 6;  //bits [4..9]
			uint32                       : 22;
		};
		struct
		{
			uint32                      : 10;
			uint32 tcr040MhzBfMode80211 : 2;  //bits [10..11], values from BfMode_e
			uint32                      : 20;
		};
		struct
		{
			uint32                                : 12;
			uint32 tcr040MhzAntennaSelection80211 : 8;  //bits [12..19]
			uint32                                : 12;
		};
		struct
		{
			uint32                        : 20;
			uint32 tcr040MhzGenrisc080211 : 4;  //bits [20..23]
			uint32                        : 8;
		};
		struct
		{
			uint32                      : 24;
			uint32 _40MhzWpRfPower80211 : 6;  //bits [24..29]
			uint32                      : 2;
		}; //Valid only in 802.11
		struct
		{
			uint32                      : 30;
			uint32 _40MhzWpPhyMode80211 : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in 802.11
	};
	union //word16
	{
		uint32 word16;
		struct
		{
			uint32 tcr340Mhz80211 : 24; //bits [0..23]
			uint32                : 8;
		};
		struct
		{
			uint32 tcr340MhzAggregate80211 : 1;  //bit [0]
			uint32                         : 31;
		};
		struct
		{
			uint32                           : 1;
			uint32 tcr340MhzNotSounding80211 : 1;  //bit [1]
			uint32                           : 30;
		};
		struct
		{
			uint32                           : 2;
			uint32 tcr340MhzBfSmoothing80211 : 1;  //bit [2]
			uint32                           : 29;
		};
		struct
		{
			uint32                         : 3;
			uint32 tcr340MhzDynamicBw80211 : 1;  //bit [3]
			uint32                         : 28;
		};
		struct
		{
			uint32                         : 4;
			uint32 tcr340MhzReserved080211 : 4;  //bits [4..7]
			uint32                         : 24;
		};
		struct
		{
			uint32                    : 8;
			uint32 tcr340MhzRate80211 : 6;  //bits [8..13]
			uint32                    : 18;
		};
		struct
		{
			uint32                         : 14;
			uint32 tcr340MhzReserved180211 : 2;  //bits [14..15]
			uint32                         : 16;
		};
		struct
		{
			uint32                   : 16;
			uint32 tcr340MhzScp80211 : 1;  //bit [16]
			uint32                   : 15;
		};
		struct
		{
			uint32                         : 17;
			uint32 tcr340MhzReserved280211 : 7;  //bits [17..23]
			uint32                         : 8;
		};
		struct
		{
			uint32                   : 24;
			uint32 _40MhzWpRate80211 : 7;  //bits [24..30]
			uint32                   : 1;
		}; //Valid only in 802.11
		struct
		{
			uint32                  : 31;
			uint32 _40MhzWpScp80211 : 1;  //bit [31]
		}; //Valid only in 802.11
	};
	union //word17
	{
		uint32 word17;
		struct
		{
			uint32 tcr080Mhz80211 : 24; //bits [0..23]
			uint32                : 8;
		};
		struct
		{
			uint32 tcr080MhzPhyMode80211 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                       : 30;
		};
		struct
		{
			uint32                  : 2;
			uint32 tcr080MhzBw80211 : 2;  //bits [2..3], values from Bw_80Mhz_e
			uint32                  : 28;
		};
		struct
		{
			uint32                       : 4;
			uint32 tcr080MhzRfPower80211 : 6;  //bits [4..9]
			uint32                       : 22;
		};
		struct
		{
			uint32                      : 10;
			uint32 tcr080MhzBfMode80211 : 2;  //bits [10..11], values from BfMode_e
			uint32                      : 20;
		};
		struct
		{
			uint32                                : 12;
			uint32 tcr080MhzAntennaSelection80211 : 8;  //bits [12..19]
			uint32                                : 12;
		};
		struct
		{
			uint32                        : 20;
			uint32 tcr080MhzGenrisc080211 : 4;  //bits [20..23]
			uint32                        : 8;
		};
		struct
		{
			uint32                      : 24;
			uint32 _80MhzWpRfPower80211 : 6;  //bits [24..29]
			uint32                      : 2;
		}; //Valid only in 802.11
		struct
		{
			uint32                      : 30;
			uint32 _80MhzWpPhyMode80211 : 2;  //bits [30..31], values from PhyModeOld_e
		}; //Valid only in 802.11
	};
	union //word18
	{
		uint32 word18;
		struct
		{
			uint32 tcr380Mhz80211 : 24; //bits [0..23]
			uint32                : 8;
		};
		struct
		{
			uint32 tcr380MhzAggregate80211 : 1;  //bit [0]
			uint32                         : 31;
		};
		struct
		{
			uint32                           : 1;
			uint32 tcr380MhzNotSounding80211 : 1;  //bit [1]
			uint32                           : 30;
		};
		struct
		{
			uint32                           : 2;
			uint32 tcr380MhzBfSmoothing80211 : 1;  //bit [2]
			uint32                           : 29;
		};
		struct
		{
			uint32                         : 3;
			uint32 tcr380MhzDynamicBw80211 : 1;  //bit [3]
			uint32                         : 28;
		};
		struct
		{
			uint32                         : 4;
			uint32 tcr380MhzReserved080211 : 4;  //bits [4..7]
			uint32                         : 24;
		};
		struct
		{
			uint32                    : 8;
			uint32 tcr380MhzRate80211 : 6;  //bits [8..13]
			uint32                    : 18;
		};
		struct
		{
			uint32                         : 14;
			uint32 tcr380MhzReserved180211 : 2;  //bits [14..15]
			uint32                         : 16;
		};
		struct
		{
			uint32                   : 16;
			uint32 tcr380MhzScp80211 : 1;  //bit [16]
			uint32                   : 15;
		};
		struct
		{
			uint32                         : 17;
			uint32 tcr380MhzReserved280211 : 7;  //bits [17..23]
			uint32                         : 8;
		};
		struct
		{
			uint32                   : 24;
			uint32 _80MhzWpRate80211 : 7;  //bits [24..30]
			uint32                   : 1;
		}; //Valid only in 802.11
		struct
		{
			uint32                  : 31;
			uint32 _80MhzWpScp80211 : 1;  //bit [31]
		}; //Valid only in 802.11
	};
	union //word19
	{
		uint32 word19;
		struct
		{
			uint32 currSpLengthLimit   : 8;  //bits [0..7]
			uint32 soundingDialogToken : 6;  //bits [8..13]
			uint32 reserved1           : 2;  //bits [14..15]
			uint32 pn01                : 16; //bits [16..31]
		};
	};
	union //word20
	{
		uint32 word20;
		struct
		{
			uint32 pn25 : 32; //bits [0..31]
		};
	};
	union //word21
	{
		uint32 word21;
		struct
		{
			uint32 keyIndex0 : 11; //bits [0..10]
			uint32 reserved2 : 5;  //bits [11..15]
			uint32 keyIndex1 : 11; //bits [16..26]
			uint32 reserved3 : 5;  //bits [27..31]
		};
	};
	union //word22
	{
		uint32 word22;
		struct
		{
			uint32 keyIndex2 : 11; //bits [0..10]
			uint32 reserved4 : 5;  //bits [11..15]
			uint32 keyIndex3 : 11; //bits [16..26]
			uint32 reserved5 : 5;  //bits [27..31]
		};
	};
	union //word23
	{
		uint32 word23;
		struct
		{
			uint32 reserved6 : 16; //bits [0..15]
			uint32 bipPn01   : 16; //bits [16..31]
		};
	};
	union //word24
	{
		uint32 word24;
		struct
		{
			uint32 bipPn25 : 32; //bits [0..31]
		};
	};
} VapDbCommon_t;

typedef struct _VapDbTcrTemplates_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 tcr0Template1 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32 tcr0PhyModeTemplate1 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                      : 30;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                 : 2;
			uint32 tcr0BwTemplate1 : 2;  //bits [2..3], values from Bw_e
			uint32                 : 28;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                      : 4;
			uint32 tcr0RfPowerTemplate1 : 6;  //bits [4..9]
			uint32                      : 22;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                     : 10;
			uint32 tcr0BfModeTemplate1 : 2;  //bits [10..11], values from BfMode_e
			uint32                     : 20;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                               : 12;
			uint32 tcr0AntennaSelectionTemplate1 : 8;  //bits [12..19]
			uint32                               : 12;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                       : 20;
			uint32 tcr0Genrisc0Template1 : 4;  //bits [20..23]
			uint32                       : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32           : 24;
			uint32 reserved7 : 8;  //bits [24..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 tcr1Template1 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32 tcr1LdpcTemplate1 : 1;  //bit [0]
			uint32                   : 31;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                   : 1;
			uint32 tcr1StbcTemplate1 : 2;  //bits [1..2]
			uint32                   : 29;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                         : 3;
			uint32 tcr1PartialAidTemplate1 : 9;  //bits [3..11]
			uint32                         : 20;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                               : 12;
			uint32 tcr1TxopPsNotAllowedTemplate1 : 1;  //bit [12]
			uint32                               : 19;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                      : 13;
			uint32 tcr1GroupIdTemplate1 : 6;  //bits [13..18]
			uint32                      : 13;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 19;
			uint32 tcr1Reserved0Template1 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                              : 21;
			uint32 tcr1NdpTrainingModeTemplate1 : 1;  //bit [21]
			uint32                              : 10;
		};
		struct
		{
			uint32                         : 22;
			uint32 tcr1MuTrainingTemplate1 : 1;  //bit [22]
			uint32                         : 9;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                       : 23;
			uint32 tcr1MuPhyNdpTemplate1 : 1;  //bit [23]
			uint32                       : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32           : 24;
			uint32 reserved8 : 8;  //bits [24..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 tcr2Template1 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32 tcr2CddAnt1Template1 : 4;  //bits [0..3]
			uint32                      : 28;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                      : 4;
			uint32 tcr2CddAnt2Template1 : 4;  //bits [4..7]
			uint32                      : 24;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                      : 8;
			uint32 tcr2CddAnt3Template1 : 4;  //bits [8..11]
			uint32                      : 20;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                       : 12;
			uint32 tcr2BwChangeTemplate1 : 1;  //bit [12]
			uint32                       : 19;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 13;
			uint32 tcr2Ant0BoostTemplate1 : 2;  //bits [13..14]
			uint32                        : 17;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 15;
			uint32 tcr2Ant1BoostTemplate1 : 2;  //bits [15..16]
			uint32                        : 15;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 17;
			uint32 tcr2Ant2BoostTemplate1 : 2;  //bits [17..18]
			uint32                        : 13;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 19;
			uint32 tcr2Ant3BoostTemplate1 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                   : 21;
			uint32 genrisc1Template1 : 3;  //bits [21..23]
			uint32                   : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32           : 24;
			uint32 reserved9 : 8;  //bits [24..31]
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 tcr3Template1 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32 tcr3AggregateTemplate1 : 1;  //bit [0]
			uint32                        : 31;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                          : 1;
			uint32 tcr3NotSoundingTemplate1 : 1;  //bit [1]
			uint32                          : 30;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                          : 2;
			uint32 tcr3BfSmoothingTemplate1 : 1;  //bit [2]
			uint32                          : 29;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 3;
			uint32 tcr3DynamicBwTemplate1 : 1;  //bit [3]
			uint32                        : 28;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 4;
			uint32 tcr3Reserved0Template1 : 4;  //bits [4..7]
			uint32                        : 24;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                   : 8;
			uint32 tcr3RateTemplate1 : 6;  //bits [8..13]
			uint32                   : 18;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 14;
			uint32 tcr3Reserved1Template1 : 2;  //bits [14..15]
			uint32                        : 16;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                  : 16;
			uint32 tcr3ScpTemplate1 : 1;  //bit [16]
			uint32                  : 15;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32                        : 17;
			uint32 tcr3Reserved2Template1 : 7;  //bits [17..23]
			uint32                        : 8;
		}; //Used for RTS, CTS2Self, CF-END, NDPA
		struct
		{
			uint32            : 24;
			uint32 reserved10 : 8;  //bits [24..31]
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 tcr0Template2 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32 tcr0PhyModeTemplate2 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                      : 30;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                 : 2;
			uint32 tcr0BwTemplate2 : 2;  //bits [2..3], values from Bw_e
			uint32                 : 28;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                      : 4;
			uint32 tcr0RfPowerTemplate2 : 6;  //bits [4..9]
			uint32                      : 22;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                     : 10;
			uint32 tcr0BfModeTemplate2 : 2;  //bits [10..11], values from BfMode_e
			uint32                     : 20;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                               : 12;
			uint32 tcr0AntennaSelectionTemplate2 : 8;  //bits [12..19]
			uint32                               : 12;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                       : 20;
			uint32 tcr0Genrisc0Template2 : 4;  //bits [20..23]
			uint32                       : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32            : 24;
			uint32 reserved11 : 8;  //bits [24..31]
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 tcr1Template2 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32 tcr1LdpcTemplate2 : 1;  //bit [0]
			uint32                   : 31;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                   : 1;
			uint32 tcr1StbcTemplate2 : 2;  //bits [1..2]
			uint32                   : 29;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                         : 3;
			uint32 tcr1PartialAidTemplate2 : 9;  //bits [3..11]
			uint32                         : 20;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                               : 12;
			uint32 tcr1TxopPsNotAllowedTemplate2 : 1;  //bit [12]
			uint32                               : 19;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                      : 13;
			uint32 tcr1GroupIdTemplate2 : 6;  //bits [13..18]
			uint32                      : 13;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 19;
			uint32 tcr1Reserved0Template2 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                              : 21;
			uint32 tcr1NdpTrainingModeTemplate2 : 1;  //bit [21]
			uint32                              : 10;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                         : 22;
			uint32 tcr1MuTrainingTemplate2 : 1;  //bit [22]
			uint32                         : 9;
		};
		struct
		{
			uint32                       : 23;
			uint32 tcr1MuPhyNdpTemplate2 : 1;  //bit [23]
			uint32                       : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32            : 24;
			uint32 reserved12 : 8;  //bits [24..31]
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 tcr2Template2 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32 tcr2CddAnt1Template2 : 4;  //bits [0..3]
			uint32                      : 28;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                      : 4;
			uint32 tcr2CddAnt2Template2 : 4;  //bits [4..7]
			uint32                      : 24;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                      : 8;
			uint32 tcr2CddAnt3Template2 : 4;  //bits [8..11]
			uint32                      : 20;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                       : 12;
			uint32 tcr2BwChangeTemplate2 : 1;  //bit [12]
			uint32                       : 19;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 13;
			uint32 tcr2Ant0BoostTemplate2 : 2;  //bits [13..14]
			uint32                        : 17;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 15;
			uint32 tcr2Ant1BoostTemplate2 : 2;  //bits [15..16]
			uint32                        : 15;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 17;
			uint32 tcr2Ant2BoostTemplate2 : 2;  //bits [17..18]
			uint32                        : 13;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 19;
			uint32 tcr2Ant3BoostTemplate2 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                   : 21;
			uint32 genrisc1Template2 : 3;  //bits [21..23]
			uint32                   : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32            : 24;
			uint32 reserved13 : 8;  //bits [24..31]
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 tcr3Template2 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32 tcr3AggregateTemplate2 : 1;  //bit [0]
			uint32                        : 31;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                          : 1;
			uint32 tcr3NotSoundingTemplate2 : 1;  //bit [1]
			uint32                          : 30;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                          : 2;
			uint32 tcr3BfSmoothingTemplate2 : 1;  //bit [2]
			uint32                          : 29;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 3;
			uint32 tcr3DynamicBwTemplate2 : 1;  //bit [3]
			uint32                        : 28;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 4;
			uint32 tcr3Reserved0Template2 : 4;  //bits [4..7]
			uint32                        : 24;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                   : 8;
			uint32 tcr3RateTemplate2 : 6;  //bits [8..13]
			uint32                   : 18;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 14;
			uint32 tcr3Reserved1Template2 : 2;  //bits [14..15]
			uint32                        : 16;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                  : 16;
			uint32 tcr3ScpTemplate2 : 1;  //bit [16]
			uint32                  : 15;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32                        : 17;
			uint32 tcr3Reserved2Template2 : 7;  //bits [17..23]
			uint32                        : 8;
		}; //Used for MAC-HT NDP Announcement
		struct
		{
			uint32            : 24;
			uint32 reserved14 : 8;  //bits [24..31]
		};
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 tcr0Template3 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr0PhyModeTemplate3 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                      : 30;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                 : 2;
			uint32 tcr0BwTemplate3 : 2;  //bits [2..3], values from Bw_e
			uint32                 : 28;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 4;
			uint32 tcr0RfPowerTemplate3 : 6;  //bits [4..9]
			uint32                      : 22;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                     : 10;
			uint32 tcr0BfModeTemplate3 : 2;  //bits [10..11], values from BfMode_e
			uint32                     : 20;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                               : 12;
			uint32 tcr0AntennaSelectionTemplate3 : 8;  //bits [12..19]
			uint32                               : 12;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                       : 20;
			uint32 tcr0Genrisc0Template3 : 4;  //bits [20..23]
			uint32                       : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved15 : 8;  //bits [24..31]
		};
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 tcr1Template3 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr1LdpcTemplate3 : 1;  //bit [0]
			uint32                   : 31;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                   : 1;
			uint32 tcr1StbcTemplate3 : 2;  //bits [1..2]
			uint32                   : 29;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                         : 3;
			uint32 tcr1PartialAidTemplate3 : 9;  //bits [3..11]
			uint32                         : 20;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                               : 12;
			uint32 tcr1TxopPsNotAllowedTemplate3 : 1;  //bit [12]
			uint32                               : 19;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 13;
			uint32 tcr1GroupIdTemplate3 : 6;  //bits [13..18]
			uint32                      : 13;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 19;
			uint32 tcr1Reserved0Template3 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                              : 21;
			uint32 tcr1NdpTrainingModeTemplate3 : 1;  //bit [21]
			uint32                              : 10;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                         : 22;
			uint32 tcr1MuTrainingTemplate3 : 1;  //bit [22]
			uint32                         : 9;
		};
		struct
		{
			uint32                       : 23;
			uint32 tcr1MuPhyNdpTemplate3 : 1;  //bit [23]
			uint32                       : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved16 : 8;  //bits [24..31]
		};
	};
	union //word10
	{
		uint32 word10;
		struct
		{
			uint32 tcr2Template3 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr2CddAnt1Template3 : 4;  //bits [0..3]
			uint32                      : 28;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 4;
			uint32 tcr2CddAnt2Template3 : 4;  //bits [4..7]
			uint32                      : 24;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 8;
			uint32 tcr2CddAnt3Template3 : 4;  //bits [8..11]
			uint32                      : 20;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                       : 12;
			uint32 tcr2BwChangeTemplate3 : 1;  //bit [12]
			uint32                       : 19;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 13;
			uint32 tcr2Ant0BoostTemplate3 : 2;  //bits [13..14]
			uint32                        : 17;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 15;
			uint32 tcr2Ant1BoostTemplate3 : 2;  //bits [15..16]
			uint32                        : 15;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 17;
			uint32 tcr2Ant2BoostTemplate3 : 2;  //bits [17..18]
			uint32                        : 13;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 19;
			uint32 tcr2Ant3BoostTemplate3 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                   : 21;
			uint32 genrisc1Template3 : 3;  //bits [21..23]
			uint32                   : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved17 : 8;  //bits [24..31]
		};
	};
	union //word11
	{
		uint32 word11;
		struct
		{
			uint32 tcr3Template3 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr3AggregateTemplate3 : 1;  //bit [0]
			uint32                        : 31;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                          : 1;
			uint32 tcr3NotSoundingTemplate3 : 1;  //bit [1]
			uint32                          : 30;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                          : 2;
			uint32 tcr3BfSmoothingTemplate3 : 1;  //bit [2]
			uint32                          : 29;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 3;
			uint32 tcr3DynamicBwTemplate3 : 1;  //bit [3]
			uint32                        : 28;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 4;
			uint32 tcr3Reserved0Template3 : 4;  //bits [4..7]
			uint32                        : 24;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                   : 8;
			uint32 tcr3RateTemplate3 : 6;  //bits [8..13]
			uint32                   : 18;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 14;
			uint32 tcr3Reserved1Template3 : 2;  //bits [14..15]
			uint32                        : 16;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                  : 16;
			uint32 tcr3ScpTemplate3 : 1;  //bit [16]
			uint32                  : 15;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 17;
			uint32 tcr3Reserved2Template3 : 7;  //bits [17..23]
			uint32                        : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved18 : 8;  //bits [24..31]
		};
	};
	union //word12
	{
		uint32 word12;
		struct
		{
			uint32 tcr0Template4 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr0PhyModeTemplate4 : 2;  //bits [0..1], values from PhyModeOld_e
			uint32                      : 30;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                 : 2;
			uint32 tcr0BwTemplate4 : 2;  //bits [2..3], values from Bw_e
			uint32                 : 28;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 4;
			uint32 tcr0RfPowerTemplate4 : 6;  //bits [4..9]
			uint32                      : 22;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                     : 10;
			uint32 tcr0BfModeTemplate4 : 2;  //bits [10..11], values from BfMode_e
			uint32                     : 20;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                               : 12;
			uint32 tcr0AntennaSelectionTemplate4 : 8;  //bits [12..19]
			uint32                               : 12;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                       : 20;
			uint32 tcr0Genrisc0Template4 : 4;  //bits [20..23]
			uint32                       : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved19 : 8;  //bits [24..31]
		};
	};
	union //word13
	{
		uint32 word13;
		struct
		{
			uint32 tcr1Template4 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr1LdpcTemplate4 : 1;  //bit [0]
			uint32                   : 31;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                   : 1;
			uint32 tcr1StbcTemplate4 : 2;  //bits [1..2]
			uint32                   : 29;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                         : 3;
			uint32 tcr1PartialAidTemplate4 : 9;  //bits [3..11]
			uint32                         : 20;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                               : 12;
			uint32 tcr1TxopPsNotAllowedTemplate4 : 1;  //bit [12]
			uint32                               : 19;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 13;
			uint32 tcr1GroupIdTemplate4 : 6;  //bits [13..18]
			uint32                      : 13;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 19;
			uint32 tcr1Reserved0Template4 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                              : 21;
			uint32 tcr1NdpTrainingModeTemplate4 : 1;  //bit [21]
			uint32                              : 10;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                         : 22;
			uint32 tcr1MuTrainingTemplate4 : 1;  //bit [22]
			uint32                         : 9;
		};
		struct
		{
			uint32                       : 23;
			uint32 tcr1MuPhyNdpTemplate4 : 1;  //bit [23]
			uint32                       : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved20 : 8;  //bits [24..31]
		};
	};
	union //word14
	{
		uint32 word14;
		struct
		{
			uint32 tcr2Template4 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr2CddAnt1Template4 : 4;  //bits [0..3]
			uint32                      : 28;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 4;
			uint32 tcr2CddAnt2Template4 : 4;  //bits [4..7]
			uint32                      : 24;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                      : 8;
			uint32 tcr2CddAnt3Template4 : 4;  //bits [8..11]
			uint32                      : 20;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                       : 12;
			uint32 tcr2BwChangeTemplate4 : 1;  //bit [12]
			uint32                       : 19;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 13;
			uint32 tcr2Ant0BoostTemplate4 : 2;  //bits [13..14]
			uint32                        : 17;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 15;
			uint32 tcr2Ant1BoostTemplate4 : 2;  //bits [15..16]
			uint32                        : 15;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 17;
			uint32 tcr2Ant2BoostTemplate4 : 2;  //bits [17..18]
			uint32                        : 13;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 19;
			uint32 tcr2Ant3BoostTemplate4 : 2;  //bits [19..20]
			uint32                        : 11;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                   : 21;
			uint32 genrisc1Template4 : 3;  //bits [21..23]
			uint32                   : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved21 : 8;  //bits [24..31]
		};
	};
	union //word15
	{
		uint32 word15;
		struct
		{
			uint32 tcr3Template4 : 24; //bits [0..23]
			uint32               : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32 tcr3AggregateTemplate4 : 1;  //bit [0]
			uint32                        : 31;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                          : 1;
			uint32 tcr3NotSoundingTemplate4 : 1;  //bit [1]
			uint32                          : 30;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                          : 2;
			uint32 tcr3BfSmoothingTemplate4 : 1;  //bit [2]
			uint32                          : 29;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 3;
			uint32 tcr3DynamicBwTemplate4 : 1;  //bit [3]
			uint32                        : 28;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 4;
			uint32 tcr3Reserved0Template4 : 4;  //bits [4..7]
			uint32                        : 24;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                   : 8;
			uint32 tcr3RateTemplate4 : 6;  //bits [8..13]
			uint32                   : 18;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 14;
			uint32 tcr3Reserved1Template4 : 2;  //bits [14..15]
			uint32                        : 16;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                  : 16;
			uint32 tcr3ScpTemplate4 : 1;  //bit [16]
			uint32                  : 15;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32                        : 17;
			uint32 tcr3Reserved2Template4 : 7;  //bits [17..23]
			uint32                        : 8;
		}; //Used for PHY-NDP HT
		struct
		{
			uint32            : 24;
			uint32 reserved22 : 8;  //bits [24..31]
		};
	};
	union //word16
	{
		uint32 word16;
		struct
		{
			uint32 rfPower20MhzTemplates : 28; //bits [0..27]
			uint32                       : 4;
		};
		struct
		{
			uint32 rfPower20MhzTemplate1 : 6;  //bits [0..5]
			uint32                       : 26;
		};
		struct
		{
			uint32                       : 6;
			uint32 rfPower20MhzTemplate2 : 6;  //bits [6..11]
			uint32                       : 20;
		};
		struct
		{
			uint32                       : 12;
			uint32 rfPower20MhzReserved1 : 4;  //bits [12..15]
			uint32                       : 16;
		};
		struct
		{
			uint32                       : 16;
			uint32 rfPower20MhzTemplate3 : 6;  //bits [16..21]
			uint32                       : 10;
		};
		struct
		{
			uint32                       : 22;
			uint32 rfPower20MhzTemplate4 : 6;  //bits [22..27]
			uint32                       : 4;
		};
		struct
		{
			uint32            : 28;
			uint32 reserved23 : 4;  //bits [28..31]
		};
	};
	union //word17
	{
		uint32 word17;
		struct
		{
			uint32 rfPower40MhzTemplates : 28; //bits [0..27]
			uint32                       : 4;
		};
		struct
		{
			uint32 rfPower40MhzTemplate1 : 6;  //bits [0..5]
			uint32                       : 26;
		};
		struct
		{
			uint32                       : 6;
			uint32 rfPower40MhzTemplate2 : 6;  //bits [6..11]
			uint32                       : 20;
		};
		struct
		{
			uint32                       : 12;
			uint32 rfPower40MhzReserved1 : 4;  //bits [12..15]
			uint32                       : 16;
		};
		struct
		{
			uint32                       : 16;
			uint32 rfPower40MhzTemplate3 : 6;  //bits [16..21]
			uint32                       : 10;
		};
		struct
		{
			uint32                       : 22;
			uint32 rfPower40MhzTemplate4 : 6;  //bits [22..27]
			uint32                       : 4;
		};
		struct
		{
			uint32            : 28;
			uint32 reserved24 : 4;  //bits [28..31]
		};
	};
	union //word18
	{
		uint32 word18;
		struct
		{
			uint32 rfPower80MhzTemplates : 28; //bits [0..27]
			uint32                       : 4;
		};
		struct
		{
			uint32 rfPower80MhzTemplate1 : 6;  //bits [0..5]
			uint32                       : 26;
		};
		struct
		{
			uint32                       : 6;
			uint32 rfPower80MhzTemplate2 : 6;  //bits [6..11]
			uint32                       : 20;
		};
		struct
		{
			uint32                       : 12;
			uint32 rfPower80MhzReserved1 : 4;  //bits [12..15]
			uint32                       : 16;
		};
		struct
		{
			uint32                       : 16;
			uint32 rfPower80MhzTemplate3 : 6;  //bits [16..21]
			uint32                       : 10;
		};
		struct
		{
			uint32                       : 22;
			uint32 rfPower80MhzTemplate4 : 6;  //bits [22..27]
			uint32                       : 4;
		};
		struct
		{
			uint32            : 28;
			uint32 reserved25 : 4;  //bits [28..31]
		};
	};
} VapDbTcrTemplates_t;

typedef struct _VapDbTid_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 currentSequenceNumber : 12; //bits [0..11]
			uint32 reservedTid00         : 4;  //bits [12..15]
			uint32 lowSequenceNumber     : 12; //bits [16..27]
			uint32 reservedTid01         : 4;  //bits [28..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 baEnable                     : 1;  //bit [0]
			uint32 ppduTxMode                   : 2;  //bits [1..2], values from PpduTxMode_e
			uint32 maxPsduTransmissionTimeLimit : 13; //bits [3..15]
			uint32 currentBaWindowLimit         : 6;  //bits [16..21]
			uint32 txopMultipleDataEn           : 1;  //bit [22]
			uint32 reservedTid10                : 9;  //bits [23..31]
		};
	};
} VapDbTid_t;

typedef struct _VapDbBssid_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 macAddress03 : 32; //bits [0..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 macAddress45   : 16; //bits [0..15]
			uint32 aid12          : 12; //bits [16..27]
			uint32 reservedBssid0 : 4;  //bits [28..31]
		};
	};
} VapDbBssid_t;

typedef struct _VapDb_t
{
	VapDbCommon_t       common;
	VapDbTcrTemplates_t tcrTemplates;
	VapDbTid_t          tid[NUM_OF_TIDS];
	VapDbBssid_t        bssid;
} VapDb_t;


#endif //_VAP_DB_H_
