 /***************************************************************
 File:		HwLoggerAPI.h
 Module:	  	HwLogger
 Purpose: 	configures the HwLogger module 
 Description:  This module is the API to the HwLogger module  
***************************************************************/
#ifndef HW_LOGGER_API_H
#define HW_LOGGER_API_H

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "OSAL_Kmsg.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

#define UDP_HEADER_HEADER_CHECKSUM_OFFSET			40
#define UDP_HEADER_LENGTH_OFFSET					16
#define UDP_HEADER_ID_OFFSET						18
#define LOGGER_UM_FIFO_ID							0
#define LOGGER_LM0_FIFO_ID							1
#define LOGGER_LM1_FIFO_ID							23 // according to RegLoggerFifoEnable_u


//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------


//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------



//---------------------------------------------------------------------------------
//						Public Function Declaration				
//---------------------------------------------------------------------------------


void HwLogger_Init(void);
uint32 HwLoggerResourceAllocation(uint32 loggerMaxStreamNum);
void HwLogger_SendFastLog(uint32 FID, uint32 GID, uint32 LID, uint32 exp);
void HwLogger_AddStreamReq(K_MSG *psMsg); 
void HwLogger_RemoveStreamReq(uint16 streamId); 
void HwLogger_AddFifoFilterReq(UMI_ADD_FIFO_FILTER_REQ_t* addFifoFilterReq); 
void HwLogger_RemoveFifoFilterReq(UMI_REMOVE_FIFO_FILTER_REQ_t* removeFifoFilterReq);
void HwLogger_SetHdrTriggerReq(UMI_SET_TRIGGER_REQ_t* setHdrTriggerReq);
void HwLogger_ResetHdrTriggerReq(UMI_RESET_TRIGGER_REQ_t* resetHdrTriggerReq);
void HwLogger_SetPhyHeaderReq(UMI_SET_PHY_HDR_REQ_t* resetHdrTriggerReq);
//void HwLogger_EnablePhyLogs(void);



#endif /* HW_LOGGER_API_H*/

