/************************************************************************************
*
*	File:				HwLoggerPreAggHeMuLog.h
*	Description:		This File was auto generated using Descriptors Excel Parser
*
*						Filename: wave600_B0_logger_msg_ver1.10.6.xlsm
*
*	COPYRIGHT:
*		(C) Intel Israel Ltd.
*		All rights are strictly reserved. Reproduction or divulgence in any
*		form whatsoever is not permitted without written authority from the
*		copyright owner. Issued by Intel Israel Ltd
*
**************************************************************************************/
#ifndef _HW_LOGGER_PRE_AGG_HE_MU_LOG_H_
#define _HW_LOGGER_PRE_AGG_HE_MU_LOG_H_

#include "HwLoggerDescriptorsDefinitions.h"

typedef struct _PreAggHeMuLogCommon_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 loggerTsfStart : 32; //bits [0..31], Logger tsf
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 reportType                          : 2;  //bits [0..1],  0 - SU, 1 - VHT MU, 2 - HE MU
			uint32 phaseType                           : 3;  //bits [2..4], phase type
			uint32 userTcrAValid                       : 1;  //bit [5], user TCR A is valid (TCR A is unicast)
			uint32 userTcrBValid                       : 1;  //bit [6], user TCR b is valid (TCR b is unicast)
			uint32 userRcrValid                        : 1;  //bit [7], user RCR is valid (RCR is unicast)
			uint32 commonTcrAValid                     : 1;  //bit [8], common TCR A is valid
			uint32 commonTcrBValid                     : 1;  //bit [9], common TCR B is valid
			uint32 bcUserTcrAValid                     : 1;  //bit [10], Broadcast user TCR A is valid
			uint32 bcUserTcrBValid                     : 1;  //bit [11], Broadcast user TCR B is valid
			uint32 commonPlanDurationUpdateMode        : 1;  //bit [12], duration mode - 1 - full TXOP, 0 - partial 
			uint32 commonPlanStartBw                   : 2;  //bits [13..14], start BW limit
			uint32 tfMode                              : 2;  //bits [15..16], TF mode
			uint32 phyMode                             : 3;  //bits [17..19], phy mode
			uint32 minimumNumberOfUsersForTransmission : 7;  //bits [20..26], minimum number of users for transmission (under this number TXOP is aborted)
			uint32 stdCommonWrDlDataType               : 2;  //bits [27..28], DL DATA TYPE
			uint32 reserved1                           : 3;  //bits [29..31]
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 aggRxBfRptSnr : 32; //bits [0..31], RX BF report SNR
		};
	};
	union //word3
	{
		uint32 word3;
		struct
		{
			uint32 aggRxBfRptPhyMode  : 2;  //bits [0..1], RX BF report phy mode
			uint32 aggRxBfRptMimoNc   : 2;  //bits [2..3], RX BF report MIMO
			uint32 aggRxBfRptMfbValid : 1;  //bit [4], RX BF report MFB valid
			uint32 aggRxBfRptMfb      : 7;  //bits [5..11], RX BF report MFB valid
			uint32 aggOtfMode         : 1;  //bit [12], On The Fly mode indication
		};
	};
	union //word4
	{
		uint32 word4;
		struct
		{
			uint32 aggOtfModeChange              : 1;  //bit [13], On The Fly mode changed from activtion to reactivation
			uint32 otfaPreAggCantBuild           : 1;  //bit [14], OTFA cant build indication
			uint32 reserved4                     : 10; //bits [15..24]
			uint32 aggSeqReactLessMinTimer       : 1;  //bit [25], pre agg to sequecer less then min time error indication in reactivation
			uint32 aggSeqReactUspPrimaryDrop     : 1;  //bit [26], pre agg to sequecer primary user dropped error indication in reactivation
			uint32 aggSeqReactMuPrimaryNotDataPd : 1;  //bit [27], pre agg to sequecer vht mu primary not data error indication in reactivation
			uint32 aggSeqReactRequiredRaFiller   : 1;  //bit [29], pre agg to sequecer required RA filler indication in reactivation
			uint32 aggSeqReactConstructError     : 1;  //bit [30], pre agg to sequecer construction  error indication in reactivation
			uint32 seqAggReactBfRptValidSmp      : 1;  //bit [31], sequencer to pre agg BF report valid latched
		};
	};
	union //word5
	{
		uint32 word5;
		struct
		{
			uint32 reserved5                       : 24; //bits [0..23]
			uint32 txselSeqUsp0SecondaryNoTxReason : 4;  //bits [24..27], reason that selectore didn't choose user0 secondary station
			uint32 txselSeqUsp1SecondaryNoTxReason : 4;  //bits [28..31], reason that selectore didn't choose user1 secondary station
		};
	};
	union //word6
	{
		uint32 word6;
		struct
		{
			uint32 reserved6                       : 24; //bits [0..23]
			uint32 txselSeqUsp2SecondaryNoTxReason : 4;  //bits [24..27], reason that selectore didn't choose user0 secondary station
			uint32 txselSeqUsp3SecondaryNoTxReason : 4;  //bits [28..31], reason that selectore didn't choose user1 secondary station
		};
	};
	union //word7
	{
		uint32 word7;
		struct
		{
			uint32 aggSeqReactBfRptNssModified : 1;  //bit [0], 1b AGG to Sequencer Nss modified due to BF report
			uint32 aggSeqReactBfRptMcsModified : 1;  //bit [1], 1b AGG to Sequencer MCS modified due to BF report
			uint32 finalBw                     : 2;  //bits [2..3], final bw to be written to TCR/STD
			uint32 tcrRate                     : 8;  //bits [4..11], TCR rate
			uint32 psduDurLimit                : 18; //bits [12..29], tx sequence air time duration limit
			uint32 reserved7                   : 2;  //bits [30..31]
		};
	};
	union //word8
	{
		uint32 word8;
		struct
		{
			uint32 stdPlannedFlow        : 16; //bits [0..15], planned flow bits written to STD
			uint32 minOmiBw              : 2;  //bits [16..17], minmum omi bw of all users
			uint32 minOmiNss             : 3;  //bits [18..20], minimum omi nss of all users
			uint32 maxBwLimitVapId       : 2;  //bits [21..22], maximum vap bw for all users
			uint32 bwBasedCcaLimitMux    : 2;  //bits [23..24], start bw limit input to CCA 
			uint32 txStickyCca20SFree    : 1;  //bit [25]
			uint32 txStickyCca40SFree    : 1;  //bit [26]
			uint32 txStickyCca80SFree    : 1;  //bit [27]
			uint32 txStickyCca20SPwrFree : 1;  //bit [28]
			uint32 reserved8             : 3;  //bits [29..31]
		};
	};
	union //word9
	{
		uint32 word9;
		struct
		{
			uint32 txopCanceledStatusBus : 13; //bits [0..12], [0] no users valid from selector	[1] prev user for primary user not locked	 [2] prev TID for ptimary tid not locked	[3] first PD pointer Null	[4] sequencer drop primary user	[5] reactivation and primary PD not data	[6] TXOP aborted due to OTF mode change	[7] primary user empty selection	 [8] bf_rpt_analyzer_required_ra_filler	[9] OTFA can't build	[10] empty plan	[11] empty phase	[12] he minimum user threshold
			uint32 reserved9             : 19; //bits [13..31]
		};
	};
	union //word10
	{
		uint32 word10;
		struct
		{
			uint32 loggerTsfEnd : 32; //bits [0..31], Logger tsf
		};
	};
	union //word11
	{
		uint32 word11;
		struct
		{
			uint32 sequencerTransactionNumber : 8;  //bits [0..7], sequencer transaction number
			uint32 preAggTransactionId        : 8;  //bits [8..15], pre agg transaction number
			uint32 rptTxopType                : 2;  //bits [16..17], TXOP type
			uint32 preAggOperationMode        : 1;  //bit [18],  0 - activation, 1 - reactivation
			uint32 groupPlanId                : 7;  //bits [19..25], group/plan id
			uint32 rptPhaseType               : 3;  //bits [26..28]
			uint32 skipPhaseInd               : 1;  //bit [29], 0 - skip phase did not occur, 1 - skip phase occurred
			uint32 rptReserve11               : 2;  //bits [30..31]
		};
	};
	union //word12
	{
		uint32 word12;
		struct
		{
			uint32 rptPhaseIndx                    : 4;  //bits [0..3], phase index
			uint32 txopCanceledReason              : 3;  //bits [4..6], [0] no users valid from selector	[1] prev user for primary user not locked	 [2] prev TID for ptimary tid not locked	[3] first PD pointer Null	[4] sequencer drop primary user	[5] reactivation and primary PD not data	[6] TXOP aborted due to OTF mode change	[7] primary user empty selection	 [8] bf_rpt_analyzer_required_ra_filler	[9] OTFA can't build	[10] empty plan	[11] empty phase	[12] he minimum user threshold
			uint32 rptBwValue                      : 2;  //bits [7..8], BW value
			uint32 bwChangeInActivation            : 1;  //bit [9], bw changed in activation
			uint32 bcTfBwReduceByOmi               : 1;  //bit [10], broadcast TF BW reduced by OMI
			uint32 finalValidUserBitmapUser20User0 : 21; //bits [11..31], final valid users for user20-user0
		};
	};
	union //word13
	{
		uint32 word13;
		struct
		{
			uint32 finalValidUserBitmapUser35User22  : 14; //bits [0..13], final valid users for user35-user21
			uint32 primaryUserId                     : 2;  //bits [15..16], primary user id
			uint32 vhtMuTxopCanceledReason           : 5;  //bits [17..21], [0] - primary pd null	[1] - seq primary user dopped	[2] - primary pd management in reactivation	[3] - empty selection for primary in reactivation	[4] - prev user was not locked in reactivation 
			uint32 mainTxTcrBroadcastInd             : 1;  //bit [22], indication that the main tx TCR is broadcast
			uint32 mainTxTcrBroadcastBw              : 2;  //bits [23..24], main tx tcr bw, valid only if main_tx_tcr_broadcast_ind is high
			uint32 mainTxTcrBroadcastNss             : 3;  //bits [25..27], main tx tcr nss, valid only if main_tx_tcr_broadcast_ind is high
			uint32 mainTxTcrBroadcastNssChangeReason : 3;  //bits [28..30], main tx tcr nss change reason. Valid only if main_tx_tcr_broadcast_ind is high	all zeros  no change	bit[0]  update by OMI NSS	bit[1] force 1 NSS	bit[2] configuration
			uint32 rptReserve13                      : 1;  //bit [31]
		};
	};
} PreAggHeMuLogCommon_t;

typedef struct _PreAggHeMuLogUser_t
{
	union //word0
	{
		uint32 word0;
		struct
		{
			uint32 preAggTransactionNumber   : 8;  //bits [0..7]
			uint32 txUserId                  : 7;  //bits [8..14]
			uint32 txQStaId                  : 9;  //bits [15..23]
			uint32 uspSecondarayNotSelReason : 4;  //bits [24..27]
			uint32 reserve0                  : 4;  //bits [28..31]
		};
	};
	union //word1
	{
		uint32 word1;
		struct
		{
			uint32 selectorRemoveUserCause : 16; //bits [0..15], all zeros  user not removed	bit[0]  STA doesnt support HE MU	bit[1]  STA Not Available (TWT Availability)	bit[2]  TOMI UL TF Disabled	bit[3]  TOMI DL TF Disabled	bit[4]  All TIDs are locked	bit[5]  STA in PS (no PS Req)	bit[6]  No Data in Q	bit[7]  DL MIMO all PS Legacy Request  in case all the TIDs of MIMO user are with Legacy PS Request	bit[8]  DL MIMO TID Management is not allowed   in case user have only Management TID and configuration doesnt allow to transmit Management in MIMO	bit[9]  HE MU  No Buffer Status ind (No Data in UL Q) (bits[15:10] are reseved)
			uint32 preAggRemoveUserCause   : 7;  //bits [16..22], all zeros   user not removed	bit[0]  Removed by CCA / Configuration	bit[1]  OMI BW (STA out of OMI BW)  changed to Dummy User	bit[2] STA MIMO Mode and BW reduced by OMI (therefore STA Removed)	bit[3 DL Data and no previous mapping	bit[4] AGG  Max NSTS reached	bit[5] user was dummy at input	bit[6] - user removed since it was not active at first activation
			uint32 selectedTids            : 9;  //bits [23..31], selected tids bitmap
		};
	};
	union //word2
	{
		uint32 word2;
		struct
		{
			uint32 dlRuSize       : 3;  //bits [0..2]
			uint32 dlRuUpdtCause  : 2;  //bits [3..4], all zeros  not changed	bit[0]  update by CCA	bit[1]- update by OMI (for RU>20MHz)
			uint32 ulRuSize       : 3;  //bits [5..7]
			uint32 ulRuUpdtCasue  : 3;  //bits [8..10], all zeros no change	bit[0]  update by CCA	bit[1]- update by OMI (for RU>20MHz)	bit[2]  update by MIMO
			uint32 dlNss          : 3;  //bits [11..13]
			uint32 dlNssUpdtCause : 4;  //bits [14..17], all zeros  no change	bit[0]  update by OMI NSS	bit[1] force 1 NSS	bit[2] configuration	bit[3]   MIMO mode reduce NSS due to other user
			uint32 ulNss          : 3;  //bits [18..20]
			uint32 ulNssUpdtCause : 3;  //bits [21..23], all zeros  no change	bit[0]  update by OMI NSS	bit[1] force 1 NSS	bit[2] configuration
			uint32 ulMcs          : 4;  //bits [24..27]
			uint32 ulMcsUpdtCause : 1;  //bit [28], 0 - no change 1 - BW reduce in DL MIMO
			uint32 reserve2       : 3;  //bits [29..31]
		};
	};
} PreAggHeMuLogUser_t;

typedef struct _PreAggHeMuLog_t
{
	PreAggHeMuLogCommon_t common;
	PreAggHeMuLogUser_t   user;
} PreAggHeMuLog_t;

#endif //_HW_LOGGER_PRE_AGG_HE_MU_LOG_H_
