/***********************************************************************************
 File:			HwLogDefs_Activity.h
 Module:		HwLogDefs 
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_LOG_DEFS_ACTIVITY_H_
#define HW_LOG_DEFS_ACTIVITY_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"

typedef struct _ActivityLogEntry_t
{
	uint32 pac_phy_tx_phy_enable           : 1; // [ 0] Tx enable - MAC to Phy
	uint32 phy_pac_tx_phy_ready            : 1; // [ 1] Tx ready - Phy to MAC
	uint32 phy_mac_cca_20p_free            : 1; // [ 2] CCA 20MHz primary is free
	uint32 phy_mac_cca_20s_free            : 1; // [ 3] CCA 20MHz secondary is free
	uint32 phy_mac_cca_40s_free            : 1; // [ 4] CCA 40MHz secondary is free
	uint32 phy_mac_cca_20p_pwr_free        : 1; // [ 5] CCA 20MHz primary (detector-based) is free
	uint32 phy_mac_cca_20s_pwr_free        : 1; // [ 6] CCA 20MHz secondary (detector-based) is free
	uint32 phy_mac_cca_40s_pwr_free        : 1; // [ 7] CCA 40MHz secondary (detector-based) is free
	uint32 phy_pac_rx_phy_ready            : 1; // [ 8] Rx ready - Phy to MAC
	uint32 act_log_ex_err                  : 1; // [ 9] Phy Rx error indication - Phy to MAC
	uint32 act_log_rx_abort                : 1; // [10] Rx abort request - MAC to Phy
	uint32 del_rx_in_halt                  : 1; // [11] Delineator is halted
	uint32 pd_thres_reached                : 1; // [12] Tx descriptors free list below water level
	uint32 rd_thres_reached                : 1; // [13] Rx descriptors free list below water level
	uint32 tx_in_core_busy                 : 1; // [14] Host I/F accelerator busy (bit per direction)
	uint32 tx_out_core_busy                : 1; // [15] Host I/F accelerator busy (bit per direction)
	uint32 rx_in_core_busy                 : 1; // [16] Host I/F accelerator busy (bit per direction)
	uint32 rx_out_core_busy                : 1; // [17] Host I/F accelerator busy (bit per direction)
	uint32 dma_ch0_active                  : 1; // [18] DMA channel0 (tx)is active
	uint32 dma_ch1_active                  : 1; // [19] DMA channel1 (rx)is active
	uint32 dma_ch2_active                  : 1; // [20] DMA channel2 (host if)is active
	uint32 dma_ch3_active                  : 1; // [21] DMA channel3 (FW) is active
	uint32 reserved1                       : 1; // [22] unused
	uint32 agg_builder_active              : 1; // [23] Aggregator active
	uint32 txh_map_in_freeze_beacon        : 1; // [24] Beacon is being transmitted
	uint32 txh_ntd_fdc_auto_resp_tx_active : 1; // [25] Auto reply is being transmitted
	uint32 txh_map_in_freeze               : 1; // [26] Tx Handler freeze indication
	uint32 txh_tx_req_vap_ac               : 1; // [27] OR on the entire bits of Tx handler Tx request matrix (i.e. there is at least one {AC, VAP} to be transmitted)
	uint32 rx_sec_desc_done_acc_non_empty  : 1; // [28] Rx Security descriptor done accumulator not empty
	uint32 rx_clas_rxc_buf_in_ptr_change   : 1; // [29] Rx Classifier out pointer is different than RXC in pointer
	uint32 rx_clas_rxh_avail_pending_rtd   : 1; // [30] Rx Classifier pending RTD is available
	uint32 rx_clas_available_free_rtd      : 1; // [31] Rx Classifier free RTD is available
	
	uint32 rx_clas_available_free_sec_desc : 1; // [32] Rx Classifier free Security descriptor is available
	uint32 txc_rx_nav_zero                 : 1; // [33] Rx NAV is zero
	uint32 txc_tx_nav_zero                 : 1; // [34] Tx NAV is zero
	uint32 txc_medium_busy_indication      : 1; // [35] medium busy
	uint32 dma_wrap_fifo0_full             : 1; // [36] FIFO of DMA wrapper channel0 is full
	uint32 dma_wrap_fifo1_full             : 1; // [37] FIFO of DMA wrapper channel1 is full
	uint32 dma_wrap_fifo2_full             : 1; // [38] FIFO of DMA wrapper channel2 is full
	uint32 dma_wrap_fifo3_full             : 1; // [39] FIFO of DMA wrapper channel3 is full
	uint32 act_log_sw_stb0                 : 1; // [40] SW logger write [0] latched
	uint32 act_log_sw_stb1                 : 1; // [41] SW logger write [1] latched
	uint32 act_log_sw_stb2                 : 1; // [42] SW logger write [2] latched
	uint32 act_log_sw_stb3                 : 1; // [43] SW logger write [3] latched
	uint32 act_log_sw_stb4                 : 1; // [44] SW logger write [4] latched
	uint32 act_log_sw_stb5                 : 1; // [45] SW logger write [5] latched
	uint32 act_log_sw_stb6                 : 1; // [46] SW logger write [6] latched
	uint32 act_log_sw_stb7                 : 1; // [47] SW logger write [7] latched
	uint32 pac_phy_tx_txop_sequence        : 1; // [48] MAC to Phy: TXOP sequence in progress
	uint32 tx_wep_flow_cntrl_req_pending   : 1; // [49] Tx encryption flow control is active
	uint32 tx_del_flow_cntrl_req_pending   : 1; // [50] Tx Delia flow control is active
	uint32 rx_dma_flow_cntrl_req_pending   : 1; // [51] Rx DMA flow control is active
	uint32 hif_tx_in_pending_jobs_full     : 1; // [52] Host I/F TxIn pending jobs count is full
	uint32 hif_tx_out_pending_jobs_full    : 1; // [53] Host I/F TxIn pending jobs count is full
	uint32 hif_rx_in_pending_jobs_full     : 1; // [54] Host I/F TxIn pending jobs count is full
	uint32 hif_rx_out_pending_jobs_full    : 1; // [55] Host I/F TxIn pending jobs count is full
	uint32 reserved2                       : 8; // [63:56] unused

} ActivityLogEntry_t;

typedef struct _ActivityLog_t
{
	ActivityLogEntry_t activityLogArray[52];
} ActivityLog_t;
	
#endif //HW_LOG_DEFS_ACTIVITY_H_