/***********************************************************************************
 File:			HwLoggerAggregationBuilderLogDefs.h
 Module:		HwLogDefs 
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_LOGGER_AGGREGATION_BUILDER_LOG_DEFS_H_
#define HW_LOGGER_AGGREGATION_BUILDER_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "Std.h"


typedef struct AggregationBuilderFirstCommonSectionLog
{

	uint32 startTimestampLow                   : 9;  /* uSec prescaler, resolution of cycles */
	uint32 startTimestampHigh                  : 23; /* TSF [22:0], resolution of uSec */

	uint32 primaryUserPositionPdtype           : 4;
	uint32 multiUser    				       : 1;
	uint32 switchFromMuToSu      			   : 1;
	uint32 suBfTrainingOnly      			   : 1;
	uint32 muGroupBfTrainingOnly      		   : 1;
	uint32 primaryUspIndex     			       : 2;
	uint32 reactivation     			       : 1;
	uint32 pdFirstPointerEqualsToNullBitmap    : 4;
	uint32 txSelectorUspValidBitmap			   : 4;
	uint32 reserved      			           : 13;
} AggregationBuilderFirstCommonSectionLog_t;


typedef struct AggregationBuilderSecondCommonSectionLog
{
	/* The last word of the STD common section is not included in the aggregation builder logs
   	   so the structure of the STD common section cannot be used here */
	uint32 muGroupTxMode                   														:2;
	uint32 muTxMultipleUserTraining        														:1;
	uint32 multipleDataTx 		           														:1;
	uint32 multipleMuDataBaPolicy 	       														:1;
	uint32 nextBa		                   														:2;
	uint32 nextBfReportStationNumber       														:4;
	uint32 activeUspBitmap		           														:4;
	uint32 reserved1 		               														:1;
	uint32 stdStatus 		               														:9;
	uint32 error 		                   														:1;
	uint32 bfIteration 		               														:2;
	uint32 ownerLmac 		               														:1;
	uint32 ownerSequencer 		           														:1;
	uint32 ownerSender 		               														:1;
	uint32 muMimoStd 		               														:1;

	uint32 plannedTrainingFiller           														:1;
	uint32 plannedBar                      														:1;
	uint32 plannedData                     														:1;
	uint32 plannedBfPoll3                  														:1;
	uint32 plannedBfPoll2		           														:1;
	uint32 plannedBfPoll1		           														:1;
	uint32 plannedBfReport0		           														:1;
	uint32 plannedBfRequest                														:1;
	uint32 plannedFiller                   														:1;
	uint32 reserved2                       														:3;
	uint32 plannedRtsCts                   														:1;
	uint32 plannedCtsToSelf                														:1;
	uint32 plannedCfEnd	                   														:1;
	uint32 reserved3			           														:17;

	uint32 executedTrainingFiller          														:1;
	uint32 executedBar                     														:1;
	uint32 executedData		               														:1;
	uint32 executedBfPoll3                 														:1;
	uint32 executedBfPoll2		           														:1;
	uint32 executedBfPoll1		           														:1;
	uint32 executedBfReport0	           														:1;
	uint32 executedBfRequest               														:1;
	uint32 executedFiller                  														:1;
	uint32 reserved4			           														:3;
	uint32 executedRtsCts          	       														:1;
	uint32 executedCtsToSelf               														:1;
	uint32 executedCfEnd 	               														:1;
	uint32 reserved5			           														:17;

	uint32 protectedIndication			   														:2;
	uint32 rtsCtsFormatIndication          														:2;
	uint32 bfTxSequence			           														:2;
	uint32 fillerCause			           														:2;
	uint32 fillerType                      														:2;
	uint32 reserved6			           														:2;
	uint32 groupAltRateReasonFastProbing   														:1;
	uint32 groupAltRateReasonSlowProbing   														:1;
	uint32 hwGroupEntry			           														:7;
	uint32 pdType			               														:4;
	uint32 dataQosIndication			  													    :1;
	uint32 primaryUsp			           														:2;
	uint32 useImmediateBa			       														:4;

	uint32 uspLockedBitmap			       														:4;
	uint32 groupLocked		               														:1;
	uint32 aggUspLockedBitmap			   														:4;
	uint32 bfReportRxIndication			   														:2;
	uint32 numberOfActiveUsps			  													    :2;
	uint32 reserved7			           														:19;
	
	uint32 bfReportSnr; 
	
	uint32 bfReportVht 																			:1;
	uint32 bfReportMimoNc 																		:2;
	uint32 bfReportMfbValid 																	:1;
	uint32 bfReportMfb 																			:7;
	uint32 reserved8 																			:14;
	uint32 reactivationOperatioLessThanMinimumTime 												:1;
	uint32 reactivationPrimaryUspIndicatesAsDrop 												:1;
	uint32 reactivationMuPrimaryUspFirstPdNotData 												:1;
	uint32 requiredRaFillerDueToBfReportParameters 												:1;
	uint32 reactivationNotDataPsduSizeExceedLimit 												:1;
	uint32 reserved9																		    :1;
	uint32 considerBfReportParameters 															:1;

	uint32 usp0StopPsduDataReasonAmsduCounter 													:1;
	uint32 usp0StopPsduDataReasonMsduSize													    :1;
	uint32 usp0StopPsduDataReasonMpduSizeBasedOnDb												:1;
	uint32 usp0StopPsduDataReasonMpduSizeBasedOnConfigurationPerPhyMode						    :1;
	uint32 usp0StopPsduDataReasonPsduSize 														:1;
	uint32 usp0StopPsduDataReasonPsduSizeEstimated 												:1;
	uint32 usp0StopPsduDataReasonPsduSizeSecondaryWhenPrimaryEnd 								:1;
	uint32 usp0StopPsduDataReasonNotRetriesMpdusCountLimit 										:1;
	uint32 usp0StopPsduDataReasonMpdusCount 													:1;
	uint32 usp0StopPsduDataReasonNextPdNotData 													:1;
	uint32 usp0StopPsduDataReasonZeroTimerOrTxhOrSequencerAbort 								:1;
	uint32 usp0StopPsduDataReasonPdPointsToNull 												:1;
	uint32 usp1StopPsduDataReasonAmsduCounter 													:1;
	uint32 usp1StopPsduDataReasonMsduSize 														:1;
	uint32 usp1StopPsduDataReasonMpduSizeBasedOnDb 												:1;
	uint32 usp1StopPsduDataReasonMpduSizeBasedOnConfigurationPerPhyMode 						:1;
	uint32 usp1StopPsduDataReasonPsduSize 														:1;
	uint32 usp1StopPsduDataReasonPsduSizeEstimated 												:1;
	uint32 usp1StopPsduDataReasonPsduSizeSecondaryWhenPrimaryEnd 								:1;
	uint32 usp1StopPsduDataReasonNotRetriesMpdusCountLimit 										:1;
	uint32 usp1StopPsduDataReasonMpdusCount 													:1;
	uint32 usp1StopPsduDataReasonNextPdNotData 													:1;
	uint32 usp1StopPsduDataReasonZeroTimerOrTxhOrSequencerAbort								    :1;
	uint32 usp1StopPsduDataReasonPdPointsToNull 												:1;
	uint32 usp0SecondaryNoTxReason  															:4;
	uint32 usp1SecondaryNoTxReason																:4;

	uint32 usp2StopPsduDataReasonAmsduCounter 													:1;
	uint32 usp2StopPsduDataReasonMsduSize 														:1;
	uint32 usp2StopPsduDataReasonMpduSizeBasedOnDb 												:1;
	uint32 usp2StopPsduDataReasonMpduSizeBasedOnConfigurationPerPhyMode 						:1;
	uint32 usp2StopPsduDataReasonPsduSize 														:1;
	uint32 usp2StopPsduDataReasonPsduSizeEstimated 												:1;
	uint32 usp2StopPsduDataReasonPsduSizeSecondaryWhenPrimaryEnd 								:1;
	uint32 usp2StopPsduDataReasonNotRetriesMpdusCountLimit									    :1;
	uint32 usp2StopPsduDataReasonMpdusCount 													:1;
	uint32 usp2StopPsduDataReasonNextPdNotData 													:1;
	uint32 usp2StopPsduDataReasonZeroTimerOrTxhOrSequencerAbort 								:1;
	uint32 usp2StopPsduDataReasonPdPointsToNull 												:1;
	uint32 usp3StopPsduDataReasonAmsduCounter 													:1;
	uint32 usp3StopPsduDataReasonMsduSize 														:1;
	uint32 usp3StopPsduDataReasonMpduSizeBasedOnDb 												:1;
	uint32 usp3StopPsduDataReasonMpduSizeBasedOnConfigurationPerPhyMode 						:1;
	uint32 usp3StopPsduDataReasonPsduSize 														:1;
	uint32 usp3StopPsduDataReasonPsduSizeEstimated 												:1;
	uint32 usp3StopPsduDataReasonPsduSizeSecondaryWhenPrimaryEnd 								:1;
	uint32 usp3StopPsduDataReasonNotRetriesMpdusCountLimit 										:1;
	uint32 usp3StopPsduDataReasonMpdusCount 													:1;
	uint32 usp3StopPsduDataReasonNextPdNotData 													:1;
	uint32 usp3StopPsduDataReasonZeroTimerOrTxhOrSequencerAbort 								:1;
	uint32 usp3StopPsduDataReasonPdPointsToNull 												:1;
	uint32 usp2SecondaryNoTxReason  															:4;
	uint32 usp3SecondaryNoTxReason																:4;

	uint32 ups0ErrorStatusFirstDataPdExceedsMaximumMsduLimitation  								:1;
	uint32 ups0ErrorStatusFirstDataPdExceedsMaximumMsduByteLengthLimitation  					:1;
	uint32 ups0ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthDatabaseLimitation  			:1;
	uint32 ups0ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthLimitation  					:1;
	uint32 ups0ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthAccordingToRate  				:1;
	uint32 ups0ErrorStatusFirstDataPdIsNotRetransmissionButWindowIsFull  						:1;
	uint32 ups0ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthPhyLimitation  				:1;
	uint32 ups0ErrorStatusFirstDataPdExceedsPsduByteLengthLimitationOnSecondatWhilePrimaryEnd   :1;
	uint32 ups1ErrorStatusFirstDataPdExceedsMaximumMsduLimitation  								:1;
	uint32 ups1ErrorStatusFirstDataPdExceedsMaximumMsduByteLengthLimitation  					:1;
	uint32 ups1ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthDatabaseLimitation  			:1;
	uint32 ups1ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthLimitation  					:1;
	uint32 ups1ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthAccordingToRate  				:1;
	uint32 ups1ErrorStatusFirstDataPdIsNotRetransmissionButWindowIsFull 						:1;
	uint32 ups1ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthPhyLimitation  				:1;
	uint32 ups1ErrorStatusFirstDataPdExceedsPsduByteLengthLimitationOnSecondatWhilePrimaryEnd   :1;
	uint32 ups2ErrorStatusFirstDataPdExceedsMaximumMsduLimitation  								:1;
	uint32 ups2ErrorStatusFirstDataPdExceedsMaximumMsduByteLengthLimitation  					:1;
	uint32 ups2ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthDatabaseLimitation  			:1;
	uint32 ups2ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthLimitation 					:1;
	uint32 ups2ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthAccordingToRate  				:1;
	uint32 ups2ErrorStatusFirstDataPdIsNotRetransmissionButWindowIsFull  						:1;
	uint32 ups2ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthPhyLimitation					:1;
	uint32 ups2ErrorStatusFirstDataPdExceedsPsduByteLengthLimitationOnSecondatWhilePrimaryEnd   :1;
	uint32 ups3ErrorStatusFirstDataPdExceedsMaximumMsduLimitation  								:1;
	uint32 ups3ErrorStatusFirstDataPdExceedsMaximumMsduByteLengthLimitation  					:1;
	uint32 ups3ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthDatabaseLimitation  			:1;
	uint32 ups3ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthLimitation  					:1;
	uint32 ups3ErrorStatusFirstDataPdExceedsMaximumPsduByteLengthAccordingToRate  				:1;
	uint32 ups3ErrorStatusFirstDataPdIsNotRetransmissionButWindowIsFull  						:1;
	uint32 ups3ErrorStatusFirstDataPdExceedsMaximumMpduByteLengthPhyLimitation					:1;
	uint32 ups3ErrorStatusFirstDataPdExceedsPsduByteLengthLimitationOnSecondatWhilePrimaryEnd   :1;

	uint32 nssModifiedDueToBfReportParameters  													:1;
	uint32 mcsModifiedDueToBfReportParameters 												    :1;
	uint32 bw  																					:2;
	uint32 rateOfPrimaryUsp  																	:6;
	uint32 totalTxDurationAirTimeOrReactivationPsduAirTimeLimitBasedTxNavTimer  				:18;
	uint32 cca20MhzSecondaryFree																:1;
	uint32 cca40MhzSecondaryFree																:1;
	uint32 cca80MhzSecondaryFree																:1;
	uint32 cca160MhzSecondaryFree																:1;

	uint32 usp0NumberOfDataPds																	:16;
	uint32 usp1NumberOfDataPds																	:16;

	uint32 usp2NumberOfDataPds																	:16;
	uint32 usp3NumberOfDataPds																	:16;

	uint32 endTimestampLow																		:9;  /* uSec prescaler, resolution of cycles */
	uint32 endTimestampHigh																		:23; /* TSF [22:0], resolution of uSec */
} AggregationBuilderSecondCommonSectionLog_t;


typedef struct AggregationBuilderNoneDataLog
{
	AggregationBuilderFirstCommonSectionLog_t firstCommonSection;
	StdUserZoneC_t stdNoneDataTransmissionMpduParameters;
	StdUserZoneB_t stdSingleUserSection;
	AggregationBuilderSecondCommonSectionLog_t secondCommonSection;
} AggregationBuilderNoneDataLog_t;

typedef struct AggregationBuilderDataSingleUserLog
{
	AggregationBuilderFirstCommonSectionLog_t firstCommonSection;
	StdUserZoneB_t stdSingleUserSection;
	AggregationBuilderSecondCommonSectionLog_t secondCommonSection;
} AggregationBuilderDataSingleUserLog_t;

typedef struct AggregationBuilderDataMultiUser2StationsLog
{
	AggregationBuilderFirstCommonSectionLog_t firstCommonSection;
	StdUserZoneB_t stdUserPositionSection[2];
	AggregationBuilderSecondCommonSectionLog_t secondCommonSection;
} AggregationBuilderDataMultiUser2StationsLog_t;

typedef struct AggregationBuilderDataMultiUser3StationsLog
{
	AggregationBuilderFirstCommonSectionLog_t firstCommonSection;
	StdUserZoneB_t stdUserPositionSection[3];
	AggregationBuilderSecondCommonSectionLog_t secondCommonSection;
} AggregationBuilderDataMultiUser3StationsLog_t;

typedef struct AggregationBuilderDataMultiUser4StationsLog
{
	AggregationBuilderFirstCommonSectionLog_t firstCommonSection;
	StdUserZoneB_t stdUserPositionSection[4];
	AggregationBuilderSecondCommonSectionLog_t secondCommonSection;
} AggregationBuilderDataMultiUser4StationsLog_t;


typedef union AggregationBuilderPossibleLogs
{
	AggregationBuilderDataSingleUserLog_t			aggregationBuilderDataSingleUserLog;
	AggregationBuilderNoneDataLog_t					aggregationBuilderNoneDataLog;
	AggregationBuilderDataMultiUser2StationsLog_t	aggregationBuilderDataMultiUser2StationsLog;
	AggregationBuilderDataMultiUser3StationsLog_t	aggregationBuilderDataMultiUser3StationsLog;
	AggregationBuilderDataMultiUser4StationsLog_t	aggregationBuilderDataMultiUser4StationsLog;
} AggregationBuilderPossibleLogs_u;

typedef struct AggregationBuilderLog
{
	AggregationBuilderPossibleLogs_u aggregationBuilderLog;
} AggregationBuilderLog_t;
	

#endif /* ifdef HW_LOGGER_AGGREGATION_BUILDER_LOG_DEFS_H_ */
