/***********************************************************************************
 File:			HwLoggerBeaconLogDefs.h
 Module:		Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the HW beacon
 				logs
************************************************************************************/
#ifndef HW_LOGGER_BEACON_LOG_DEFS_H_
#define HW_LOGGER_BEACON_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct HwBeaconLog
{
	uint32 beaconActivation           : 1;
	uint32 beaconRequestPulse         : 1;
	uint32 lcm                        : 16;
	uint32 activatedPulseBusLow       : 14;

	uint32 activatedPulseBusHigh 	  : 2;
	uint32 activatedBeaconOffset 	  : 16;
	uint32 vapActiveStatusLow	      : 14;

	uint32 vapActiveStatusHigh		  : 2;
	uint32 beaconPendingRequestBus    : 16;
	uint32 reserved                   : 14;
} HwBeaconLog_t;


#endif /* HW_LOGGER_BEACON_LOG_DEFS_H_ */

