/***********************************************************************************
 File:			HwLoggerBeamformingLogDefs.h
 Module:			Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Beamforming logs
************************************************************************************/
#ifndef HW_LOGGER_BEAMFORMING_LOG_DEFS_H_
#define HW_LOGGER_BEAMFORMING_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------


typedef struct BeamformingRxNdpaLog
{	
	/* word 1 */
	//uint32 MessageHeader_31_0			:32;				// [31:0] Message Header
	/* word 2 */
	//uint32 MessageHeader_63_32		:32;				// [31:0] Message Header[63:32] 	
	/* word 3 */
	//uint32 MessageHeader_95_64		:32;				// [31:0] Message Header[95:64]
	/* word 4 */
	uint32 StaIndex						:7;					// [6:0] STA index [6:0]	
	uint32 staDbBfDbValid				:1;					// [7] STA DB BF DB valid. Copied at the start operation of the BF module	 
	uint32 staDbBfDbAging				:1;					// [8] STA DB BF DB aging status. Copied at the start operation of the BF module 
	uint32 StaDbTxMaxNSS				:2;					// [10:9] STA DB Tx Max Nss[1:0] 
	uint32 StaDbBfMode					:3;					// [13:11] STA DB BF mode[2:0] 
	uint32 StaDbMinimalGrouping			:2;					// [15:14] STA DB minimal grouping[1:0] 
	uint32 RxVhtNdpaMulticast			:1;					// [16] Rx VHT NDPA multicast 
	uint32 RxVhtNdpaUnicast				:1;					// [17] Rx VHT NDPA unicast 
	uint32 RxHtNdpa						:1;					// [18] Rx HT NDPA 
	uint32 TxSelectorStaVapValidResults :1;					// [19] Tx Selector STA-VAP valid result. Relevant in case of Rx VHT NDPA multicast 
	uint32 BFeeGoodNdpa					:1;					// [20] BFee good NDPA 
	uint32 BFeeReportResponseDelayed	:1;					// [21] BFee report response delayed 
	uint32 PhyPacRxMuNdp				:1;					// [22] PHY-PAC Rx MU NDP 
	uint32 PhyPacRxMaxSupportedTxNSS	:2;					// [24:23] PHY-PAC Rx max supported Tx Nss[1:0] 
	uint32 VapIndex						:4;					// [28:25] VAP index[3:0] 
	uint32 reserved						:3;					// [31:29] reserved
	
}BeamformingRxNdpaLog_t;

typedef struct BeamformingRxPhyNdpLog
{
	/* word 1 */
	//uint32 messageHeader_31_0					:32;		// [31:0] Message Header[31:0] 
	/* word 2 */	
	//uint32 messageHeader_63_32				:32;		// [31:0] Message Header[63:32] 
	/* word 3 */
	//uint32 messageHeader_95_64				:32;		// [31:0] Message Header[95:64] 
	/* word 4 */
	uint32 staIndex								:7;			// [6:0] STA index[6:0] 
	uint32 staDbBfDbValid						:1;			// [7] STA DB BF DB valid. Read during the Rx NDPA 
	uint32 staDbBfDbAgingStatus					:1;			// [8] STA DB BF DB aging status. Read during the Rx NDPA 
	uint32 staDbTxMaxNSS						:2;			// [10:9] STA DB Tx Max Nss[1:0]. Read during the Rx NDPA 
	uint32 staDbBfMode							:3;			// [13:11] STA DB BF mode[2:0]. Read during the Rx NDPA 
	uint32 staDbMinimalGrouping					:2;			// [15:14] STA DB minimal grouping[1:0]. Read during the Rx NDPA 
	uint32 BFeeGoodNDPA							:1;			// [16] BFee good NDPA 
	uint32 ndpaNdpTimerExpired					:1;			// [17] NDPA-NDP timer expired 
	uint32 abortAutoReplyOfBfReport				:1;			// [18] Abort auto reply of BF report due to STA DB Data TCRs PHY mode 11a/g/b 
	uint32 phyBfMatricesHtControlFieldPhyMode	:1;			// [19] PHY BF matrices HT control field PHY mode (VHT (1), HT(0))  
	uint32 phyBfMatricesMcsFeedback				:7;			// [26:20] PHY BF matrices MCS feedback[6:0]] 
	uint32 BFeeReportResponseDelayed			:1;			// [27] BFee report response delayed 
	uint32 reserved								:4;			// [31:28] Reserved 
	/* word 5 */
	uint32 phyBfMatricesMimoControl				:16;		// [15:0] PHY BF matrices MIMO control[15:0] 
	uint32 phyBFMatricesPhyMode					:1;			// [16] PHY BF matrices PHY mode (VHT (1), HT(0)) 
	uint32 phyBfMatricesTailBit					:1;			// [17] PHY BF matrices tail bit 
	uint32 phyBfMatricesLength					:12;		// [29:18] PHY BF matrices length[11:0]	
	uint32 bfFrameReportReady					:1;			// [30] BF frame report ready	
	uint32 bfFrameReportError					:1;			// [31] BF frame report error 
}BeamformingRxPhyNdpLog_t;

typedef struct BeamformingImplicitBfLog
{
	/* word 1 */
	//uint32 messageHeader_31_0					:32;		// [31:0] Message Header[31:0] 
	/* word 2 */	
	//uint32 messageHeader_63_32				:32;		// [31:0] Message Header[63:32] 
	/* word 3 */
	//uint32 messageHeader_95_64				:32;		// [31:0] Message Header[95:64] 
	/* word 4 */
	uint32 staIndex								:7;			// [6:0] STA index[6:0] 
	uint32 staDbBfDbValid						:1;			// [7] STA DB BF DB valid 
	uint32 staDbBfDbStatus						:1;			// [8] STA DB BF DB aging status 
	uint32 staDbTxMaxNSS						:2;			// [10:9] STA DB Tx Max Nss[1:0] 
	uint32 staDbBfMode							:3;			// [13:11] STA DB BF mode[2:0] 
	uint32 staDbMinimalGrouping					:2;			// [15:14] STA DB minimal grouping[1:0] 
	uint32 updateDbWithImplicitBfMatrices		:1;			// [16] Update DB with implicit BF matrices 
	uint32 reserved1							:1;			// [17] Reserved 
	uint32 reserved2							:1;			// [18] Reserved 
	uint32 phyBfMatricesHtControlFieldPhyMode	:1;			// [19] PHY BF matrices HT control field PHY mode (VHT (1), HT(0))  
	uint32 phyBfMatricesMcsFeedback				:7;			// [26:20] PHY BF matrices MCS feedback[6:0]] 
	uint32 reserved3							:5;			// [31:27] Reserved 
	/* word 5 */
	uint32 phyBfMatricesMimoControl				:16;		// [15:0] PHY BF matrices MIMO control[15:0] 
	uint32 phyBfMatricesPhyMode					:1;			// [16] PHY BF matrices PHY mode (VHT (1), HT(0)) 
	uint32 phyBfMatricesTailBit					:1;			// [17] PHY BF matrices tail bit 
	uint32 phyBfMatricesLength					:12;		// [29:18] PHY BF matrices length[11:0]	
	uint32 reserved4							:2;			// [31:30] Reserved 
	/* word 6 */
	uint32 bfDbNc								:3;			// [2:0] BF DB Nc[2:0]. Pre update BF matrices on the current frame. Relevant in case STA DB BF DB valid is set. 
	uint32 bfDbBw								:2;			// [4:3] BF DB BW[1:0]. Pre update BF matrices on the current frame. Relevant in case STA DB BF DB valid is set. 
	uint32 phyStatusBwScramblerInitField		:2;			// [6:5] PHY status BW scrambler init field[1:0] 
	uint32 nonstandardBfImplicitRules			:8;			// [14:7] Nonstandard BF implicit rules[7:0] 
	uint32 rxCtsFrame							:1;			// [15] Rx CTS frame 
	uint32 rxAckBaFrame							:1;			// [16] Rx ACK/BA frame 
	uint32 newBfIndex							:8;			// [24:17] New BF index. Relevant in case Update implicit BF matrices is set 
	uint32 reserved5							:7;			// [31:25] Reserved 
	/* word 7 */
	uint32 bfPollType							:1;			// [0] BF-poll type 
	uint32 bfFrameReportReady					:1;			// [1] BF frame report ready  
	uint32 bfFrameReportError					:1;			// [2] BF frame report error 
	uint32 BFeeGoodNDPA							:1;			// [3] BFee good NDPA 
	uint32 BFeeReportResponseDelayed			:1;			// [4] BFee report response delayed 
	uint32 wasWlanTxAfterNDPA					:1;			// [5] Was Wlan Tx after NDPA 
	uint32 abortAutoReplyOfBfReport				:1;			// [6] Abort auto reply of BF report due to STA DB Data TCRs PHY mode 11a/g/b 
	uint32 ndpaStaIndex							:7;			// [13:7] NDPA STA index[6:0] 
	uint32 ndpaVapIndex							:4;			// [17:14] NDPA VAP index[3:0] 
	uint32 currentVapIndex						:4;			// [21:18] Current VAP index[3:0] 
	uint32 myAddressIndication					:1;			// [22] My address indication
	uint32 reserved6							:9;			// [31:23] Reserved	
}BeamformingImplicitBfLog_t;


typedef struct BeamformingRxBfReportLog
{
	/* word 1 */
	//uint32 messageHeader_31_0					:32;		// [31:0] Message Header[31:0] 
	/* word 2 */
	//uint32 messageHeader_63_32				:32;		// [31:0] Message Header[63:32] 
	/* word 3 */
	//uint32 messageHeader_95_64				:32;		// [31:0] Message Header[95:64] 
	/* word 4 */
	uint32 staIndex								:7;			// [6:0] STA index[6:0]	
	uint32 staDbBfDbValid						:1;			// [7] STA DB BF DB valid 
	uint32 staDbBfDbAgingStatus					:1;			// [8] STA DB BF DB aging status 
	uint32 staDbTxMaxNSS						:2;			// [10:9] STA DB Tx Max Nss[1:0] 
	uint32 staDbBfMode							:3;			// [13:11] STA DB BF mode[2:0] 
	uint32 staDbMinimalGrouping					:2;			// [15:14] STA DB minimal grouping[1:0] 
	uint32 updateDbBfMatrices					:1;			// [16] Update DB BF matrices due to Rx BF report 
	uint32 rxBfReportHT							:1;			// [17] Rx BF report HT 
	uint32 rxBfReportVHT						:1;			// [18] Rx BF report VHT 
	uint32 rxBfReportEncrypted					:1;			// [19] Rx BF report encrypted 
	uint32 rxBfReportOrderBit					:1;			// [20] Rx BF report order bit 
	uint32 rxBfReportHtControlFieldPhyMode		:1;			// [21] Rx BF report HT control field PHY mode (VHT (1), HT(0)) 
	uint32 rxBfReportMcsFeedback				:7;			// [28:22] Rx BF report MCS feedback[6:0]] 
	uint32 reserved1 							:3;			// [31:29] Reserved 
	/* word 5 */
	uint32 rxBfReportMimoControl				:16;		// [15:0] Rx BF report MIMO control[15:0] 
	uint32 newBfIndex							:8;			// [23:16] New BF index Relevant in case Update BF matrices due to Rx BF report is set 
	uint32 reserved2 							:8;			// [31:24] Reserved 
	/* word 6 */
	uint32	rxBfReportSNR						:32;		// [31:0] Rx BF report SNR[31:0] 
	
}BeamformingRxBfReportLog_t;

#endif /* HW_LOGGER_BEAMFORMING_LOG_DEFS_H_ */

