/***********************************************************************************
 File:			HwLoggerDeliaLogDefs.h
 Module:			Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Delia logs
************************************************************************************/
#ifndef HW_LOGGER_DELIA_LOG_DEFS_H_
#define HW_LOGGER_DELIA_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct DeliaLog
{
	/* Word 0 */
	uint32 startTimeCycles						:9;
	uint32 startTimeUs							:23;
	/* Word 1 */
	uint32 tcr0									:32;
	/* Word 2 */
	uint32 tcr1									:32;
	/* Word 3 */
	uint32 tcr2									:32;
	/* Word 4 */
	uint32 tcr3									:32;
	/* Word 5 */	
	uint32 tcr4									:32;
	/* Word 6 */
	uint32 numOfPhyAckOnTcr						:3;
	uint32 numOfPhyAckOnBf						:6;
	uint32 numOfPhyAckOnData					:18;
	uint32 autoRelyframe						:1;
	uint32 txEndRecipeAborted					:1;
	uint32 txEndRemainFifoInPacketlenNotZero	:1;
	uint32 txEndRemainFifoOutPacketlenNotZero	:1;
	uint32 reserved1							:1;
	/* Word 7 */
	uint32 numberOfbytesFilledByAutoFill		:18;
	uint32 reserved2							:6;
	uint32 deliaWritesToHob						:8;	//The recipe can write to this register(Hob 0x838) some signature
	/* Word 8 */
	uint32 autoFillSubFrameStatus0to31			:32;
	/* Word 9 */
	uint32 autoFillSubFrameStatus32to63			:32;
	/* Word 10 */
	uint32 cpuDelCounter0Event					:12;
	uint32 cpuDelCounter1Event					:12;
	uint32 cpuNopWaitEventVector				:8;
	/* Word 11 */
	uint32 hobDelCounter0Event					:12;
	uint32 hobDelCounter1Event					:12;
	uint32 hobdelNopWaitEventVector				:8;
	/* Word 12 */
	uint32 lastFetchedInstr						:32;
	/* Word 13 */
	uint32 reserved3							:2;
	uint32 lastrecipePtr						:21;
	uint32 reserved4							:1;
	uint32 autoFillSubframeCounter				:7;
	uint32 reserved5							:1;
	/* Word 14 */
	uint32 endTimeCycles						:9;
	uint32 endTimeUs							:23;
} DeliaLog_t;

#endif /* HW_LOGGER_DELIA_LOG_DEFS_H_ */

