/***********************************************************************************
 File:			HwLogDefs_Delineator.h
 Module:		HwLogDefs 
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_LOG_DEFS_DELINEATOR_H_
#define HW_LOG_DEFS_DELINEATOR_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"

typedef struct _DelineatorLogStart_t
{
  	uint32 status0_low                    : 32; // Status 0, bits[31:0]
	uint32 status0_high                   : 32; // Status 0, bits[63:32]
	uint32 status1_low                    : 32; // Status 1, bits[31:0]
	uint32 status1_high                   : 32; // Status 1, bits[63:32]
	uint32 status2_low                    : 32; // Status 2, bits[31:0]
	uint32 status2_high                   : 32; // Status 2, bits[63:32]
} DelineatorLogStart_t;

typedef struct _DelineatorLogEnd_t
{
	uint32 metrics_low                    : 32; // Metrics, bits[31:0]
	uint32 metrics_high                   : 32; // Metrics, bits[63:32]
} DelineatorLogEnd_t;

typedef struct _DelineatorLogPerSubframe_t
{
	uint32 extracted_subframe_size        : 14; // [13:0]  Subframe size extracted from delimiter (agg frames only)
	uint32 reserved                       :  1; // [14]    Unused
	uint32 del_error_flag                 :  1; // [15]    Delimiter error(s) encountered prior to this good delimiter (agg frames only)
	uint32 zld_count                      : 16; // [31:16] Number of Zero-length delimiters prior to this good delimiter (agg frames only)
} DelineatorLogPerSubframe_t;

typedef struct _DelineatorLogShort_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogShort_t;

typedef struct _DelineatorLogLong1_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[1];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong1_t;

typedef struct _DelineatorLogLong2_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[2];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong2_t;

typedef struct _DelineatorLogLong3_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[3];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong3_t;

typedef struct _DelineatorLogLong4_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[4];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong4_t;

typedef struct _DelineatorLogLong5_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[5];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong5_t;

typedef struct _DelineatorLogLong6_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[6];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong6_t;

typedef struct _DelineatorLogLong7_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[7];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong7_t;

typedef struct _DelineatorLogLong8_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[8];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong8_t;

typedef struct _DelineatorLogLong9_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[9];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong9_t;

typedef struct _DelineatorLogLong10_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[10];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong10_t;

typedef struct _DelineatorLogLong11_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[11];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong11_t;

typedef struct _DelineatorLogLong12_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[12];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong12_t;

typedef struct _DelineatorLogLong13_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[13];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong13_t;

typedef struct _DelineatorLogLong14_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[14];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong14_t;

typedef struct _DelineatorLogLong15_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[15];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong15_t;

typedef struct _DelineatorLogLong16_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[16];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong16_t;

typedef struct _DelineatorLogLong17_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[17];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong17_t;

typedef struct _DelineatorLogLong18_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[18];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong18_t;

typedef struct _DelineatorLogLong19_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[19];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong19_t;

typedef struct _DelineatorLogLong20_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[20];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong20_t;

typedef struct _DelineatorLogLong21_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[21];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong21_t;

typedef struct _DelineatorLogLong22_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[22];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong22_t;

typedef struct _DelineatorLogLong23_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[23];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong23_t;

typedef struct _DelineatorLogLong24_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[24];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong24_t;

typedef struct _DelineatorLogLong25_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[25];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong25_t;

typedef struct _DelineatorLogLong26_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[26];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong26_t;

typedef struct _DelineatorLogLong27_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[27];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong27_t;

typedef struct _DelineatorLogLong28_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[28];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong28_t;

typedef struct _DelineatorLogLong29_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[29];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong29_t;

typedef struct _DelineatorLogLong30_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[30];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong30_t;

typedef struct _DelineatorLogLong31_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[31];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong31_t;

typedef struct _DelineatorLogLong32_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[32];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong32_t;

typedef struct _DelineatorLogLong33_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[33];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong33_t;

typedef struct _DelineatorLogLong34_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[34];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong34_t;

typedef struct _DelineatorLogLong35_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[35];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong35_t;

typedef struct _DelineatorLogLong36_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[36];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong36_t;

typedef struct _DelineatorLogLong37_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[37];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong37_t;

typedef struct _DelineatorLogLong38_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[38];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong38_t;

typedef struct _DelineatorLogLong39_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[39];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong39_t;

typedef struct _DelineatorLogLong40_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[40];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong40_t;

typedef struct _DelineatorLogLong41_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[41];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong41_t;

typedef struct _DelineatorLogLong42_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[42];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong42_t;

typedef struct _DelineatorLogLong43_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[43];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong43_t;

typedef struct _DelineatorLogLong44_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[44];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong44_t;

typedef struct _DelineatorLogLong45_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[45];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong45_t;

typedef struct _DelineatorLogLong46_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[46];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong46_t;

typedef struct _DelineatorLogLong47_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[47];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong47_t;

typedef struct _DelineatorLogLong48_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[48];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong48_t;

typedef struct _DelineatorLogLong49_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[49];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong49_t;

typedef struct _DelineatorLogLong50_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[50];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong50_t;

typedef struct _DelineatorLogLong51_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[51];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong51_t;

typedef struct _DelineatorLogLong52_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[52];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong52_t;

typedef struct _DelineatorLogLong53_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[53];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong53_t;

typedef struct _DelineatorLogLong54_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[54];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong54_t;

typedef struct _DelineatorLogLong55_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[55];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong55_t;

typedef struct _DelineatorLogLong56_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[56];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong56_t;

typedef struct _DelineatorLogLong57_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[57];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong57_t;

typedef struct _DelineatorLogLong58_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[58];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong58_t;

typedef struct _DelineatorLogLong59_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[59];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong59_t;

typedef struct _DelineatorLogLong60_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[60];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong60_t;

typedef struct _DelineatorLogLong61_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[61];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong61_t;

typedef struct _DelineatorLogLong62_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[62];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong62_t;

typedef struct _DelineatorLogLong63_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[63];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong63_t;

typedef struct _DelineatorLogLong64_t
{
	DelineatorLogStart_t		delineatorLogStart;
	DelineatorLogPerSubframe_t	delineatorLogPerSubframe[64];
	DelineatorLogEnd_t			delineatorLogEnd;
} DelineatorLogLong64_t;

typedef union _DelineatorLog_u
{
	DelineatorLogShort_t delineatorLogShort;
	DelineatorLogLong1_t delineatorLogLong1;
	DelineatorLogLong2_t delineatorLogLong2;
	DelineatorLogLong3_t delineatorLogLong3;
	DelineatorLogLong4_t delineatorLogLong4;
	DelineatorLogLong5_t delineatorLogLong5;
	DelineatorLogLong6_t delineatorLogLong6;
	DelineatorLogLong7_t delineatorLogLong7;
	DelineatorLogLong8_t delineatorLogLong8;
	DelineatorLogLong9_t delineatorLogLong9;
	DelineatorLogLong10_t delineatorLogLong10;
	DelineatorLogLong11_t delineatorLogLong11;
	DelineatorLogLong12_t delineatorLogLong12;
	DelineatorLogLong13_t delineatorLogLong13;
	DelineatorLogLong14_t delineatorLogLong14;
	DelineatorLogLong15_t delineatorLogLong15;
	DelineatorLogLong16_t delineatorLogLong16;
	DelineatorLogLong17_t delineatorLogLong17;
	DelineatorLogLong18_t delineatorLogLong18;
	DelineatorLogLong19_t delineatorLogLong19;
	DelineatorLogLong20_t delineatorLogLong20;
	DelineatorLogLong21_t delineatorLogLong21;
	DelineatorLogLong22_t delineatorLogLong22;
	DelineatorLogLong23_t delineatorLogLong23;
	DelineatorLogLong24_t delineatorLogLong24;
	DelineatorLogLong25_t delineatorLogLong25;
	DelineatorLogLong26_t delineatorLogLong26;
	DelineatorLogLong27_t delineatorLogLong27;
	DelineatorLogLong28_t delineatorLogLong28;
	DelineatorLogLong29_t delineatorLogLong29;
	DelineatorLogLong30_t delineatorLogLong30;
	DelineatorLogLong31_t delineatorLogLong31;
	DelineatorLogLong32_t delineatorLogLong32;
	DelineatorLogLong33_t delineatorLogLong33;
	DelineatorLogLong34_t delineatorLogLong34;
	DelineatorLogLong35_t delineatorLogLong35;
	DelineatorLogLong36_t delineatorLogLong36;
	DelineatorLogLong37_t delineatorLogLong37;
	DelineatorLogLong38_t delineatorLogLong38;
	DelineatorLogLong39_t delineatorLogLong39;
	DelineatorLogLong40_t delineatorLogLong40;
	DelineatorLogLong41_t delineatorLogLong41;
	DelineatorLogLong42_t delineatorLogLong42;
	DelineatorLogLong43_t delineatorLogLong43;
	DelineatorLogLong44_t delineatorLogLong44;
	DelineatorLogLong45_t delineatorLogLong45;
	DelineatorLogLong46_t delineatorLogLong46;
	DelineatorLogLong47_t delineatorLogLong47;
	DelineatorLogLong48_t delineatorLogLong48;
	DelineatorLogLong49_t delineatorLogLong49;
	DelineatorLogLong50_t delineatorLogLong50;
	DelineatorLogLong51_t delineatorLogLong51;
	DelineatorLogLong52_t delineatorLogLong52;
	DelineatorLogLong53_t delineatorLogLong53;
	DelineatorLogLong54_t delineatorLogLong54;
	DelineatorLogLong55_t delineatorLogLong55;
	DelineatorLogLong56_t delineatorLogLong56;
	DelineatorLogLong57_t delineatorLogLong57;
	DelineatorLogLong58_t delineatorLogLong58;
	DelineatorLogLong59_t delineatorLogLong59;
	DelineatorLogLong60_t delineatorLogLong60;
	DelineatorLogLong61_t delineatorLogLong61;
	DelineatorLogLong62_t delineatorLogLong62;
	DelineatorLogLong63_t delineatorLogLong63;
	DelineatorLogLong64_t delineatorLogLong64;
} DelineatorLog_u;

typedef struct _DelineatorLog_t
{
	DelineatorLog_u delineatorLog;
} DelineatorLog_t;
	
#endif //HW_LOG_DEFS_DELINEATOR_H_