/***********************************************************************************
 File:			HwLoggerLogsDefinitions.h
 Module:		HwLogDefs 
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_LOG_DEFS_API_H_
#define HW_LOG_DEFS_API_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "HwLoggerDelineatorLogDef.h"
#include "HwLoggerActivityLogDef.h"
#include "HwLoggerRxPpLogDefs.h"
#include "HwLoggerHostIfLogDef.h"
#include "HwLoggerTxSelectorLogDefs.h"
#include "HwLoggerTxAgerLogDefs.h"
#include "HwLoggerBeaconLogDefs.h"
#include "HwLoggerSecurityLogDefs.h"
#include "HwLoggerSequencerLogDefs.h"
#include "HwLoggerAggregationBuilderLogDefs.h"
#include "HwLoggerTxHandlerLogDefs.h"
#include "HwLoggerRxClassifierLogDefs.h"
#include "HwLoggerRxcRxfRxdLogDefs.h"
#include "HwLoggerPsSettingsLogDef.h"
#include "HwLoggerDeliaLogDefs.h"
#include "HwLoggerQueueManagerLogDef.h"
#include "HwLoggerTxPdAcceleratorLogDefs.h"
#include "HwLoggerMuBeamformingLogDefs.h"
#include "HwLoggerBeamformingLogDefs.h"
 



typedef union _HwLogs_u
{

	//TBD - TxMuSelBitmapLog_t								/* FID = 0 */
	DelineatorLog_t				delineatorLog;				/* FID = 1 */
	ActivityLog_t				activityLog;				/* FID = 2 */
	RxPpLog_t					rxPpLog;					/* FID = 3 */
	HostIfDetailedLog_t			hostIfDetailedLog;			/* FID = 4 -7 */ 
	HostIfSummarizedLog_t		hostIfSummarizeddLog;		/* FID = 4 -7 */ 
	TxSelectorLog_t				txSelectorLog;				/* FID = 8 */
	//TBD - MuLockerLog_t									/* FID = 9 */
	TxSelectorLogUpdateBitmap_t	txSelectorBitmapLog;		/* FID = 10 */
	TxAgerLog_t					txAgerlog;					/* FID = 12 */
	HwBeaconLog_t				hwBeaconLog;				/* FID = 13 */
	SecurityLog_t				securityLog;				/* FID = 14 */
	TxSequencerLog_t            sequencerLog;				/* FID = 15 */
	AggregationBuilderLog_t		aggregationBuilderLog;		/* FID = 16 */
	TxHandlerLog_t				txHandlerLog;				/* FID = 17 */
	BeamformingRxNdpaLog_t		beamformingRxNdpaLog;		/* FID = 18 , 0 */ 
	BeamformingRxPhyNdpLog_t	beamformingRxPhyNdpLog;		/* FID = 18 , 1 */ 
	BeamformingImplicitBfLog_t	beamformingImplicitBfLog;	/* FID = 18 , 2 */ 
	BeamformingRxBfReportLog_t	beamformingRxBfReportLog;	/* FID = 18 , 3 */ 
	RxClassifierDetailedLog_t	rxClassifierDetailedlog;	/* FID = 19 , 0*/
	RxClassifierSummarizedLog_t	rxClassifierSummarizedlog;	/* FID = 19 , 1*/
	RxcRxfRxdLog_t				rxcRxfRxdLog;				/* FID = 20 */
	PsSettingsLog_t				psSettingsLog;				/* FID = 21 */
	//TBD - BaaLog_t										/* FID = 22 */
	//TBD -LiberatorLog_t									/* FID = 23 - 24 */ 
	DeliaLog_t					deliaLog;					/* FID = 25 */
	//TBD -PacExtrapulatorHwReportLog_t						/* FID = 26, 0 */ 
	//TBD -PacExtrapulatorSwReportLog_t						/* FID = 26, 1 */ 
	HwQueueManagerLog_t			hwQueueManagerLog;			/* FID = 11,27 - 29 */
	TxPdAcceleratorLog_t        txPdAcceleratorLog;         /* FID = 30 */
	MuBeamformingLog_t			muBeamformingLog;			/* FID = 31 */
} HwLogs_u;
	
#endif //HW_LOG_DEFS_API_H_
