/***********************************************************************************
 File:			HwLoggerMuBeamformingLogDefs.h
 Module:		Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Mu Beamforming 
 				logs
************************************************************************************/
#ifndef HW_LOGGER_MU_BEAMFORMING_LOG_DEFS_H_
#define HW_LOGGER_MU_BEAMFORMING_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct _MuBeamformingLog_t
{
	uint32 mimo_ctrl								: 16;
	uint32 mimo_ctrl_valid							: 1;
	uint32 frame_control_type 						: 2;
	uint32 frame_control_subtype 					: 4;
	uint32 frame_control_protectedframe 			: 1;
	uint32 frame_control_order						: 1;
	uint32 debug_mode_en							: 1;
	uint32 debug_bf_index							: 4;
	uint32 expected_nc_0 							: 2;

	uint32 expected_nc_1 							: 1;
	uint32 expected_nr 								: 3;
	uint32 expected_ch_bw 							: 2;
	uint32 mu_bf_fail 								: 4;
	uint32 state1_done 								: 1;
	uint32 state2_done 								: 1;
	uint32 state3_done 								: 1;
	uint32 state4_done 								: 1;
	uint32 mu_bf_frame_check_pass_level1 			: 1;
	uint32 mu_bf_frame_check_pass_level2 			: 1;
	uint32 mu_bf_err_no_head_pass 					: 1;
	uint32 mu_bf_err_check_pass 					: 1;
	uint32 frame_control_type_check_pass 			: 1;
	uint32 frame_control_subtype_check_pass 		: 1;
	uint32 frame_control_protectedframe_check_pass 	: 1;
  	uint32 channel_feedback_type_check_pass 		: 1;
  	uint32 mu_category_check_pass 					: 1;
  	uint32 mu_vht_action_check_pass 				: 1;
  	uint32 nr_check_pass 							: 1;
  	uint32 nc_check_pass 							: 1;
  	uint32 ch_bw_check_pass 						: 1;
  	uint32 remain_feedback_check_pass 				: 1;
  	uint32 first_feedback_check_pass 				: 1;
  	uint32 frame_too_short_check_pass 				: 1;
  	uint32 frame_too_long_check_pass 				: 1;
  	uint32 expect_mu_bf_report_check_pass 			: 1;

  	uint32 avg_snr 									: 32;

} MuBeamformingLog_t;


#endif /* HW_LOGGER_MU_BEAMFORMING_LOG_DEFS_H_ */

