/***********************************************************************************
 File:		PHYLoggerLogDef.h
 Module:		HwLogDefs 
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef PHY_LOG_DEFS_SETTIGS_H_
#define PHY_LOG_DEFS_SETTIGS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------

typedef struct _PhyTxLog_t
{
	//TCR0
	uint32 tcr0_phy_mode		:2; //[1:0]
	uint32 tcr0_cbw				:2; //[3:2]
	uint32 tcr0_rf_power		:6; //[9:4]
	uint32 tcr0_bf_mode			:2; //[11:10]
	uint32 empty0				:20;//[31:12]

	//TCR1
	uint32 tcr1_ldpc			:1; //[0]
	uint32 tcr1_stbc			:2; //[2:1]
	uint32 tcr1_partial_aid		:9; //[11:3]
	uint32 empty1				:20;//[31:12]
	// TCR1 2nd part
	uint32 tcr1_txop_ps_not_allowed	 :1; //[0]
	uint32 tcr1_group_id			 :6; //[6:1]
	uint32 tcr1_24GCoEx				 :1; //[7]
	uint32 tcr1_reserve				 :1; //[8]
	uint32 tcr1_mu_training_grouping :1; //[9]
	uint32 tcr1_mu_training			 :1; //[10]
	uint32 tcr1_mu_phy_ndp			 :1; //[11]
	uint32 empty2					:20;//[31:12]
	// TCR2 1st part
	uint32 tcr2_cdd_ant1		:4; //[3:0]
	uint32 tcr2_cdd_ant2		:4; //[7:4]
	uint32 tcr2_cdd_ant3		:4; //[11:8]
	uint32 empty3				:20;//[31:12]
	// TCR2 2nd part
	uint32 tcr2_bw_change		:1; //[0]
	uint32 tcr2_power_boost		:8; //[8:1]
	uint32 tcr2_gen_risc1		:3; //[11:9]
	uint32 empty4				:20;//[31:12]
	// TCR3 1st part	
	uint32 tcr3_aggregate		:1; //0
	uint32 tcr3_not_sounding	:1; //1
	uint32 tcr3_bf_smoothing	:1; //2
	uint32 tcr3_dyn_bw			:1; //3
	uint32 tcr3_reserved0		:4; //[7:4]
	uint32 tcr3_mcs				:5; //[13:8]
	uint32 tcr3_mcs_nss			:2; //[15:14]
	uint32 empty5				:16;//[31:16]
	// TCR3 2nd part (only short cp 1 bit)	
	uint32 tcr3_short_cp		:1; //[0]
	uint32 empty6				:31;//[31:1]
	// TCR4 1st part
	uint32 tcr4_length_low		:16; //[15:0]
	uint32 empty7				:16;//[31:16]
	// TCR4 2nd part (4 bits)
	uint32 tcr3_length_high		:4; //[3:0]
	uint32 empty8				:28;//[31:4]

} PhyTxLog_t;


typedef struct _Phy_HTSig_Log_t
{
	//PHY_RX_BE_IF_N_LENGTH
	uint32 n_length				:16; //[15:0]
	uint32 empty0				:16;//[31:16]
	// RX_BE_IF 0x419E
	uint32 nss					:3; //[2:0]
	uint32 Reserved0			:1; //3
	uint32 bw					:2; //[5:4]
	uint32 stbc					:2; //[7:6]
	uint32 Reserved1			:1; //8
	uint32 aggregation			:1; //9
	uint32 short_gi				:1; //10
	uint32 LDPC					:1; //11
	uint32 Reserved2			:1; //12
	uint32 smoothing			:1; //13
	uint32 Not_sounding			:1; //14
	uint32 ht_sig2_reserved		:1; //15
	uint32 empty1				:16;//[31:16]
	// RX_BE_IF 0x41A0
	uint32 sig1_parity_err		:1; //0
	uint32 sig1_invalid_rate	:1; //1
	uint32 sig1_min_length_err	:1; //2
	uint32 sig1_reserved_err	:1; //3
	uint32 sig23_crc_err		:1; //4
	uint32 sig23_reserved_err	:1; //5
	uint32 mtlk_crc_status		:1; //6
	uint32 Reserved3			:1; //7
	uint32 mcs			   		:6; //[14:8]
	uint32 empty2				:17;//[31:15]
	// AIR_TIME_NUM_SYM
	uint32 Nsym					:15; //[14:0]
	uint32 empty3				:17;//[31:15]
} Phy_HTSig_Log_t;

typedef struct _Phy_LSig_Log_t
{
	//PHY_RX_BE_IF_A_LENGTH
	uint32 Length				:12; //[11:0]
	uint32 Rate					:4; //[15:12]
	uint32 empty0				:16;//[31:16]
} Phy_LSig_Log_t;


typedef union _PHYHwLogs_u
{
	PhyTxLog_t					phyTxLog;
	Phy_HTSig_Log_t				Phy_HTSig_Log;
	Phy_LSig_Log_t				Phy_LSig_Log;
} PHYHwLogs_u;
	
#endif //PHY_LOG_DEFS_SETTIGS_H_