/***********************************************************************************
 File:			HwLoggerRxClassifierLogDefs.h
 Module:			Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Rx Classifier logs
************************************************************************************/
#ifndef HW_LOGGER_RX_CLASSIFIER_LOG_DEFS_H_
#define HW_LOGGER_RX_CLASSIFIER_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct RxClassifierSummarizedLog
{
	/* Word 0 */
	uint32 rtdWord0					:32;
	/* Word 1 */
	uint32 rtdWord1					:32;
	/* Word 2 */
	uint32 rtdWord2					:32;
	/* Word 3 */
	uint32 rtdWord3					:32;
	/* Word 4 */
	uint32 rtdWord4					:32;
	/* Word 5 */
	uint32 rtdWord5					:32;
	/* Word 6 */
	uint32 rtdWord6					:32;
} RxClassifierSummarizedLog_t;

typedef struct RxClassifierDetailedLog
{
	/* Word 0 */
	uint32 rtdWord0					:32;
	/* Word 1 */
	uint32 rtdWord1					:32;
	/* Word 2 */
	uint32 rtdWord2					:32;
	/* Word 3 */
	uint32 rtdWord3					:32;
	/* Word 4 */
	uint32 rtdWord4					:32;
	/* Word 5 */
	uint32 rtdWord5					:32;
	/* Word 6 */
	uint32 rtdWord6					:32;
	/* Word 7 */
	uint32 pendingSecDescAcc		:8;
	uint32 secDescIndes				:7;
	uint32 staRekeyOccured			:1;
	uint32 vapRekeyOccured			:1;
	uint32 reserved1				:15;
	/* Word 8 */
	uint32 pendingrtdAcc			:8;
	uint32 occupiedRtdAcc			:8;
	uint32 rtdIndex					:7;
	uint32 currentStaFrameClass		:2;
	uint32 mpduFrameClass			:2;
	uint32 reserved2				:5;
	/* Word 9 */
	uint32 rxInPtr					:16;
	uint32 rxOurPtr					:16;
} RxClassifierDetailedLog_t;


#endif /* HW_LOGGER_RX_CLASSIFIER_LOG_DEFS_H_ */

