/***********************************************************************************
 File:			HwLoggerRxPpLogDefs.h
 Module:			Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Rx Pp logs
************************************************************************************/
#ifndef HW_LOGGER_RX_PP_LOG_DEFS_H_
#define HW_LOGGER_RX_PP_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct RxPpLogNewMpdu
{
	/* Word 0*/
	uint32 timestamp				:32;
	/* Word 1 */
	uint32 rxPpBusy					:1;
	uint32 swFlush					:1;
	uint32 swSnUpdate				:1;
	uint32 swWindowSizeChange		:1;
	uint32 sta						:7;
	uint32 tid						:4;
	uint32 controlBits				:4;
	uint32 skipBits					:1;
	uint32 ssn						:12;
	/* Word 2*/
	uint32 rdType					:4;
	uint32 sn						:12;
	uint32 pn01						:16;
	/* Word 3*/
	uint32 pn25						:32;
	/* Word 4 */	
	uint32 baa						:1;
	uint32 rdPtr					:16;
	uint32 retryBit					:1;
	uint32 aggregationBit			:1;
	uint32 fragNum					:4;
	uint32 fragEnable				:1;
	uint32 securityErrorTkipMic		:1;
	uint32 securityErrorFailureInd	:1;
	uint32 statusErrorSecurity		:1;
	uint32 statusErrorRxh			:1;
	uint32 statusErrorRxClassifier	:1;
	uint32 mpduDropBelowWindow		:1;
	uint32 reserved1				:2;
	/* Word 5 */
	uint32 reserved2				:1;
	uint32 mpduDuplicateDrop		:1;
	uint32 mpduSentToRxDataDlm		:1;
	uint32 mpduSentToErrorList		:1;
	uint32 mpduCausedMpduRelease	:1;
	uint32 replayDetection			:1; 			/* Only If (Bit[164] == 1) then the below is valid */ 
	uint32 reserved3				:26;
} RxPpLogNewMpdu_t;

typedef struct RxPpLogSwInstr
{
	/* Word 0 */
	uint32 timestamp;
	/* Word 1 */
	uint32 rxPpBusy					:1;
	uint32 swFlush					:1;
	uint32 swSnUpdate				:1;
	uint32 swWindowSizeChange		:1;
	uint32 sta						:7;
	uint32 tid						:4;
	uint32 multipleTids				:1;
	uint32 multipleTidEnable		:9;
	uint32 multipleTidValue1		:7;
	/* Word 2 */
	uint32 multipleTidValue2		:2;
	uint32 replayDetection			:1;
	uint32 reserved1				:29;
} RxPpLogSwInstr_t;

typedef union
{
	RxPpLogSwInstr_t			rxPpSwInstr; // Release of MPDUs as a result of SW instruction as described at the beginning
	RxPpLogNewMpdu_t			rxPpNewMpdu; // Start working on new MPDU coming from mpdu_in list
} RxPpLog_u;

///TBD this structure is a remporary till the driver support unions
typedef struct RxPpLog
{
	RxPpLog_u txSelectorLog;
} RxPpLog_t;

#endif /* HW_LOGGER_RX_PP_LOG_DEFS_H_ */

