/***********************************************************************************
 File:			HwLoggerRxcRxfRxdLogDefs.h
 Module:			Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Rxc\Rxf\Rxd logs
************************************************************************************/
#ifndef HW_LOGGER_RXC_RXF_RXD_LOG_DEFS_H_
#define HW_LOGGER_RXC_RXF_RXD_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct RxcRxfRxdLog
{
	/* Word 0 */
	uint32 rxdInputs0to31				:32;
	/* Word 1 */
	uint32 rxdInputs32to42				:11;
	uint32 bssModeRejectFilter			:1;	// Used as RXD Input [38] 
	uint32 mpduTypeRejectFilter			:1; // Used as RXD Input [38] 
	uint32 maxMpduLengthRejectFilter	:1; // Used as RXD Input [38] 
	uint32 ampduWithNoBaRejectFilter	:1; // Used as RXD Input [38] 
	uint32 crcError						:1; // Used as RXD Input [28] 
	uint32 phyErro						:1; // Used as RXD Input [28] 
	uint32 bufferOverflow				:1; // Used as RXD Input [28] 
	uint32 fioOverflow					:1; // Used as RXD Input [28] 
	uint32 staIndex						:7;
	uint32 staIndexValid				:1;
	uint32 rxdOutputsError0to4 			:5;
	/* Word 2 */
	//uint32 rxdOutputs5to33 				:29;  merav debug
	uint32 rxdOutputsError5to7 			:3;
	uint32 RTS_frame		 			:1;
	uint32 rxdOutputs9to33 				:25;
	uint32 phyNdp						:1;
	uint32 reserved						:2;
} RxcRxfRxdLog_t;


///

#endif /* HW_LOGGER_RXC_RXF_RXD_LOG_DEFS_H_ */

