/***********************************************************************************
 File:			HwLoggerSecurityLogDefs.h
 Module:			Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Security logs
************************************************************************************/
#ifndef HW_LOGGER_SECURITY_LOG_DEFS_H_
#define HW_LOGGER_SECURITY_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"

//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct SecurityLog
{
	/* Word 0 */
	uint32 startTimeCycles					:9;
	uint32 startTimeUs						:23;
	/* Word 1 */
	uint32 securityDescWord0				:32;
	/* Word 2 */
	uint32 securityDescWord1				:32;
	/* Word 3 */
	uint32 securityDescWord2				:24;
	uint32 descStatusFiaulureInd			:1;
	uint32 descStatusMicFailure				:1;
	uint32 descStatusKeyValidNotSetInDb		:1;
	uint32 descStatusProtectedBitIsNotSet	:1;
	uint32 descStatusLengthError			:1;
	uint32 descStatusEivError				:1;
	uint32 descStatusLastFragLengthError	:1;
	uint32 descStatusSameFragNum			:1;	
	/* Word 4 */
	uint32 txNumOfValidDescriptors 	 		:8;
	uint32 rxNumOfValidDescriptors 	 		:8;
	uint32 txDescPtr 	 					:8;
	uint32 rxDescPtr 		 				:8;
	/* Word 5 */
	uint32 endTimeCycles					:9;
	uint32 endTimeUs						:23;
} SecurityLog_t;

#endif /* HW_LOGGER_SECURITY_LOG_DEFS_H_ */

