/***********************************************************************************
 File:			HwLoggerSequencerLogDefs.h
 Module:		Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Sequencer 
 				logs
************************************************************************************/
#ifndef HW_LOGGER_SEQUENCER_LOG_DEFS_H_
#define HW_LOGGER_SEQUENCER_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct TxSequencerLog
{
	uint32 startTimeStampPrescalar								:9;
	uint32 startTimeStampUSec									:23;
	
	uint32 successfulRxCts										:1;
	uint32 successfulRxAck										:1;
	uint32 successfulRxBa										:1;
	uint32 successfulRxBfReport									:1;
	uint32 bfReportHeaderValid									:1;
	uint32 otherRx												:1;
	uint32 responseTimeout										:1;
	uint32 postTx												:1;
	uint32 baaHasBeenActivated									:1;
	uint32 baaResultError										:1;
	uint32 baaClearsTxSelectorPsRequest							:4;
	uint32 stdMuTx												:1;
	uint32 stdMuTraining     									:1;
	uint32 stdActiveUsp     									:4;
	uint32 stdNextBfReportStaNumber								:4;
	uint32 stdNextBa											:2;
	uint32 stdPrimaryUsp										:2;
	uint32 baaNeeded    										:4;

	uint32 aggHasBeenActivated									:1;
	uint32 aggReactivationResult								:14;
	uint32 aggBfReportNssModifiedSticky							:1;
	uint32 aggBfReportMcsModifiedSticky							:1;
	uint32 stdMuGroupEntry  									:7;
	uint32 stdAggUspDrop  										:4;
	uint32 stdAggUspLock  										:4;

	uint32 setBfPoll											:1;
	uint32 setBar												:1;
	uint32 setBfIteration										:1;
	uint32 thereWasANeedToSetFillerButStaIsNotSupported         :1;
	uint32 setFiller											:1;
	uint32 fillerCause											:2;
	uint32 stdMuGroupLock										:1;
	uint32 stdPlannedTxopMultipleData							:1;
	uint32 bwChangeDuringTxSequence								:1;
	uint32 reserved0											:1;
	uint32 setCfEnd												:1;
	uint32 unlockQueue											:1;
	uint32 unfreezeTxHandler									:1;
	uint32 clearTxNavTimer										:1;
	uint32 ccaStickyBits										:6;
	uint32 lastGoodAggBwResult									:2;
	uint32 suBfReportBw											:2;
	uint32 rtsCtsDynamicBw										:2;
	uint32 senderBwLimit										:2;
	uint32 stdBw												:2;
	uint32 changeInBwdueToCca									:1;

	uint32 sequencerBfReportValidBit							:1;
	uint32 cpuBfReportValidBit									:1;
	uint32 senderBfReportValidBit								:1;
	uint32 clearTxSelectorBfRequest								:1;
	uint32 sequencerFifoHasBeenDropped							:1;
	uint32 sampledTxNavTimer									:18;
	uint32 reserved1											:6;
	uint32 phyModeOfTheLastStd									:2;
	uint32 reserved2											:1;

	uint32 txQueueIdUsp0										:18;
	uint32 stdAltRateReasonFastProbing							:1;
	uint32 stdAltRateReasonSlowProbing							:1;
	uint32 numberOfBaaRaReports									:6;
	uint32 reserved3											:6;

	uint32 txQueueIdUsp1										:18;
	uint32 reserved4											:6;
	uint32 reprotTransactionNumber								:8;

	uint32 txQueueIdUsp2										:18;
	uint32 reserved5											:14;

	uint32 txQueueIdUsp3										:18;
	uint32 reserved6											:14;

	uint32 stdPlannedBits										:16;
	uint32 stdExecutedBits										:16;

	uint32 muBfParserResultBadBfReport							:4;
	uint32 timeoutEventSticky									:4;
	uint32 otherRxEventSticky									:4;
	uint32 reserved7											:4;
	uint32 phyResultMuEffectiveRate								:16;

	uint32 endTimeStampPrescalar								:9;
	uint32 endTimeStampUSec										:23;
} TxSequencerLog_t;


#endif /* HW_LOGGER_SEQUENCER_LOG_DEFS_H_ */

