/***********************************************************************************
 File:			HwLoggerTxAgerLogDefs.h
 Module:			Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:		This file contains the definitions and structures of the Tx Ager 
 				logs
************************************************************************************/
#ifndef HW_LOGGER_TX_AGER_LOG_DEFS_H_
#define HW_LOGGER_TX_AGER_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct TxAgerLog
{	
	/* Word 0 */
	uint32 agerStartPulse			:1;
	uint32 swSingleActivation		:1;
	uint32 backGroundCheckDone		:1;
	uint32 swSingleCheckDone		:1;
	uint32 mpduDropped				:1;
	uint32 startSta					:8;
	uint32 lastStaChecked			:8; 
	uint32 droppedPdStaNumber		:8;
	uint32 droppedPdTidNum			:3;
	/* if (Bit[2] | Bit[3]) the following fields are relevent  */
	/* Word 1 */
	uint32 agerSta0to31StatusReg	:32; 	// STAs which dropped PDs
	/* Word 3 */
	uint32 agerSta32to63StatusReg	:32; // STAs which dropped PDs
	/* Word 4 */
	uint32 agerSta64to95StatusReg	:32; // STAs which dropped PDs
	/* Word 5 */
	uint32 agerSta96to127StatusReg	:32; // STAs which dropped PDs
	/* Word 6 */
	uint32 agerVapStatusReg			:16; // Vaps which dropped PDs 
	uint32 forceLock				:1;
	uint32 reserved					:15;
} TxAgerLog_t;

#endif /* HW_LOGGER_TX_AGER_LOG_DEFS_H_ */

