/***********************************************************************************
 File:			HwLoggerTxHandlerLogDefs.h
 Module:		Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Tx handler 
 				logs
************************************************************************************/
#ifndef HW_LOGGER_TX_HANDLER_LOG_DEFS_H_
#define HW_LOGGER_TX_HANDLER_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct TxHandlerLog
{
	uint32 freezeIndication                 : 1;
	uint32 startSlotAfterSifsIndication     : 1;
	uint32 startSlotAfterSlotIndication     : 1;
	uint32 txPauserWaitForConfirmation      : 1;
	uint32 reserved                         : 28;
	
	uint32 txSelectorMatrixAcBe             : 16;
	uint32 txRequestMatrixAcBe              : 16;

	uint32 lastSlotMatrixAcBe               : 16;
	uint32 pauserMatrixAcBe                 : 16;
	
	uint32 txSelectorMatrixAcBk             : 16;
	uint32 txRequestMatrixAcBk              : 16;

	uint32 lastSlotMatrixAcBk               : 16;
	uint32 pauserMatrixAcBk                 : 16;

	uint32 txSelectorMatrixAcVi             : 16;
	uint32 txRequestMatrixAcVi              : 16;

	uint32 lastSlotMatrixAcVi               : 16;
	uint32 pauserMatrixAcVi                 : 16;

	uint32 txSelectorMatrixAcVo             : 16;
	uint32 txRequestMatrixAcVo              : 16;

	uint32 lastSlotMatrixAcVo               : 16;
	uint32 pauserMatrixAcVo                 : 16;

	uint32 txSelectorMatrixAcGplp           : 16;
	uint32 txRequestMatrixAcGplp            : 16;

	uint32 lastSlotMatrixAcGplp             : 16;
	uint32 pauserMatrixAcGplp               : 16;

	uint32 txSelectorMatrixAcGphp           : 16;
	uint32 txRequestMatrixAcGphp            : 16;

	uint32 lastSlotMatrixAcGphp             : 16;
	uint32 pauserMatrixAcGphp               : 16;

	uint32 txSelectorMatrixAcBeacon         : 16;
	uint32 txRequestMatrixAcBeacon          : 16;

	uint32 lastSlotMatrixAcBeacon           : 16;
	uint32 pauserMatrixAcBeacon             : 16;	
} TxHandlerLog_t;


#endif /* HW_LOGGER_TX_HANDLER_LOG_DEFS_H_ */

