/***********************************************************************************
 File:			HwLoggerTxPdAcceleratorLogDefs.h
 Module:		Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Tx Pd 
 				accelerator	logs
************************************************************************************/
#ifndef HW_LOGGER_TX_PD_ACCELERATOR_LOG_DEFS_H_
#define HW_LOGGER_TX_PD_ACCELERATOR_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------
typedef struct TxPdAcceleratorLog
{
	uint32 mpduPdHeaderPointer   : 16;
	uint32 mpduPdTailPointer     : 16;

	uint32 usp                   : 2;
	uint32 isLastPd				 : 1;
	uint32 firstMsdu			 : 1;
	uint32 secondMsdu            : 1;
	uint32 lastPdPerUsp		     : 1;
	uint32 lastMpduPerUsp	     : 1;
	uint32 mpduIndex		     : 6;
	uint32 retransmittedMpdu     : 1;
	uint32 enableCopyDw0		 : 1;
	uint32 enableCopyDw0And5	 : 1;
	uint32 pdPointer			 : 16;

	uint32 pdWord0;
	uint32 pdWord1;

	uint32 totalByteLength		 : 14;
	uint32 zldCount				 : 10;
	uint32 msdusCount			 : 8;

	uint32 pdWord2;
	uint32 pdWord3;
	uint32 pdWord4;
	uint32 pdWord6;
} TxPdAcceleratorLog_t;


#endif /* HW_LOGGER_TX_PD_ACCELERATOR_LOG_DEFS_H_ */

