/***********************************************************************************
 File:			HwLoggerTxSelectorLogDefs.h
 Module:		Hw logger 
 Purpose: 		To handle all logs from FW and HW
 Description:	This file contains the definitions and structures of the Tx selector 
 				logs
************************************************************************************/
#ifndef HW_LOGGER_TX_SELECTOR_LOG_DEFS_H_
#define HW_LOGGER_TX_SELECTOR_LOG_DEFS_H_

//---------------------------------------------------------------------------------
//						Includes						
//---------------------------------------------------------------------------------
#include "System_GlobalDefinitions.h"
#include "System_Configuration.h"


//---------------------------------------------------------------------------------
//						Defines						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Macros						
//---------------------------------------------------------------------------------

//---------------------------------------------------------------------------------
//						Data Type Definition					
//---------------------------------------------------------------------------------

typedef struct TxSelectorLogSelectionResult
{
	uint32 ac0VapSelectionAvailable           : 16;
	uint32 ac1VapSelectionAvailable           : 16;
	
	uint32 ac2VapSelectionAvailable           : 16;
	uint32 ac3VapSelectionAvailable           : 16;
	
	uint32 ac5VapSelectionAvailable           : 16;
	uint32 ac6VapSelectionAvailable           : 16;
	
	uint32 ac7VapSelectionAvailable           : 16;
	uint32 emptySelection                     : 1;
	uint32 selectedTid                        : 3;
	uint32 selectedStation                    : 7;
	uint32 selectedVap                        : 4;
	uint32 selectionSourceLow                 : 1;
	
	uint32 selectionSourceHigh                : 2;
	uint32 selectedBfBits                     : 2;
	uint32 selectionBitmapLow                 : 28;
	
	uint32 selectionBitmapHigh                : 4;
	uint32 timIeLowPart                       :28;
	
	uint32 timIe[4];

	uint32 timIeHighPart                      :13;
	uint32 reserved                           :19;
} TxSelectorLogSelectionResult_t;


typedef struct TxSelectorLogUpdateBitmap
{
	uint32 tid                : 3;
	uint32 station            : 7;
	uint32 bitmapNumber       : 3;
	uint32 bitTypeUpdtae      : 4;
	uint32 bitUpdateValue     : 1;
	uint32 isAllTids          : 1;
	uint32 reserved           : 13;
} TxSelectorLogUpdateBitmap_t;


typedef struct TxSelectorLogLockerMessage
{
	uint32 masterNotShown        : 2;
	uint32 validMaster           : 4;
	uint32 master1Tid            : 3;
	uint32 master1Station        : 7;
	uint32 master1BitmapNumber   : 3;
	uint32 master1LockType       : 2;
	uint32 master1IsAllTids      : 1;
	uint32 master1LockStatus     : 5;
	uint32 master2Tid            : 3;
	uint32 master2StationLow     : 2;

	uint32 master2StationHigh    : 5;
	uint32 master2BitmapNumber   : 3;
	uint32 master2LockType       : 2;
	uint32 master2IsAllTids      : 1;
	uint32 master2LockStatus     : 5;
	uint32 agerTid               : 3;
	uint32 agerStation           : 7;
	uint32 agerBitmapNumber      : 1;
	uint32 agerLockType          : 1;
	uint32 agerIsReject          : 1;
	uint32 reserved              : 3;
} TxSelectorLogLockerMessage_t;

typedef union
{
	TxSelectorLogSelectionResult_t 	selectionResult;
	TxSelectorLogUpdateBitmap_t		updateBitmap;
	TxSelectorLogLockerMessage_t   	lockerMessage;
} TxSelectorLog_u;


///TBD this structure is a remporary till the driver support unions
typedef struct TxSelectorLog
{
	TxSelectorLog_u txSelectorLog;
} TxSelectorLog_t;
///

#endif /* HW_LOGGER_TX_SELECTOR_LOG_DEFS_H_ */

