/***********************************************************************************
 File:		HwMbfm_Api.h
 Module:		Hw MAC Beamforming Module
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_MBFM_API_H_
#define HW_MBFM_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/







/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/

typedef struct _MacBfmDb_
{
	uint32 fifoNotEmptyCounter;	
	uint32 fifoFullDropCounter;
	uint32 globalIsrErrorcounter;
	uint32 BferAuthenticationFailedErrorcounter;
	uint32 BfeeNtxErrorCounter;	
	uint32 BfeeLostNdpErrorCounter;
} MacBfmDb_t;

#if defined (ENET_INC_ARCH_WAVE600D2)
//should match RegMacBfmMbfmIsrCtrl_u but with all error causes saparated to bits in order to be able to check each one saparately
/* Cause interrupt:
	bit[0] - Error fifo overflow 
	bit[1] - BFer authentication failed 
	bit[2] - BFer general error
	bit[5:3] - Reserved 
	bit[6] - BFee length 0 
	bit[7] - BFee NTX error
	bit[8] - BFee TX phy_mode error 
	bit[9] - HT MCS&NSS 32 or HE DCM
	bit[10] - BFee unexpected RXC access
	bit[11] - BFee lost NDP
	bit[12] - detect more data from phy in BFee
	bit[13] - one or more fields in the BFee start from PHY is wrong
	bit[15:14] - Reserved
*/
typedef union
{
	uint32 val;
	struct
	{
		uint32 mbfmGlobalErrIrqCauseFifoOverflow : 1;
		uint32 mbfmGlobalErrIrqCauseBferAuthenticationFailed : 1;
		uint32 mbfmGlobalErrIrqCauseBferGeneralError : 1;
		uint32 reserved0 : 3;
		uint32 mbfmGlobalErrIrqCauseBfeeZeroLength : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeNtxError : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeTxPhyModeError : 1;
		uint32 mbfmGlobalErrIrqCauseHtMcsNss32OrDcm : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeUnexpectedRxcAccess : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeLostNdp : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeDetectMoreDataFromPhy : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeStartFromPhyHasWrongFields : 1;
		uint32 reserved1 : 17;
		uint32 mbfmGlobalErrIrq : 1; //Error Interrupt from MBFM, reset value: 0x0, access type: RO
	}bitFields;
}MacBfmIsrCtrl_t;

//should match RegMacBfmMbfmIsrCtrlEn_u but with all error causes saparated to bits in order to be able to check each one saparately
typedef union
{
	uint32 val;
	struct
	{
		uint32 mbfmGlobalErrIrqEnFifoOverflow : 1;
		uint32 mbfmGlobalErrIrqEnBferAuthenticationFailed : 1;
		uint32 mbfmGlobalErrIrqEnBferGeneralError : 1;
		uint32 reserved0 : 3;
		uint32 mbfmGlobalErrIrqEnBfeeZeroLength : 1;
		uint32 mbfmGlobalErrIrqEnBfeeNtxError : 1;
		uint32 mbfmGlobalErrIrqEnBfeeTxPhyModeError : 1;
		uint32 mbfmGlobalErrIrqEnHtMcsNss32OrDcm : 1;
		uint32 mbfmGlobalErrIrqEnBfeeUnexpectedRxcAccess : 1;
		uint32 mbfmGlobalErrIrqEnBfeeLostNdp : 1;
		uint32 mbfmGlobalErrIrqEnBfeeDetectMoreDataFromPhy : 1;
		uint32 mbfmGlobalErrIrqEnBfeeStartFromPhyHasWrongFields : 1;
		uint32 reserved1 : 18;
	}bitFields;
}MacBfmIsrCtrlEn_t;

#elif defined (ENET_INC_ARCH_WAVE600B)
//should match RegMacBfmMbfmIsrCtrl_u but with all error causes saparated to bits in order to be able to check each one saparately
//Cause interrupt: , bit[0] - Error fifo overflow        , bit[1] - BFee length 0              , bit[2] - BFer authentication failed , bit[3] - BFee NTX error             , bit[4] - BFee TX phy_mode error     , bit[5] - HT MCS&NSS 32 or HE DCM    , bit[6] - BFer general error, reset value: 0x0, access type: RO bit[7] BFee unexpected RXC access, bit[8]BFee lost NDP 
typedef union
{
	uint32 val;
	struct
	{
		uint32 mbfmGlobalErrIrq : 1; //Error Interrupt from MBFM, reset value: 0x0, access type: RO
		uint32 bfRptAutoReplyAbortPhyModeIrq : 1; //Error Interrupt from MBFM for the case that TX phy mode disables Bfee transmit, reset value: 0x0, access type: RO
		uint32 reserved0 : 2;
		uint32 mbfmGlobalErrIrqCauseFifoOverflow : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeZeroLength : 1;
		uint32 mbfmGlobalErrIrqCauseBferAuthenticationFailed : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeNtxError : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeTxPhyModeError : 1;
		uint32 mbfmGlobalErrIrqCauseHtMcsNss32OrDcm : 1;
		uint32 mbfmGlobalErrIrqCauseBferGeneralError : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeUnexpectedRxcAccess : 1;
		uint32 mbfmGlobalErrIrqCauseBfeeLostNdp : 1;
		uint32 mbfmGlobalErrIrqBfeeGeneralError  : 1;
		uint32 reserved1 : 2;	
		uint32 mbfmGlobalErrIrqEnCauseFifoOverflow : 1;
		uint32 mbfmGlobalErrIrqEnCauseBfeeZeroLength : 1;
		uint32 mbfmGlobalErrIrqEnCauseBferAuthenticationFailed : 1;
		uint32 mbfmGlobalErrIrqEnCauseBfeeNtxError : 1;
		uint32 mbfmGlobalErrIrqEnCauseBfeeTxPhyModeError : 1;
		uint32 mbfmGlobalErrIrqEnCauseHtMcsNss32OrDcm : 1;
		uint32 mbfmGlobalErrIrqEnCauseBferGeneralError : 1;
		uint32 mbfmGlobalErrIrqEnCauseBfeeUnexpectedRxcAccess : 1;
		uint32 mbfmGlobalErrIrqEnCauseBfeeLostNdp : 1;
		uint32 mbfmGlobalErrIrqEnCauseBfeeGeneralError : 1;
		uint32 reserved2 : 6;
	}bitFields;
}MacBfmIsrCtrl_t;

#endif //ENET_INC_ARCH_WAVE600B

/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/
void HwMbfm_ErrorFifoHandler(void);
void HwMbfm_isrError(void);
void HwMbfm_CheckFifoError(void);
void HwMbfm_Init(void);

#endif   /* HW_MBFM_API_H_ */
