/***********************************************************************************
 File:		HwMbfm.c
 Module:		Hw MAC Beamforming
 Purpose:		
 Description:	FW driver for Hw MAC Beamforming Module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "ShramBeamforming.h"
#include "loggerAPI.h"
#include "VapDb.h"
#include "ieee80211.h"
#include "MacBfmRegs.h"
#include "HwMbfm_Api.h"

/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_HW_DRIVERS
#define LOG_LOCAL_FID 	3

#define HW_BEAMORMING_RU_END_20MHZ				(8)		// value taken from system doc: SAS - Beamforming.doc
#define HW_BEAMORMING_RU_END_40MHZ				(17)	// value taken from system doc: SAS - Beamforming.doc
#define HW_BEAMORMING_RU_END_80MHZ				(36)	// value taken from system doc: SAS - Beamforming.doc
#define HW_BEAMORMING_RU_END_160MHZ				(73)	// value taken from system doc: SAS - Beamforming.doc


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/
uint32 HwEventsBeamFormingErrorFifoNotEmpty_counter = 0;

/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/


/**********************************************************************************

HwMbfm_ErrorFifoHandler

Description:
------------
	read from hw mbfm error fifo upon error
	currently only raise a counter
	
Input:
-----
Output:
-------
	
Returns:
--------
	void - 
**********************************************************************************/
void HwMbfm_ErrorFifoHandler(void)
{

	RegMacBfmMbfmFifoRdEntriesNum_u regMacBfmMbfmFifoRdEntriesNum;
	RegMacBfmMbfmFifoNumEntriesCount_u regMacBfmMbfmFifoNumEntriesCount;

	regMacBfmMbfmFifoRdEntriesNum.val = 0;
	regMacBfmMbfmFifoNumEntriesCount.val = 0;

    RegAccess_Read(REG_MAC_BFM_MBFM_FIFO_NUM_ENTRIES_COUNT, &regMacBfmMbfmFifoNumEntriesCount.val);	
	
	regMacBfmMbfmFifoRdEntriesNum.bitFields.swMbfmFifoRdEntriesNum = regMacBfmMbfmFifoNumEntriesCount.bitFields.swMbfmFifoNumEntriesCount;
	
	//this must not be a fatal because it depends on how station transmits its bf report
	//currently only count the number of times this error occured
	HwEventsBeamFormingErrorFifoNotEmpty_counter += regMacBfmMbfmFifoRdEntriesNum.bitFields.swMbfmFifoRdEntriesNum;

	//decrement counter by number of read reports
	RegAccess_Write(REG_MAC_BFM_MBFM_FIFO_RD_ENTRIES_NUM, regMacBfmMbfmFifoRdEntriesNum.val);

}


/**********************************************************************************

HwMbfm_Init 

Description:
------------
	Enable MAC Beamforming module HW
	Configure required base addreses 

Input:
-----
Output:
-------
	
Returns:
--------
	void - 
**********************************************************************************/
void HwMbfm_Init(void)
{
	RegMacBfmMbfmCfgOt_u 			 bfmCfgOtReg;
	RegMacBfmMbfmFifoBaseAddr_u 	 bfmMbfmFifoBaseAddr;
	RegMacBfmMbfmFifoDepthMinusOne_u bfmMbfmFifoDepthMinusOne;

	// Init base address of the Error FIFO
	bfmMbfmFifoBaseAddr.val = 0;
	
#if defined(ENET_INC_LMAC0) 
	memset(BeamformingErrorFifo,	0, (sizeof(BeamformingErrorFifo)));
	bfmMbfmFifoBaseAddr.bitFields.swMbfmFifoBaseAddr = CONVERT_PHYSICAL_TO_SHRAM_OFFSET(&BeamformingErrorFifo[0]);
#endif
		
#if defined(ENET_INC_LMAC1) 
	memset(BeamformingErrorFifo_B1,	0, (sizeof(BeamformingErrorFifo_B1)));
	bfmMbfmFifoBaseAddr.bitFields.swMbfmFifoBaseAddr = CONVERT_PHYSICAL_TO_SHRAM_OFFSET(&BeamformingErrorFifo_B1[0]);
#endif

	RegAccess_Write(REG_MAC_BFM_MBFM_FIFO_BASE_ADDR, bfmMbfmFifoBaseAddr.val);


	// Init FIFO size of the error FIFO (16 entries of 8 bytes)
	bfmMbfmFifoDepthMinusOne.val = 0;
	bfmMbfmFifoDepthMinusOne.bitFields.swMbfmFifoDepthMinusOne = HW_BEAMFORMING_FIFO_DEPTH_MINUS_ONE;
	RegAccess_Write(REG_MAC_BFM_MBFM_FIFO_DEPTH_MINUS_ONE, bfmMbfmFifoDepthMinusOne.val);



	// Init One Time register
	
	// HW asks to read modify write this register in order to keep the default value of the field "sw_limit_pipe_flow_control" & "sw_shift_reg_timeout"
	RegAccess_Read(REG_MAC_BFM_MBFM_CFG_OT, &(bfmCfgOtReg.val));

	// The following fields are hooks for HW bugs */
	bfmCfgOtReg.bitFields.swCheckFeedbackSegments = 1;	// Software configures whether to verify that feedback segments fields are 0 as part of MIMO control validation , 1'b1 - verify the feedback segments fields  , 1'b0 - ignore the feedback segments fields 
	bfmCfgOtReg.bitFields.swCheckHeRuEnd		  = 1;	// Software configures whether to verify the RU END field for HE BFRs as part of MIMO control validation , 1'b1 - verify the RU END field  , 1'b0 - ignore the RU END field 
	bfmCfgOtReg.bitFields.swCheckHeRuStart		  = 1;	// Software configures whether to verify the RU START field for HE BFRs as part of MIMO control validation , 1'b1 - verify the RU START field is 0 , 1'b0 - ignore the RU START field 
	bfmCfgOtReg.bitFields.swCheckBwInHt		  	  = 1;  // Software configures whether to verify the exact BW in HT mode as part of MIMO control validation , 1'b1 - verify the BW field  , 1'b0 - ignore the BW field
	bfmCfgOtReg.bitFields.swCheckBw		 		  = 1;  // Software configures whether to verify the exact BW for all phy modes as part of MIMO control validation , 1'b1 - verify the BW field  , 1'b0 - ignore the BW field
	bfmCfgOtReg.bitFields.swCheckSoundingModeHe	  = 1;  // whether to verify that each MIMO control in TB response is indeed HE format , 1 - check this match , 0 - Ignore checking and allow also VHT/HT formats
	bfmCfgOtReg.bitFields.swLengthCheckEn		  = 1;	// whether to check BFR MPDU length calculated by RXC (from delimiter) to the MPDU length calculated by the MBFM according to mimo control fields.	, Software must modify this bit prior to setting sw_clr_expected_bfr_pulse , 1'b1 - check length , 1'b0 - don't check length.
	bfmCfgOtReg.bitFields.swCheckPhyMode		  = 1;	// Software configures whether to verify the exact phy mode as part of MIMO control validation , 1'b1 - verify the PHY mode field  , 1'b0 - ignore the PHY mode field, and use Action + Category to decide the phy mode
	bfmCfgOtReg.bitFields.swCheckNgHeMu		  	  = 1;  // Software configures whether to verify the exact value of received Ng in HE MU report as part of MIMO control validation , 1'b1 - verify the Ng field  , 1'b0 - ignore the Ng field check
	bfmCfgOtReg.bitFields.swCheckCodebookHeMu	  = 1;	// Software configures whether to verify the exact value of received codebook in HE MU report as part of MIMO control validation , 1'b1 - verify the codebook field  , 1'b0 - ignore the codebook field check
	bfmCfgOtReg.bitFields.swCheckFeedbackType	  = 1;	// This field manipulates the feedback type field matching as part of MIMO control check , 1'b1 - validate exact match , 1'b0 - allow MBFM to parse SU report in case of requested MU report. This SU report will only update the SU database and not MU DB.
	bfmCfgOtReg.bitFields.swMuBfrWithoutDSnr	  = 0;	// 802.11 spec expects Delta SNR after the phases stage. Write 1'b0 to this field to support MU report with no delta SNR.
	bfmCfgOtReg.bitFields.swAuthCheckEn		  	  = 1;  // whether to check ADDR1 & ADDR2 in the MPDU as part of the BFR validity checks. This is a global configuration for all the BFRs processed by the MBFM.  , Software must modify this bit prior to setting sw_clr_expected_bfr_pulse , 1'b1 - check those fields , 1'b0 - don't check those fields.
	bfmCfgOtReg.bitFields.swHeSuBfrWithDSnr       = 0;	

	RegAccess_Write(REG_MAC_BFM_MBFM_CFG_OT, bfmCfgOtReg.val);

	
}





