/***********************************************************************************
 File:			HwQManager_API.h
 Module:		Hw Q Manager
 Purpose: 		
 Description:	
************************************************************************************/
#ifndef HW_Q_MANAGER_API_H_
#define HW_Q_MANAGER_API_H_
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "PacketDescriptor.h"
#if defined (ENET_INC_ARCH_WAVE600)
#include "RxMpduDescriptor_Descriptors.h"
#include "TxMpduDescriptor_Descriptors.h"
#endif
#if defined(ENET_INC_UMAC)
#include "Ager_Api.h"
#endif /* #if defined(ENET_INC_UMAC) */
/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define HW_Q_MANAGER_LIST_BIT_IS_SET_MASK 0x1
#define HW_Q_MANAGER_SHIFT_TO_NEXT_LIST 1

typedef enum HwQMangerRequestType
{
	HW_Q_MANAGER_PUSH_PACKET_TO_TAIL = 0,
	HW_Q_MANAGER_PUSH_PACKET_TO_HEAD,
	HW_Q_MANAGER_POP_PACKET,
	HW_Q_MANAGER_PEEK_PACKET,
	HW_Q_MANAGER_PUSH_PACKET_LIST_TO_TAIL,
	HW_Q_MANAGER_PUSH_PACKET_LIST_TO_HEAD,
	HW_Q_MANAGER_POP_PACKET_LIST,
	HW_Q_MANAGER_FLUSH,
	HW_Q_MANAGER_NUM_OF_REQUESTS,
	HW_Q_MANAGER_MAX_NUM_OF_REQUESTS = 0xF,
} HwQMangerRequestType_e;

typedef enum HwQMangerDlmNum
{
	HW_Q_MANAGER_TX_DATA_DLM = 0,
	HW_Q_MANAGER_TX_LISTS_DLM,
	HW_Q_MANAGER_RX_DATA_DLM,
	HW_Q_MANAGER_RX_LISTS_DLM,
#if defined (ENET_INC_ARCH_WAVE600)	
	HW_Q_MANAGER_DMA_LISTS_DLM,
	HW_Q_MANAGER_RX_MPDU_DESCRIPTOR_BAND0_LISTS_DLM,
	HW_Q_MANAGER_RX_MPDU_DESCRIPTOR_BAND1_LISTS_DLM,
	HW_Q_MANAGER_TX_MPDU_DESCRIPTOR_BAND0_LISTS_DLM,
	HW_Q_MANAGER_TX_MPDU_DESCRIPTOR_BAND1_LISTS_DLM,	
#endif	
	HW_Q_MANAGER_NUM_OF_DLM,
	HW_Q_MANAGER_MAX_NUM_OF_DLM = 0xF,
} HwQMangerDlmNum_e;


typedef enum HwQMangerTxListDone
{ // In gen6 each group of lists has 16 indexes. In gen5 there are 8.
    HW_Q_MANAGER_DONE_LIST_HOST_DATA  = 0,
    HW_Q_MANAGER_DONE_LIST_DISCARDED_PACKETS, 
    HW_Q_MANAGER_DONE_LIST_MANAGEMENT_FROM_FW,
	HW_Q_MANAGER_DONE_LIST_MANAGEMENT_FROM_HOST,	
    HW_Q_MANAGER_DONE_LIST_RELIABLE_MULTICAST,
    HW_Q_MANAGER_DONE_LIST_PS_SETTINGS_HW,
#if defined (AGER_STATUS_WORKAROUND)
	HW_Q_MANAGER_DONE_LIST_AGER_LIBERATOR,
#endif
	HW_Q_MANAGER_DONE_LIST_ERROR,
    HW_Q_MANAGER_DONE_LIST_LAST_DONE_LIST_HANDLED_BY_FW,
    HW_Q_MANAGER_DONE_LIST_LIBERATOR = HW_Q_MANAGER_DONE_LIST_LAST_DONE_LIST_HANDLED_BY_FW,
    NUM_HW_Q_MANAGER_DONE_LIST,
    MAX_HW_Q_MANAGER_DONE_LIST = MAX_UINT8
}TxDoneQueues_e;


typedef enum HwQMangerLowPrTxListReady
{
#if defined (ENET_INC_ARCH_WAVE600) // In gen6 each group of lists has 16 indexes. In gen5 there are 8.
	HW_Q_MANAGER_LOW_PR_READY_LIST_TEMP_HOST_Q = 16,
#else	
	HW_Q_MANAGER_LOW_PR_READY_LIST_TEMP_HOST_Q = 8,
#endif	
	HW_Q_MANAGER_LOW_PR_READY_LIST_AGER,
    NUM_HW_Q_MANAGER_LOW_PR_READY_LIST,
    MAX_HW_Q_MANAGER_LOW_PR_READY_LIST = MAX_UINT8
}HwQMangerLowPrTxListReady_e;

typedef enum HwQMangerTxListReady
{
#if defined (ENET_INC_ARCH_WAVE600)	// In gen6 each group of lists has 16 indexes. In gen5 there are 8.
	HW_Q_MANAGER_READY_LIST_UNICAST_PD = 32,
#else
	HW_Q_MANAGER_READY_LIST_UNICAST_PD = 16,
#endif
	HW_Q_MANAGER_READY_LIST_MULTICAST_PD,
	HW_Q_MANAGER_READY_LIST_LOGGER_FULL_BD,
	HW_Q_MANAGER_READY_LIST_AGER_TEMPORARY_LIST,
    NUM_HW_Q_MANAGER_READY_LIST,
    MAX_HW_Q_MANAGER_READY_LIST = MAX_UINT8
}HwQMangerTxListReady_e;

typedef enum HwQMangerTxPoolLists
{
#if defined (ENET_INC_ARCH_WAVE600)	// In gen6 each group of lists has 16 indexes. In gen5 there are 8.
	HW_Q_MANAGER_TX_POOL_LIST_DATA_PD = 48,
#else
	HW_Q_MANAGER_TX_POOL_LIST_DATA_PD = 24,
#endif
	HW_Q_MANAGER_TX_POOL_LIST_LOGGER_FREE_BD,
	HW_Q_MANAGER_TX_POOL_LIST_PS_SETTINGTS_NDP_PD,
	NUM_HW_Q_MANAGER_TX_POOL_LIST,
	NUM_HW_Q_MANAGER_TX_LISTS = NUM_HW_Q_MANAGER_TX_POOL_LIST,
    MAX_HW_Q_MANAGER_TX_POOL_LIST = MAX_UINT8
}HwQMangerTxPoolLists_e;

typedef enum
{
	HW_Q_MANAGER_RX_DONE_FIRST_LIST								 = 0,
	HW_Q_MANAGER_RX_DONE_LIST_HOST_INTERFACE_ACCELERATOR_INPUT   = HW_Q_MANAGER_RX_DONE_FIRST_LIST,
	HW_Q_MANAGER_RX_DONE_LIST_LOGGER,
	HW_Q_MANAGER_RX_DONE_LIST_ERROR								 = 7,
	HW_Q_MANAGER_NUM_OF_RX_DONE_LISTS,
	HW_Q_MANAGER_MAX_NUM_OF_RX_DONE_LISTS                       = 0xFF,
} HwQMangerRxDoneList_e;

typedef enum
{
#if defined (ENET_INC_ARCH_WAVE600) // In gen6 each group of lists has 16 indexes. In gen5 there are 8.
	HW_Q_MANAGER_LOW_PRIORITY_RX_READY_FIRST_LIST 	= 16,
#else	
	HW_Q_MANAGER_LOW_PRIORITY_RX_READY_FIRST_LIST	= 8,		
#endif	
	HW_Q_MANAGER_RX_LIBERATOR_INPUT_LIST 			= HW_Q_MANAGER_LOW_PRIORITY_RX_READY_FIRST_LIST, 
	HW_Q_MANAGER_RX_HOST_INTERFACE_TEMP_LIST,
	HW_Q_MANAGER_RX_POST_PROCESSING_INPUT_LIST,
	HW_Q_MANAGER_LOW_PRIORITY_RX_READY_LAST_LIST 	= HW_Q_MANAGER_RX_POST_PROCESSING_INPUT_LIST,
	HW_Q_MANAGER_MAX_NUM_OF_LOW_PRIORITY_RX_READY_LISTS = 0xFF,
} HwQMangerLowPrRxReadyList_e;

#define HW_Q_MANAGER_NUM_OF_LOW_PRIORITY_RX_READY_LISTS (HW_Q_MANAGER_LOW_PRIORITY_RX_READY_LAST_LIST - HW_Q_MANAGER_LOW_PRIORITY_RX_READY_FIRST_LIST + 1) 


typedef enum
{
#if defined (ENET_INC_ARCH_WAVE600) // In gen6 each group of lists has 16 indexes. In gen5 there are 8.
	HW_Q_MANAGER_HIGH_PRIORITY_RX_READY_FIRST_LIST = 32,
#else	
	HW_Q_MANAGER_HIGH_PRIORITY_RX_READY_FIRST_LIST = 16,	
#endif		
	HW_Q_MANAGER_RX_READY_LIST_FW = HW_Q_MANAGER_HIGH_PRIORITY_RX_READY_FIRST_LIST, 
	HW_Q_MANAGER_RX_READY_LIST_DRIVER,
	HW_Q_MANAGER_RX_READY_LIST_DATA_TEMPORARY_FORWARD_TO_FW,
	HW_Q_MANAGER_RX_READY_LIST_ERROR_RDS,
    HW_Q_MANAGER_RX_READY_LIST_RELEASE_FORWARD_RDS,
    HW_Q_MANAGER_RX_READY_LIST_BAD_PTR_RDS,
#if defined (RX_LIST_DEBUG)
	HW_Q_MANAGER_RX_READY_LIST_DEBUG,
	HW_Q_MANAGER_RX_READY_LIST_DEBUG_DROP,	
	HW_Q_MANAGER_HIGH_PRIORITY_RX_READY_LAST_LIST = HW_Q_MANAGER_RX_READY_LIST_DEBUG,
#else
	HW_Q_MANAGER_HIGH_PRIORITY_RX_READY_LAST_LIST			  = HW_Q_MANAGER_RX_READY_LIST_BAD_PTR_RDS,
#endif
	HW_Q_MANAGER_MAX_NUM_OF_HIGH_PRIORITY_RX_READY_LISTS  = 0xFF,
} HwQMangerHighPrRxReadyList_e;

#define HW_Q_MANAGER_NUM_OF_HIGH_PRIORITY_RX_READY_LISTS (HW_Q_MANAGER_HIGH_PRIORITY_RX_READY_LAST_LIST - HW_Q_MANAGER_HIGH_PRIORITY_RX_READY_FIRST_LIST + 1) 


typedef enum
{
#if defined (ENET_INC_ARCH_WAVE600) // In gen6 each group of lists has 16 indexes. In gen5 there are 8.
	HW_Q_MANAGER_RX_FREE_FIRST_LIST		= 48,
#else	
	HW_Q_MANAGER_RX_FREE_FIRST_LIST 	= 24, 
#endif		
	HW_Q_MANAGER_RX_FREE_FW_RDS_LIST 	= HW_Q_MANAGER_RX_FREE_FIRST_LIST, 
	HW_Q_MANAGER_RX_FREE_HOST_RDS_LIST,
	HW_Q_MANAGER_RX_PENDING_LOGGER_RDS_LIST,
	HW_Q_MANAGER_RX_FREE_FORWARD_RDS_LIST,
    HW_Q_MANAGER_RX_FREE_MANAGEMENT_RDS_LIST,
	HW_Q_MANAGER_RX_DUMMY_RD_LIST,
    HW_Q_MANAGER_RX_POOL_LAST_LIST 		= HW_Q_MANAGER_RX_DUMMY_RD_LIST,
	HW_Q_MANAGER_MAX_NUM_OF_RX_POOL_LISTS = 0xFF,
} HwQMangerRxPoolLists_e;

#define HW_Q_MANAGER_NUM_OF_RX_FREE_POOLS_LISTS (HW_Q_MANAGER_RX_POOL_LAST_LIST - HW_Q_MANAGER_RX_FREE_FIRST_LIST + 1) 

#define HW_Q_MANAGER_NUM_OF_RX_LISTS			(32)

#if defined (ENET_INC_ARCH_WAVE600)	

typedef enum
{
	HW_Q_MANAGER_RX_MPDU_RXC_IN_LIST 			= 0,
	HW_Q_MANAGER_RX_MPDU_CLASSIFIER_IN_LIST 	= 1,
	HW_Q_MANAGER_RX_MPDU_WRAP_UP_IN_LIST 		= 2,
	HW_Q_MANAGER_RX_MPDU_POST_PPDU_PHY_LIST 	= 3,
	HW_Q_MANAGER_RX_MPDU_RXH_IN_LIST 			= 4,
	HW_Q_MANAGER_RX_MPDU_RXH_ERROR_LIST 		= 5,
	HW_Q_MANAGER_RX_MPDU_TBD6_LIST 				= 6, 
	HW_Q_MANAGER_RX_MPDU_TBD7_LIST 				= 7, 
	HW_Q_MANAGER_RX_MPDU_SECURITY_IN_0_LIST		= 8,	// 36 lists
	HW_Q_MANAGER_RX_MPDU_DEAGGREGATOR_IN_0_LIST = 44,	// 36 lists
	HW_Q_MANAGER_MAX_NUM_OF_RX_MPDU_LISTS 		= 80,	// Defined in HW Q Manager doc
} HwQMangerRxMpduLists_e;

typedef enum
{
	HW_Q_MANAGER_TX_MPDU_FREE_LIST 				= 0,
	HW_Q_MANAGER_TX_MPDU_TBD1_LIST 				= 1,
	HW_Q_MANAGER_TX_MPDU_TBD2_LIST 				= 2,
	HW_Q_MANAGER_TX_MPDU_TBD3_LIST 				= 3,
	HW_Q_MANAGER_TX_MPDU_TBD4_LIST 				= 4,
	HW_Q_MANAGER_TX_MPDU_TBD5_LIST 				= 5,
	HW_Q_MANAGER_TX_MPDU_TBD6_LIST 				= 6, 
	HW_Q_MANAGER_TX_MPDU_TBD7_LIST 				= 7,
	HW_Q_MANAGER_TX_MPDU_SECURITY_IN_0_LIST		= 8,	// 36 lists
	HW_Q_MANAGER_TX_MPDU_TX_PD_ACC_IN_0_LIST	= 44, 	// 36 lists
	HW_Q_MANAGER_TX_MPDU_DELIA_IN_0_LIST		= 80, 	// 36 lists
	HW_Q_MANAGER_MAX_NUM_OF_TX_MPDU_LISTS 		= 116,	// Defined in HW Q Manager doc
} HwQMangerTxMpduLists_e;
#endif


typedef enum RegInterfaceNum
{
	HW_Q_MANAGER_REG_IF_NUM_ONE = 0,
	HW_Q_MANAGER_REG_IF_NUM_TWO,
	HW_Q_MANAGER_TOTAL_NUM_OF_REG_IF,
} RegInterfaceNum_e;

typedef enum
{
	HW_Q_MANAGER_INT_ID_TX_DONE_LISTS = 0,
	HW_Q_MANAGER_INT_ID_RX_DONE_LISTS,
	HW_Q_MANAGER_INT_ID_LOW_PRI_TX_READY_LISTS,
	HW_Q_MANAGER_INT_ID_LOW_PRI_RX_READY_LISTS,
	HW_Q_MANAGER_INT_ID_HIGH_PRI_TX_READY_LISTS,
	HW_Q_MANAGER_INT_ID_HIGH_PRI_RX_READY_LISTS,
	HW_Q_MANAGER_INT_ID_DESC_POOL,
	HW_Q_MANAGER_INT_TOTAL_NOM_OF_INT_ID,
	HW_Q_MANAGER_INT_MAX_NUM_OF_INT_ID = 0xFF,
} HwQManagerIntId_e;

#if defined (ENET_INC_ARCH_WAVE600)

typedef enum 
{
	HW_Q_MANAGER_DLM_DMA_TX_0_FREE_LIST = 0,
	HW_Q_MANAGER_DLM_DMA_TX_1_FREE_LIST,
	HW_Q_MANAGER_DLM_DMA_RX_0_FREE_LIST,
	HW_Q_MANAGER_DLM_DMA_RX_1_FREE_LIST,
	HW_Q_MANAGER_DLM_DMA_HOST_FREE_LIST,
	HW_Q_MANAGER_DLM_DMA_FW_FREE_LIST, 
	HW_Q_MANAGER_MAX_NUM_DLM_DMA_FREE_LISTS = 0xFF,
} HwQManagerDlmDmaList_e;

#define DMAC_NUM_OF_TX_0_DESCRIPTORS	(80)
#define DMAC_NUM_OF_TX_1_DESCRIPTORS	(80)
#define DMAC_NUM_OF_RX_0_DESCRIPTORS	(80)
#define DMAC_NUM_OF_RX_1_DESCRIPTORS	(80)
#define DMAC_NUM_OF_HOST_DESCRIPTORS	(32)
#define DMAC_NUM_OF_FW_DESCRIPTORS		(32)
#define DMAC_NUM_OF_DESCRIPTORS			(DMAC_NUM_OF_TX_0_DESCRIPTORS+DMAC_NUM_OF_TX_1_DESCRIPTORS+DMAC_NUM_OF_RX_0_DESCRIPTORS+DMAC_NUM_OF_RX_1_DESCRIPTORS+DMAC_NUM_OF_HOST_DESCRIPTORS+DMAC_NUM_OF_FW_DESCRIPTORS)


/* 
	Allocating number of RX/TX MPDU descriptors is done according to Yossi Hai Amar reccommandation:

	Sizes of memory are:

	Single BAND or 3x3+1x1: 	BAND0: 36KB.	BAND1: 1KB.
	CDB (2x2):				BAND0: 18KB.	BAND1: 18KB.

	Rx MPDU descriptor size is 15 *4 bytes.
	Tx MPDU descriptor size is 10 *4 bytes.

	For single band we can use 8*36 = 288 descriptors for RX and the rest for TX.
	So, if Rx MPDU descriptor takes: 288 * 15 * 4 = 17280 Bytes ' left 19584 Byes ' You can allocate 489 Tx MPDU descriptors.
*/

#define NUM_OF_RX_MPDU_DESCRIPTORS_B0_SINGLE_BAND	(288)	
#define NUM_OF_TX_MPDU_DESCRIPTORS_B0_SINGLE_BAND	(489)	
#define NUM_OF_RX_MPDU_DESCRIPTORS_B1_SINGLE_BAND	(8)		
#define NUM_OF_TX_MPDU_DESCRIPTORS_B1_SINGLE_BAND	(13)	

#define NUM_OF_RX_MPDU_DESCRIPTORS_B0_DUAL_BAND		(144)	
#define NUM_OF_TX_MPDU_DESCRIPTORS_B0_DUAL_BAND		(244)	
#define NUM_OF_RX_MPDU_DESCRIPTORS_B1_DUAL_BAND		(144)	
#define NUM_OF_TX_MPDU_DESCRIPTORS_B1_DUAL_BAND		(244)	

typedef struct
{
	RxMpduDescriptor_t sB0_RxMpduDescriptor[NUM_OF_RX_MPDU_DESCRIPTORS_B0_SINGLE_BAND]; 
	TxMpduDescriptor_t sB0_TxMpduDescriptor[NUM_OF_TX_MPDU_DESCRIPTORS_B0_SINGLE_BAND]; 
} b0RxTxMpduDescSingleBand;

typedef struct
{
	RxMpduDescriptor_t sB0_RxMpduDescriptor[NUM_OF_RX_MPDU_DESCRIPTORS_B0_DUAL_BAND]; 
	TxMpduDescriptor_t sB0_TxMpduDescriptor[NUM_OF_TX_MPDU_DESCRIPTORS_B0_DUAL_BAND]; 
} b0RxTxMpduDescDualBand;

typedef union
{
	b0RxTxMpduDescSingleBand 	singleBandDescriptors;
	b0RxTxMpduDescDualBand		dualBandDescriptors;
} b0RxTxMpduDesc_u;

typedef struct
{
	RxMpduDescriptor_t sB1_RxMpduDescriptor[NUM_OF_RX_MPDU_DESCRIPTORS_B1_SINGLE_BAND]; 
	TxMpduDescriptor_t sB1_TxMpduDescriptor[NUM_OF_TX_MPDU_DESCRIPTORS_B1_SINGLE_BAND]; 
} b1RxTxMpduDescSingleBand;

typedef struct
{
	RxMpduDescriptor_t sB1_RxMpduDescriptor[NUM_OF_RX_MPDU_DESCRIPTORS_B1_DUAL_BAND]; 
	TxMpduDescriptor_t sB1_TxMpduDescriptor[NUM_OF_TX_MPDU_DESCRIPTORS_B1_DUAL_BAND]; 
} b1RxTxMpduDescDualBand;

typedef union
{
	b1RxTxMpduDescSingleBand 	singleBandDescriptors;
	b1RxTxMpduDescDualBand		dualBandDescriptors;
} b1RxTxMpduDesc_u;


#define SET_NEXT_DMA_DESC(dmaDescriptor) 			(((uint32*)dmaDescriptor) - (uint32*)sDmaDescriptor)
#define B0_SET_NEXT_MPDU_DESC(mpduDescriptor) 			(((uint32*)mpduDescriptor) - (uint32*)&B0_MpduDescriptors)
#define B1_SET_NEXT_MPDU_DESC(mpduDescriptor) 			(((uint32*)mpduDescriptor) - (uint32*)&B1_MpduDescriptors)

#define CONVERT_DMA_DESC_TO_OFFSET(dmaDescriptor) (((uint32 *)(dmaDescriptor)) - (uint32*)sDmaDescriptor)
#define B0_CONVERT_MPDU_DESC_TO_OFFSET(mpduDescriptor) (((uint32 *)(mpduDescriptor)) - (uint32*)&B0_MpduDescriptors)
#define B1_CONVERT_MPDU_DESC_TO_OFFSET(mpduDescriptor) (((uint32 *)(mpduDescriptor)) - (uint32*)&B1_MpduDescriptors)

#endif


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Data Type Definition						
/----------------------------------------------------------------------------------*/
typedef struct HwQueueManagerRequestParams
{
	HwQMangerDlmNum_e dlmNum;
	uint8 dplIndex;
	uint8 setNull;
	RegInterfaceNum_e regIfNum;
	uint32 primaryAddr;
	uint32 secondaryAddr;
	void *pHeadDesc;
	void *pTailDesc;
} HwQueueManagerRequestParams_t;


/*---------------------------------------------------------------------------------
/						Public Function Declaration						
/----------------------------------------------------------------------------------*/
#if defined(ENET_INC_UMAC)
void hwQManagerInitDlm(void);
#endif
void HwQManager_PushPacketToTail(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_PushPacketListToTail(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_PushPacketToHead(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_PushPacketlistToHead(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_PopPacket(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_PopListFromHead(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_PeekHeadPacket(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_FlushQ(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams);
void HwQManager_GetLowPriorityTxPdReadyListsStatus(uint32 *highPriorityTxPdReadylistStatus);
void HwQManager_GetHighPriorityTxPdReadyListsStatus(uint32 *lowPriorityTxPdReadylistStatus);
void HwQManager_ClearTxListsInt(uint32 txListIndex);
void HwQManager_ClearDisableListsInt(uint32 disableListIndex);

void HwQManager_ClearRxListsInt(uint32  rxListIndex);

void HwQManager_ErrorEvent(void);
void HwQManager_Init(void);
uint16 HwQManager_GetEmptyTxDoneLists(void);
uint16 HwQManager_GetNotEmptyTxDoneLists(void);
uint16 HwQManager_GetNotEmptyTxDisableLists(void);
uint16 HwQManager_GetNotEmptyTxReadyLoPriLists(void);
uint16 HwQManager_GetEmptyTxReadyLoPriLists(void);
uint16 HwQManager_GetNotEmptyTxReadyHiPriLists(void);
uint16 HwQManager_GetEmptyTxReadyHiPriLists(void);
uint16 HwQManager_GetNotEmptyRxReadyLists(void);
bool HwQManager_RemovePdFromQueue(HwQueueManagerRequestParams_t *hwQueueManagerRequestParams, TxPd_t* removePd);
#if defined (ENET_INC_ARCH_WAVE600)
void HwQManagerPushToDlmQ(uint8 dlmIndex, uint32 headAddr,uint32 tailAddr,uint8 dplIndex);
#endif



#if defined(ENET_INC_UMAC)
/* Ager section */
void HwQManagerAger_ConfigureAllAndActivatePeriodicCheck(AgerPeriodicCheckParameters_t  *agerCheckParameters);
void HwQManagerAger_ReconfigurePartialPeriodicCheck(AgerPeriodicCheckParameters_t  *agerCheckParameters);
void HwQManagerAger_StopPeriodicCheck(void); 
void HwQManagerAger_StartSingleCheck(AgerSingleCheckParameters_t  *agerCheckParameters, bool restrictedAc); 
void HwQManagerAger_StopPeriodicCheckAndStartSingleCheck(AgerSingleCheckParameters_t  *agerCheckParameters, bool restrictedAc);
void HwQManagerAger_GetLastCheckParameters(AgerLastCheckParametes_t *lastCheckParameters);
void HwQManagerAger_GetLastCheckCounters(AgerLastCheckCounters_t *lastCheckCounters);
void HwQManagerAger_ClearSingleCheckDoneInterrupt(void);
#if defined (ENET_INC_ARCH_WAVE600)
void HwQManagerAger_SetStaTtlVal(StaId staInd, uint16 val);
uint16 HwQManagerAger_GetStaTtlVal(StaId staInd);

#endif
void HwQManagerAger_Initialize(void);
#endif /* #if defined(ENET_INC_UMAC) */


#endif   /* HW_Q_MANAGER_API_H_ */
