/***********************************************************************************
 File:			HwSecurity.c
 Module:		Hw Security
 Purpose:		
 Description:	FW driver for Hw Q Manager Module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "HwMemoryMap.h"
#include "MacWepRegs.h"
#include "MacWep1Regs.h"
#include "MacWep2Regs.h"
#include "MacWep3Regs.h"
#include "ShramSecurity.h"



/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_HW_DRIVERS
#define LOG_LOCAL_FID 10

#define REG_MAC_WEP_COMMON_ADDRESS_MASK										(0x00ffffff)

#define REG_MAC_WEP_FULL_HW_ENC_SW_MODE  									(0x0)
#define REG_MAC_WEP_FULL_HW_ENC_HW_MODE  									(0x1)

#define REG_MAC_WEP_CCM_FC_MASK_DEFAULT										(0xc7ffc78f)
#define REG_MAC_WEP_CCM_SC_MASK_DEFAULT										(0x000f)
#define REG_MAC_WEP_CCM_QC_MASK_DEFAULT										(0x1008f)

#define REG_MAC_WEP_FULL_HW_ENC_FULL_HW_ENC_DEFAULT							(REG_MAC_WEP_FULL_HW_ENC_HW_MODE)
#define REG_MAC_WEP_FULL_HW_ENC_RC4_PRE_INIT_HW_EN_DEFAULT 					(0x1) 
#define REG_MAC_WEP_FULL_HW_ENC_DESCRIPTOR_LIST_EN_DEFAULT					(0x1)
#define REG_MAC_WEP_FULL_HW_ENC_TX_DESC_MODE_GEN_ERR_IRQ_EN_DEFAULT			(0x0)
#define REG_MAC_WEP_FULL_HW_ENC_RX_DESC_MODE_GEN_ERR_IRQ_EN_DEFAULT			(0x0)

#define REG_MAC_WEP_START_ENTRIES_ADDRESS_DB_ENTRY_SIZE_DEFAULT				(CONVERT_BYTES_TO_WORDS(SECURITY_KEY_LENGTH))
#define REG_MAC_WEP_START_ENTRIES_ADDRESS_DIFFERENT_DEST_DEFAULT			(0x1) 
#define REG_MAC_WEP_START_ENTRIES_ADDRESS_PREPARE_IV_DEFAULT				(0x1) // 0x1 = HW will prepare IV (and not SW)

#define REG_MAC_WEP_LENGTH_OFFSET_LENGTH_OFFSET_ENCRYPT_DEFAULT				(0x1)
#define REG_MAC_WEP_LENGTH_OFFSET_LENGTH_OFFSET_DECRYPT_DEFAULT				(0x6)

#define REG_MAC_WEP_TKIP_CONTROL_DEFAULT									(0x58af580b)

#define REG_MAC_WEP_TKIP_MIC_CONTROL_TKIP_MIC_CONTROL_HEADER_DEFAULT		(0x4009)

#define REG_MAC_WEP_WEP_CONTROL_DEFAULT										(0x003f000b)

#define REG_MAC_WEP_TKIP_FRAGMENT_CONTROL_DEFAULT							(0x402f402b)
#define REG_MAC_WEP_TKIP_FRAGMENT2_CONTROL_DEFAULT							(0x60895009)
#define REG_MAC_WEP_TKIP_FRAGMENT3_CONTROL_DEFAULT							(0x6009)
	
#define REG_MAC_WEP_SHRAM_MASK_WRITE_SHRAM_MASK_WRITE_DEFAULT				(0x1)

#define REG_MAC_WEP_WAPI_FC_MASK_WAPI_FC_MASK_DEFAULT						(0xc78f)
#define REG_MAC_WEP_WAPI_FC_MASK_WAPI_SC_MASK_DEFAULT						(0x000f)



/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/



/**********************************************************************************

HwSecurity_Init 

Description:
------------
	Init security HW  according to Security_engine_VLSI spec.docx (section 10.1.1)

Input:
-----
Output:
-------
	
Returns:
--------
	void - 
**********************************************************************************/
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))
#pragma ghs section text=".initialization" 
#endif
void HwSecurity_Init(void)
{
	RegMacWepCcmFcMask_u 			WepCcmFcMask;
	RegMacWepCcmScMask_u 			WepCcmScMask;
	RegMacWepCcmQcMask_u 			WepCcmQcMask;
	RegMacWepMutedHdrAddress_u 		WepMutedHdrAddress;
	RegMacWepFullHwEnc_u 			WepFullHwEnc;
	RegMacWepStartEntriesAddress_u 	WepStartEntriesAddress;
	RegMacWepTkipControl_u 			WepTkipControl;
	RegMacWepTkipMicControl_u 		WepTkipMicControl;
	RegMacWepWepControl_u 			WepControl;
	RegMacWepTkipFragmentControl_u 	WepTkipFragmentControl;
	RegMacWepShramMaskWrite_u 		WepShramMaskWrite;
	RegMacWepWapiFcMask_u 			WepWapiFcMask;
	RegMacWepWapiScMask_u 			WepWapiScMask;
	RegMacWepFragmentDbBaseAddr_u 	WepFragmentDbBaseAddr;
	RegMacWepTkipFragment2Control_u WepTkipFragment2Control;
	RegMacWepTxDescListBaseAddr_u 	WepTxDescListBaseAddr;
	RegMacWepTkipFragment3Control_u WepTkipFragment3Control;
	RegMacWepRxDescListBaseAddr_u   wepRxDescListBaseAddr;

	memset(tkipFragmentDb, 			0, sizeof(uint8)*(HW_NUM_OF_STATIONS*SIZE_OF_TKIP_FRAGMENT_DB_ENTRY));
	memset(KeysDatabase, 			0, sizeof(KeyValuesEntry)*(HW_NUM_OF_VAPS + HW_NUM_OF_STATIONS));
	memset(mutedHeaderScratchPad, 	0, sizeof(mutedHeaderScratchPad));	

	WepCcmFcMask.val = REG_MAC_WEP_CCM_FC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_CCM_FC_MASK, WepCcmFcMask.val);
	RegAccess_Write(REG_MAC_WEP1_CCM_FC_MASK, WepCcmFcMask.val);
	RegAccess_Write(REG_MAC_WEP2_CCM_FC_MASK, WepCcmFcMask.val);
	RegAccess_Write(REG_MAC_WEP3_CCM_FC_MASK, WepCcmFcMask.val);

	WepCcmScMask.bitFields.ccmScMask = REG_MAC_WEP_CCM_SC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_CCM_SC_MASK, WepCcmScMask.val);
	RegAccess_Write(REG_MAC_WEP1_CCM_SC_MASK, WepCcmScMask.val);
	RegAccess_Write(REG_MAC_WEP2_CCM_SC_MASK, WepCcmScMask.val);
	RegAccess_Write(REG_MAC_WEP3_CCM_SC_MASK, WepCcmScMask.val);

	WepCcmQcMask.val = REG_MAC_WEP_CCM_QC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_CCM_QC_MASK, WepCcmQcMask.val);
	RegAccess_Write(REG_MAC_WEP1_CCM_QC_MASK, WepCcmQcMask.val);
	RegAccess_Write(REG_MAC_WEP2_CCM_QC_MASK, WepCcmQcMask.val);
	RegAccess_Write(REG_MAC_WEP3_CCM_QC_MASK, WepCcmQcMask.val);

	WepMutedHdrAddress.bitFields.mutedHdrAddress = (((uint32)&(mutedHeaderScratchPad[0][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP_MUTED_HDR_ADDRESS, WepMutedHdrAddress.val);
	WepMutedHdrAddress.bitFields.mutedHdrAddress = (((uint32)&(mutedHeaderScratchPad[1][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP1_MUTED_HDR_ADDRESS, WepMutedHdrAddress.val);
	WepMutedHdrAddress.bitFields.mutedHdrAddress = (((uint32)&(mutedHeaderScratchPad[2][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP2_MUTED_HDR_ADDRESS, WepMutedHdrAddress.val);
	WepMutedHdrAddress.bitFields.mutedHdrAddress = (((uint32)&(mutedHeaderScratchPad[3][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP3_MUTED_HDR_ADDRESS, WepMutedHdrAddress.val);

	WepFullHwEnc.bitFields.fullHwEnc = REG_MAC_WEP_FULL_HW_ENC_FULL_HW_ENC_DEFAULT;
	WepFullHwEnc.bitFields.rc4PreInitHwEn = REG_MAC_WEP_FULL_HW_ENC_RC4_PRE_INIT_HW_EN_DEFAULT; 
	WepFullHwEnc.bitFields.descriptorListEn = REG_MAC_WEP_FULL_HW_ENC_DESCRIPTOR_LIST_EN_DEFAULT; 
	WepFullHwEnc.bitFields.txDescModeGenErrIrqEn = TRUE;
	WepFullHwEnc.bitFields.rxDescModeGenErrIrqEn = REG_MAC_WEP_FULL_HW_ENC_RX_DESC_MODE_GEN_ERR_IRQ_EN_DEFAULT;	
	RegAccess_Write(REG_MAC_WEP_FULL_HW_ENC, WepFullHwEnc.val);
	RegAccess_Write(REG_MAC_WEP1_FULL_HW_ENC, WepFullHwEnc.val);
	RegAccess_Write(REG_MAC_WEP2_FULL_HW_ENC, WepFullHwEnc.val);
	RegAccess_Write(REG_MAC_WEP3_FULL_HW_ENC, WepFullHwEnc.val);

	WepStartEntriesAddress.bitFields.startEntriesAddress = (((uint32)KeysDatabase) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	WepStartEntriesAddress.bitFields.dbEntrySize = REG_MAC_WEP_START_ENTRIES_ADDRESS_DB_ENTRY_SIZE_DEFAULT;
	WepStartEntriesAddress.bitFields.differentDest = REG_MAC_WEP_START_ENTRIES_ADDRESS_DIFFERENT_DEST_DEFAULT; 
	WepStartEntriesAddress.bitFields.prepareIv = REG_MAC_WEP_START_ENTRIES_ADDRESS_PREPARE_IV_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_START_ENTRIES_ADDRESS, WepStartEntriesAddress.val);
	RegAccess_Write(REG_MAC_WEP1_START_ENTRIES_ADDRESS, WepStartEntriesAddress.val);
	RegAccess_Write(REG_MAC_WEP2_START_ENTRIES_ADDRESS, WepStartEntriesAddress.val);
	RegAccess_Write(REG_MAC_WEP3_START_ENTRIES_ADDRESS, WepStartEntriesAddress.val);

	WepTkipControl.val = REG_MAC_WEP_TKIP_CONTROL_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_TKIP_CONTROL, WepTkipControl.val);
	RegAccess_Write(REG_MAC_WEP1_TKIP_CONTROL, WepTkipControl.val);
	RegAccess_Write(REG_MAC_WEP2_TKIP_CONTROL, WepTkipControl.val);
	RegAccess_Write(REG_MAC_WEP3_TKIP_CONTROL, WepTkipControl.val);

	WepTkipMicControl.bitFields.tkipMicControlHeader = REG_MAC_WEP_TKIP_MIC_CONTROL_TKIP_MIC_CONTROL_HEADER_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_TKIP_MIC_CONTROL, WepTkipMicControl.val);
	RegAccess_Write(REG_MAC_WEP1_TKIP_MIC_CONTROL, WepTkipMicControl.val);
	RegAccess_Write(REG_MAC_WEP2_TKIP_MIC_CONTROL, WepTkipMicControl.val);
	RegAccess_Write(REG_MAC_WEP3_TKIP_MIC_CONTROL, WepTkipMicControl.val);

	WepControl.val = REG_MAC_WEP_WEP_CONTROL_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_WEP_CONTROL, WepControl.val);
	RegAccess_Write(REG_MAC_WEP1_WEP_CONTROL, WepControl.val);
	RegAccess_Write(REG_MAC_WEP2_WEP_CONTROL, WepControl.val);
	RegAccess_Write(REG_MAC_WEP3_WEP_CONTROL, WepControl.val);

	WepTkipFragmentControl.val = REG_MAC_WEP_TKIP_FRAGMENT_CONTROL_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_TKIP_FRAGMENT_CONTROL, WepTkipFragmentControl.val);
	RegAccess_Write(REG_MAC_WEP1_TKIP_FRAGMENT_CONTROL, WepTkipFragmentControl.val);
	RegAccess_Write(REG_MAC_WEP2_TKIP_FRAGMENT_CONTROL, WepTkipFragmentControl.val);
	RegAccess_Write(REG_MAC_WEP3_TKIP_FRAGMENT_CONTROL, WepTkipFragmentControl.val);

	WepShramMaskWrite.bitFields.shramMaskWrite = REG_MAC_WEP_SHRAM_MASK_WRITE_SHRAM_MASK_WRITE_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_SHRAM_MASK_WRITE, WepShramMaskWrite.val);
	RegAccess_Write(REG_MAC_WEP1_SHRAM_MASK_WRITE, WepShramMaskWrite.val);
	RegAccess_Write(REG_MAC_WEP2_SHRAM_MASK_WRITE, WepShramMaskWrite.val);
	RegAccess_Write(REG_MAC_WEP3_SHRAM_MASK_WRITE, WepShramMaskWrite.val);

	WepWapiFcMask.bitFields.wapiFcMask = REG_MAC_WEP_WAPI_FC_MASK_WAPI_FC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_WAPI_FC_MASK, WepWapiFcMask.val);
	RegAccess_Write(REG_MAC_WEP1_WAPI_FC_MASK, WepWapiFcMask.val);
	RegAccess_Write(REG_MAC_WEP2_WAPI_FC_MASK, WepWapiFcMask.val);
	RegAccess_Write(REG_MAC_WEP3_WAPI_FC_MASK, WepWapiFcMask.val);

	WepWapiScMask.bitFields.wapiScMask = REG_MAC_WEP_WAPI_FC_MASK_WAPI_SC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_WAPI_SC_MASK, WepWapiScMask.val);
	RegAccess_Write(REG_MAC_WEP1_WAPI_SC_MASK, WepWapiScMask.val);
	RegAccess_Write(REG_MAC_WEP2_WAPI_SC_MASK, WepWapiScMask.val);
	RegAccess_Write(REG_MAC_WEP3_WAPI_SC_MASK, WepWapiScMask.val);

	WepFragmentDbBaseAddr.bitFields.fragmentDbBaseAddr = (((uint32)tkipFragmentDb)  & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP_FRAGMENT_DB_BASE_ADDR, WepFragmentDbBaseAddr.val);
	RegAccess_Write(REG_MAC_WEP1_FRAGMENT_DB_BASE_ADDR, WepFragmentDbBaseAddr.val);
	RegAccess_Write(REG_MAC_WEP2_FRAGMENT_DB_BASE_ADDR, WepFragmentDbBaseAddr.val);
	RegAccess_Write(REG_MAC_WEP3_FRAGMENT_DB_BASE_ADDR, WepFragmentDbBaseAddr.val);

	WepTkipFragment2Control.val = REG_MAC_WEP_TKIP_FRAGMENT2_CONTROL_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_TKIP_FRAGMENT2_CONTROL, WepTkipFragment2Control.val);
	RegAccess_Write(REG_MAC_WEP1_TKIP_FRAGMENT2_CONTROL, WepTkipFragment2Control.val);
	RegAccess_Write(REG_MAC_WEP2_TKIP_FRAGMENT2_CONTROL, WepTkipFragment2Control.val);
	RegAccess_Write(REG_MAC_WEP3_TKIP_FRAGMENT2_CONTROL, WepTkipFragment2Control.val);

	WepTxDescListBaseAddr.bitFields.txDescListBaseAddr = (((uint32)&(txSecurityDescriptors[0][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP_TX_DESC_LIST_BASE_ADDR, WepTxDescListBaseAddr.val);
	WepTxDescListBaseAddr.bitFields.txDescListBaseAddr = (((uint32)&(txSecurityDescriptors[1][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP1_TX_DESC_LIST_BASE_ADDR, WepTxDescListBaseAddr.val);
	WepTxDescListBaseAddr.bitFields.txDescListBaseAddr = (((uint32)&(txSecurityDescriptors[2][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP2_TX_DESC_LIST_BASE_ADDR, WepTxDescListBaseAddr.val);
	WepTxDescListBaseAddr.bitFields.txDescListBaseAddr = (((uint32)&(txSecurityDescriptors[3][0])) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP3_TX_DESC_LIST_BASE_ADDR, WepTxDescListBaseAddr.val);

	WepTkipFragment3Control.val = REG_MAC_WEP_TKIP_FRAGMENT3_CONTROL_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_TKIP_FRAGMENT3_CONTROL, WepTkipFragment3Control.val);
	RegAccess_Write(REG_MAC_WEP1_TKIP_FRAGMENT3_CONTROL, WepTkipFragment3Control.val);
	RegAccess_Write(REG_MAC_WEP2_TKIP_FRAGMENT3_CONTROL, WepTkipFragment3Control.val);
	RegAccess_Write(REG_MAC_WEP3_TKIP_FRAGMENT3_CONTROL, WepTkipFragment3Control.val);

	wepRxDescListBaseAddr.bitFields.rxDescListBaseAddr = (((uint32)rxSecurityDescriptors) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP_RX_DESC_LIST_BASE_ADDR, wepRxDescListBaseAddr.val);
	RegAccess_Write(REG_MAC_WEP1_RX_DESC_LIST_BASE_ADDR, wepRxDescListBaseAddr.val);
	RegAccess_Write(REG_MAC_WEP2_RX_DESC_LIST_BASE_ADDR, wepRxDescListBaseAddr.val);
	RegAccess_Write(REG_MAC_WEP3_RX_DESC_LIST_BASE_ADDR, wepRxDescListBaseAddr.val);
}
#if (defined (ENET_INC_UMAC) && !defined (ENET_INC_ARCH_WAVE600))

#pragma ghs section text=default

#endif


