/***********************************************************************************
 File:			HwSecurity.c
 Module:		Hw Security
 Purpose:		
 Description:	FW driver for HwSecurity Module
************************************************************************************/
/*---------------------------------------------------------------------------------
/						Includes						
/----------------------------------------------------------------------------------*/
#include "System_Configuration.h"
#include "System_GlobalDefinitions.h"
#include "HwGlobalDefinitions.h"
#include "RegAccess_Api.h"
#include "stringLibApi.h"
#include "ErrorHandler_Api.h"
#include "loggerAPI.h"
#include "HwMemoryMap.h"
#include "MacWepRegs.h"
#include "ShramSecurity.h"
#include "HwSecurity_API.h"


/*---------------------------------------------------------------------------------
/						Defines						
/----------------------------------------------------------------------------------*/
#define LOG_LOCAL_GID   GLOBAL_GID_HW_DRIVERS
#define LOG_LOCAL_FID 11

#define REG_MAC_WEP_COMMON_ADDRESS_MASK										(0x00ffffff)

#define REG_MAC_WEP_FULL_HW_ENC_SW_MODE  									(0x0)
#define REG_MAC_WEP_FULL_HW_ENC_HW_MODE  									(0x1)

#define REG_MAC_WEP_CCM_FC_MASK_DEFAULT										(0xc7ffc78f)
#define REG_MAC_WEP_CCM_SC_MASK_DEFAULT										(0x000f)
#define REG_MAC_WEP_CCM_QC_MASK_DEFAULT										(0x1008f)

#define REG_MAC_WEP_FULL_HW_ENC_FULL_HW_ENC_DEFAULT							(REG_MAC_WEP_FULL_HW_ENC_HW_MODE)
#define REG_MAC_WEP_FULL_HW_ENC_RC4_PRE_INIT_HW_EN_DEFAULT 					(0x1) 
#define REG_MAC_WEP_FULL_HW_ENC_DESCRIPTOR_LIST_EN_DEFAULT					(0x1)

#define REG_MAC_WEP_START_ENTRIES_ADDRESS_DB_ENTRY_SIZE_DEFAULT				(CONVERT_BYTES_TO_WORDS(SECURITY_KEY_LENGTH))
#define REG_MAC_WEP_START_ENTRIES_ADDRESS_DIFFERENT_DEST_DEFAULT			(0x1) // 0x1 = HW to start writing after MPDU header and not after SEC header, since prepare_iv=1
#define REG_MAC_WEP_START_ENTRIES_ADDRESS_PREPARE_IV_DEFAULT				(0x1) // 0x1 = HW will prepare IV (and not SW)

#define REG_MAC_WEP_LENGTH_OFFSET_LENGTH_OFFSET_ENCRYPT_DEFAULT				(0x1)
#define REG_MAC_WEP_LENGTH_OFFSET_LENGTH_OFFSET_DECRYPT_DEFAULT				(0x6)


/*---------------------------------------------------------------------------------
/						Macros						
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Function Declaration									
/----------------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------------
/						Static Variables									
/----------------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------------
/						Static Functions Definitions									
/----------------------------------------------------------------------------------*/

#ifdef ENET_INC_ARCH_WAVE600
/**********************************************************************************
HwSecurity_EnableDisableLogger  

Description:
------------
	Enable / Disable logs from the HwSecurity

Input:
-----
	Enable/Disable	
Output:
-------
	None
	
**********************************************************************************/
void HwSecurity_EnableDisableLogger(bool isEnable)
{
	RegMacWepSecLogger_u WepSecLoggerCfgReg;

	WepSecLoggerCfgReg.val = 0;
	WepSecLoggerCfgReg.bitFields.secLoggerEn 		= isEnable;
	WepSecLoggerCfgReg.bitFields.secLoggerPriority  = LOGGER_HW_DEFAULT_PRIORITY;
	RegAccess_Write(REG_MAC_WEP_SEC_LOGGER, WepSecLoggerCfgReg.val);
}


void HwSecurity_TxEndSecurityNotInIdleError(uint32 deliaStatus)
{
	UNUSED_PARAM(deliaStatus);
	ILOG0_D("HwSecurity_TxEndSecurityNotInIdleError, delia status = %d", deliaStatus);
	FATAL("HwSecurity_TxEndSecurityNotInIdleError");
}

#endif
/**********************************************************************************

HwSecurity_Init 

Description:
------------
	Init security HW  according to Security_engine_VLSI spec.docx (section 10.1.1)

Input:
-----
Output:
-------
	
Returns:
--------
	void - 
**********************************************************************************/
void HwSecurity_Init(void)
{
	RegMacWepCcmFcMask_u 			WepCcmFcMask;
	RegMacWepCcmScMask_u 			WepCcmScMask;
	RegMacWepCcmQcMask_u 			WepCcmQcMask;
	RegMacWepFullHwEnc_u 			WepFullHwEnc;
	RegMacWepStartEntriesAddress_u 	WepStartEntriesAddress;
	RegMacWepLengthOffset_u 		WepLengthOffset;
	RegMacWepFragmentDbBaseAddr_u 	WepFragmentDbBaseAddr;
	RegMacWepDlmFcControl_u			WepDlmFcControl;
//	RegMacWepDlmMpduListIdxOut_u	WepDlmMpduListIdxOut;

	// KeysDatabase and tkipFragmentDb are in SHRAM. They should be initialized only once. So we do it in LM0 which is always working.
#if defined(ENET_INC_LMAC0) 
	memset(tkipFragmentDb, 			0, sizeof(uint8)*(HW_NUM_OF_STATIONS*SIZE_OF_TKIP_FRAGMENT_DB_ENTRY));
	memset(KeysDatabase, 			0, sizeof(KeyValuesEntry)*(HW_NUM_OF_VAPS + HW_NUM_OF_STATIONS));
#endif
	// The 3 following initializations are done even if the default HW values are the same 
	WepCcmFcMask.val = REG_MAC_WEP_CCM_FC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_CCM_FC_MASK, WepCcmFcMask.val);

	WepCcmScMask.bitFields.ccmScMask = REG_MAC_WEP_CCM_SC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_CCM_SC_MASK, WepCcmScMask.val);

	WepCcmQcMask.val = REG_MAC_WEP_CCM_QC_MASK_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_CCM_QC_MASK, WepCcmQcMask.val);

	WepFullHwEnc.bitFields.fullHwEnc = REG_MAC_WEP_FULL_HW_ENC_FULL_HW_ENC_DEFAULT;
	WepFullHwEnc.bitFields.rc4PreInitHwEn = REG_MAC_WEP_FULL_HW_ENC_RC4_PRE_INIT_HW_EN_DEFAULT; 
	WepFullHwEnc.bitFields.descriptorListEn = REG_MAC_WEP_FULL_HW_ENC_DESCRIPTOR_LIST_EN_DEFAULT; 
	WepFullHwEnc.bitFields.txDescModeGenErrIrqEn = TRUE;
	WepFullHwEnc.bitFields.rxDescModeGenErrIrqEn = FALSE;	
	RegAccess_Write(REG_MAC_WEP_FULL_HW_ENC, WepFullHwEnc.val);

	WepStartEntriesAddress.bitFields.startEntriesAddress = (((uint32)KeysDatabase) & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	WepStartEntriesAddress.bitFields.dbEntrySize = REG_MAC_WEP_START_ENTRIES_ADDRESS_DB_ENTRY_SIZE_DEFAULT;
	WepStartEntriesAddress.bitFields.differentDest = REG_MAC_WEP_START_ENTRIES_ADDRESS_DIFFERENT_DEST_DEFAULT; 
	WepStartEntriesAddress.bitFields.prepareIv = REG_MAC_WEP_START_ENTRIES_ADDRESS_PREPARE_IV_DEFAULT;
	RegAccess_Write(REG_MAC_WEP_START_ENTRIES_ADDRESS, WepStartEntriesAddress.val);

	WepLengthOffset.bitFields.lengthOffsetEncrypt = REG_MAC_WEP_LENGTH_OFFSET_LENGTH_OFFSET_ENCRYPT_DEFAULT;
	WepLengthOffset.bitFields.lengthOffsetDecrypt = REG_MAC_WEP_LENGTH_OFFSET_LENGTH_OFFSET_DECRYPT_DEFAULT;	
	RegAccess_Write(REG_MAC_WEP_LENGTH_OFFSET, WepLengthOffset.val);

	WepFragmentDbBaseAddr.bitFields.fragmentDbBaseAddr = (((uint32)tkipFragmentDb)  & REG_MAC_WEP_COMMON_ADDRESS_MASK);
	RegAccess_Write(REG_MAC_WEP_FRAGMENT_DB_BASE_ADDR, WepFragmentDbBaseAddr.val);

	// Uncomment following lines in order to change the output lists of the SEC (for debug/workarounds)
//	WepDlmMpduListIdxOut.bitFields.crDlmTxMpduListIdxOut   = ; // DLM Tx push descriptor pointer base list index.
//	WepDlmMpduListIdxOut.bitFields.crDlmRxMpduListIdxOut   = ; // DLM Rx push descriptor pointer base list index.
//	WepDlmMpduListIdxOut.bitFields.crDlmFreeMpduListIdxOut = ;	// DLM Free push descriptor pointer base list index.
//	RegAccess_Write(REG_MAC_WEP_DLM_MPDU_LIST_IDX_OUT, WepDlmMpduListIdxOut.val);

	// Turn on TX / RX security
	WepDlmFcControl.val = 0;
	WepDlmFcControl.bitFields.crEnableTxDlm = TRUE;
	WepDlmFcControl.bitFields.crEnableRxDlm = TRUE;
	RegAccess_Write(REG_MAC_WEP_DLM_FC_CONTROL, WepDlmFcControl.val);

	
}





